/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.qmf2.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.Connection;
import org.apache.qpid.qmf2.common.ObjectId;
import org.apache.qpid.qmf2.common.QmfCallback;
import org.apache.qpid.qmf2.common.QmfEventListener;
import org.apache.qpid.qmf2.common.QmfException;
import org.apache.qpid.qmf2.common.QmfQuery;
import org.apache.qpid.qmf2.common.QmfQueryTarget;
import org.apache.qpid.qmf2.common.SchemaClassId;
import org.apache.qpid.qmf2.common.WorkItem;
import org.apache.qpid.qmf2.console.Agent;
import org.apache.qpid.qmf2.console.AgentHeartbeatWorkItem;
import org.apache.qpid.qmf2.console.AgentRestartedWorkItem;
import org.apache.qpid.qmf2.console.Console;
import org.apache.qpid.qmf2.console.QmfConsoleData;
import org.apache.qpid.qmf2.console.SubscribeIndication;
import org.apache.qpid.qmf2.console.SubscribeParams;
import org.apache.qpid.qmf2.console.SubscriptionIndicationWorkItem;
import org.apache.qpid.qmf2.util.ConnectionHelper;
import org.apache.qpid.qmf2.util.GetOpt;

public final class QpidQueueStats
implements QmfEventListener {
    private static final String _usage = "Usage: QpidQueueStats [options]\n";
    private static final String _options = "Options:\n  -h, --help            show this help message and exit\n  -a <address>, --broker-address=<address>\n                        broker-addr is in the form:  [username/password@]\n                        hostname | ip-address [:<port>]   ex:  localhost,\n                        10.1.1.7:10000, broker-host:10000,\n                        guest/guest@localhost\n  -f <filter>, --filter=<filter>\n                        a list of comma separated queue names (regex are\n                        accepted) to show\n  --sasl-mechanism=<mech>\n                        SASL mechanism for authentication (e.g. EXTERNAL,\n                        ANONYMOUS, PLAIN, CRAM-MD5, DIGEST-MD5, GSSAPI). SASL\n                        automatically picks the most secure available\n                        mechanism - use this option to override.\n";
    private final String _url;
    private final List<Pattern> _filter;
    private Agent _broker;
    private Console _console;
    private Map<ObjectId, Stats> _objects = new HashMap<ObjectId, Stats>();
    private String _subscriptionId = null;
    private long _subscriptionDuration;
    private long _startTime;

    public QpidQueueStats(String url, String connectionOptions, List<Pattern> filter) {
        System.out.println("Connecting to " + url);
        if (filter.size() > 0) {
            System.out.println("Filter = " + filter);
        }
        this._url = url;
        this._filter = filter;
        try {
            Connection connection = ConnectionHelper.createConnection((String)url, (String)connectionOptions);
            this._console = new Console((QmfCallback)this);
            this._console.addConnection(connection);
            this._broker = this._console.findAgent("broker");
            if (this._broker != null) {
                this.createQueueSubscription();
            }
            System.out.println("Hit Return to exit");
            System.out.println("Queue Name                                          Sec       Depth     Enq Rate     Deq Rate");
            System.out.println("=============================================================================================");
        }
        catch (QmfException qmfe) {
            System.err.println("QmfException " + qmfe.getMessage() + " caught in QpidQueueStats constructor");
        }
    }

    private void createQueueSubscription() {
        try {
            QmfQuery query = new QmfQuery(QmfQueryTarget.OBJECT, new SchemaClassId("queue"));
            SubscribeParams params = this._console.createSubscription(this._broker, query, "queueStatsHandle");
            this._subscriptionId = params.getSubscriptionId();
            this._subscriptionDuration = params.getLifetime() - 10L;
            this._startTime = System.currentTimeMillis();
        }
        catch (QmfException qmfException) {
            // empty catch block
        }
    }

    public void onEvent(WorkItem wi) {
        SubscriptionIndicationWorkItem item;
        SubscribeIndication indication;
        String correlationId;
        if (wi instanceof AgentHeartbeatWorkItem && this._subscriptionId != null) {
            long elapsed = Math.round((float)(System.currentTimeMillis() - this._startTime) / 1000.0f);
            if (elapsed > this._subscriptionDuration) {
                try {
                    this._console.refreshSubscription(this._subscriptionId);
                    this._startTime = System.currentTimeMillis();
                }
                catch (QmfException qmfe) {
                    System.err.println("QmfException " + qmfe.getMessage() + " caught in QpidQueueStats onEvent");
                    this.createQueueSubscription();
                }
            }
        } else if (wi instanceof AgentRestartedWorkItem) {
            this._objects.clear();
        } else if (wi instanceof SubscriptionIndicationWorkItem && (correlationId = (indication = (item = (SubscriptionIndicationWorkItem)wi).getSubscribeIndication()).getConsoleHandle()).equals("queueStatsHandle")) {
            List data = indication.getData();
            for (QmfConsoleData record : data) {
                ObjectId id = record.getObjectId();
                if (record.isDeleted()) {
                    this._objects.remove(id);
                    continue;
                }
                if (this._objects.containsKey(id)) {
                    Stats stats = this._objects.get(id);
                    String name = stats.getName();
                    boolean matches = false;
                    for (Pattern x : this._filter) {
                        Matcher m = x.matcher(name);
                        if (!m.find()) continue;
                        matches = true;
                        break;
                    }
                    if (!this._filter.isEmpty() && !matches) continue;
                    QmfConsoleData lastSample = stats.getData();
                    stats.setData(record);
                    float deltaTime = record.getUpdateTime() - lastSample.getUpdateTime();
                    if (!(deltaTime > 1.0E9f)) continue;
                    float deltaEnqueues = record.getLongValue("msgTotalEnqueues") - lastSample.getLongValue("msgTotalEnqueues");
                    float deltaDequeues = record.getLongValue("msgTotalDequeues") - lastSample.getLongValue("msgTotalDequeues");
                    long msgDepth = record.getLongValue("msgDepth");
                    float enqueueRate = deltaEnqueues / (deltaTime / 1.0E9f);
                    float dequeueRate = deltaDequeues / (deltaTime / 1.0E9f);
                    System.out.printf("%-46s%10.2f%11d%13.2f%13.2f\n", name, Float.valueOf(deltaTime / 1.0E9f), msgDepth, Float.valueOf(enqueueRate), Float.valueOf(dequeueRate));
                    continue;
                }
                if (!record.hasValue("name")) {
                    try {
                        record.refresh();
                    }
                    catch (QmfException qmfe) {
                        // empty catch block
                    }
                }
                String queueName = record.getStringValue("name");
                this._objects.put(id, new Stats(queueName, record));
            }
        }
    }

    public static void main(String[] args) {
        String logLevel = System.getProperty("amqj.logging.level");
        logLevel = logLevel == null ? "FATAL" : logLevel;
        System.setProperty("amqj.logging.level", logLevel);
        String[] longOpts = new String[]{"help", "broker-address=", "filter=", "sasl-mechanism="};
        try {
            String host = "localhost";
            String connectionOptions = "{reconnect: true}";
            ArrayList<Pattern> filter = new ArrayList<Pattern>();
            GetOpt getopt = new GetOpt(args, "ha:f:", longOpts);
            List optList = getopt.getOptList();
            for (String[] opt : optList) {
                if (opt[0].equals("-h") || opt[0].equals("--help")) {
                    System.out.println(_usage);
                    System.out.println(_options);
                    System.exit(1);
                    continue;
                }
                if (opt[0].equals("-a") || opt[0].equals("--broker-address")) {
                    host = opt[1];
                    continue;
                }
                if (opt[0].equals("-f") || opt[0].equals("--filter")) {
                    String[] split;
                    for (String s : split = opt[1].split(",")) {
                        Pattern p = Pattern.compile(s);
                        filter.add(p);
                    }
                    continue;
                }
                if (!opt[0].equals("--sasl-mechanism")) continue;
                connectionOptions = "{reconnect: true, sasl_mechs: " + opt[1] + "}";
            }
            QpidQueueStats queueStats = new QpidQueueStats(host, connectionOptions, filter);
        }
        catch (IllegalArgumentException e) {
            System.out.println(_usage);
            System.out.println(e.getMessage());
            System.exit(1);
        }
        BufferedReader commandLine = new BufferedReader(new InputStreamReader(System.in));
        try {
            String s = commandLine.readLine();
            System.exit(0);
        }
        catch (IOException e) {
            System.out.println("QpidQueueStats main(): IOException: " + e.getMessage());
        }
    }

    private final class Stats {
        private final String _name;
        private QmfConsoleData _data;

        public Stats(String name, QmfConsoleData data) {
            this._name = name;
            this._data = data;
        }

        public String getName() {
            return this._name;
        }

        public QmfConsoleData getData() {
            return this._data;
        }

        public void setData(QmfConsoleData data) {
            this._data = data;
        }
    }
}

