/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.nio.ByteBuffer;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.DataStreamPacketHeader;
import org.apache.ratis.protocol.DataStreamReply;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStreamReplyHeader
extends DataStreamPacketHeader
implements DataStreamReply {
    private static final Logger LOG = LoggerFactory.getLogger(DataStreamReplyHeader.class);
    private final long bytesWritten;
    private final boolean success;

    public static DataStreamReplyHeader read(ByteBuf buf) {
        if (DataStreamReplyHeader.getSizeOfHeaderLen() > buf.readableBytes()) {
            return null;
        }
        int headerBufLen = buf.readInt();
        if (headerBufLen > buf.readableBytes()) {
            buf.resetReaderIndex();
            return null;
        }
        try {
            ByteBuf headerBuf = buf.slice(buf.readerIndex(), headerBufLen);
            RaftProtos.DataStreamReplyHeaderProto header = RaftProtos.DataStreamReplyHeaderProto.parseFrom((ByteBuffer)headerBuf.nioBuffer());
            RaftProtos.DataStreamPacketHeaderProto h = header.getPacketHeader();
            if (header.getPacketHeader().getDataLength() + (long)headerBufLen <= (long)buf.readableBytes()) {
                buf.readerIndex(buf.readerIndex() + headerBufLen);
                return new DataStreamReplyHeader(ClientId.valueOf(h.getClientId()), h.getType(), h.getStreamId(), h.getStreamOffset(), h.getDataLength(), header.getBytesWritten(), header.getSuccess());
            }
            buf.resetReaderIndex();
            return null;
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Fail to decode reply header:", (Throwable)e);
            buf.resetReaderIndex();
            return null;
        }
    }

    public DataStreamReplyHeader(ClientId clientId, RaftProtos.DataStreamPacketHeaderProto.Type type, long streamId, long streamOffset, long dataLength, long bytesWritten, boolean success) {
        super(clientId, type, streamId, streamOffset, dataLength);
        this.bytesWritten = bytesWritten;
        this.success = success;
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }
}

