/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.NetUtils;

public final class RaftPeer {
    private static final RaftPeer[] EMPTY_ARRAY = new RaftPeer[0];
    private final RaftPeerId id;
    private final String address;
    private final String adminAddress;
    private final String clientAddress;
    private final String dataStreamAddress;
    private final int priority;
    private final Supplier<RaftProtos.RaftPeerProto> raftPeerProto;

    public static RaftPeer[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(RaftPeer peer) {
        Objects.requireNonNull(peer, "peer == null");
        return RaftPeer.newBuilder().setId(peer.getId()).setAddress(peer.getAddress()).setAdminAddress(peer.getAdminAddress()).setClientAddress(peer.getClientAddress()).setDataStreamAddress(peer.getDataStreamAddress()).setPriority(peer.getPriority());
    }

    private RaftPeer(RaftPeerId id, String address, String adminAddress, String clientAddress, String dataStreamAddress, int priority) {
        this.id = Objects.requireNonNull(id, "id == null");
        this.address = address;
        this.dataStreamAddress = dataStreamAddress;
        this.adminAddress = adminAddress;
        this.clientAddress = clientAddress;
        this.priority = priority;
        this.raftPeerProto = JavaUtils.memoize(this::buildRaftPeerProto);
    }

    private RaftProtos.RaftPeerProto buildRaftPeerProto() {
        RaftProtos.RaftPeerProto.Builder builder = RaftProtos.RaftPeerProto.newBuilder().setId(this.getId().toByteString());
        Optional.ofNullable(this.getAddress()).ifPresent(arg_0 -> ((RaftProtos.RaftPeerProto.Builder)builder).setAddress(arg_0));
        Optional.ofNullable(this.getDataStreamAddress()).ifPresent(arg_0 -> ((RaftProtos.RaftPeerProto.Builder)builder).setDataStreamAddress(arg_0));
        Optional.ofNullable(this.getClientAddress()).ifPresent(arg_0 -> ((RaftProtos.RaftPeerProto.Builder)builder).setClientAddress(arg_0));
        Optional.ofNullable(this.getAdminAddress()).ifPresent(arg_0 -> ((RaftProtos.RaftPeerProto.Builder)builder).setAdminAddress(arg_0));
        builder.setPriority(this.priority);
        return builder.build();
    }

    public RaftPeerId getId() {
        return this.id;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAdminAddress() {
        return this.adminAddress;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public String getDataStreamAddress() {
        return this.dataStreamAddress;
    }

    public int getPriority() {
        return this.priority;
    }

    public RaftProtos.RaftPeerProto getRaftPeerProto() {
        return this.raftPeerProto.get();
    }

    public String toString() {
        String rpc = this.address != null ? "|rpc:" + this.address : "";
        String admin = this.adminAddress != null && !Objects.equals(this.address, this.adminAddress) ? "|admin:" + this.adminAddress : "";
        String client = this.clientAddress != null && !Objects.equals(this.address, this.clientAddress) ? "|client:" + this.clientAddress : "";
        String data = this.dataStreamAddress != null ? "|dataStream:" + this.dataStreamAddress : "";
        String p = "|priority:" + this.priority;
        return this.id + rpc + admin + client + data + p;
    }

    public boolean equals(Object o) {
        return o instanceof RaftPeer && this.id.equals(((RaftPeer)o).getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static class Builder {
        private RaftPeerId id;
        private String address;
        private String adminAddress;
        private String clientAddress;
        private String dataStreamAddress;
        private int priority;

        public Builder setId(RaftPeerId id) {
            this.id = id;
            return this;
        }

        public Builder setId(String id) {
            return this.setId(RaftPeerId.valueOf(id));
        }

        public Builder setId(ByteString id) {
            return this.setId(RaftPeerId.valueOf(id));
        }

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public Builder setAddress(InetSocketAddress address) {
            return this.setAddress(NetUtils.address2String(address));
        }

        public Builder setAdminAddress(String addr) {
            this.adminAddress = addr;
            return this;
        }

        public Builder setAdminAddress(InetSocketAddress addr) {
            return this.setAdminAddress(NetUtils.address2String(addr));
        }

        public Builder setClientAddress(String addr) {
            this.clientAddress = addr;
            return this;
        }

        public Builder setClientAddress(InetSocketAddress addr) {
            return this.setClientAddress(NetUtils.address2String(addr));
        }

        public Builder setDataStreamAddress(String dataStreamAddress) {
            this.dataStreamAddress = dataStreamAddress;
            return this;
        }

        public Builder setDataStreamAddress(InetSocketAddress dataStreamAddress) {
            return this.setDataStreamAddress(NetUtils.address2String(dataStreamAddress));
        }

        public Builder setPriority(int priority) {
            if (priority < 0) {
                throw new IllegalArgumentException("priority = " + priority + " < 0");
            }
            this.priority = priority;
            return this;
        }

        public RaftPeer build() {
            return new RaftPeer(Objects.requireNonNull(this.id, "The 'id' field is not initialized."), this.address, this.adminAddress, this.clientAddress, this.dataStreamAddress, this.priority);
        }
    }

    public static interface Add {
        public void addRaftPeers(Collection<RaftPeer> var1);

        default public void addRaftPeers(RaftPeer ... peers) {
            this.addRaftPeers(Arrays.asList(peers));
        }
    }
}

