/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.util;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.util.function.CheckedFunction;

public interface AtomicUtils {
    public static void updateMin(AtomicLong min, long value) {
        long cur;
        while (value < (cur = min.get()) && !min.compareAndSet(cur, value)) {
        }
    }

    public static void updateMax(AtomicLong max, long value) {
        long cur;
        while (value > (cur = max.get()) && !max.compareAndSet(cur, value)) {
        }
    }

    public static <E, THROWABLE extends Throwable> E updateAndGet(AtomicReference<E> reference, CheckedFunction<E, E, THROWABLE> update) throws THROWABLE {
        AtomicReference throwableRef = new AtomicReference();
        E updated = reference.updateAndGet(value -> {
            try {
                return update.apply(value);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throwableRef.set(t);
                return value;
            }
        });
        Throwable t = (Throwable)throwableRef.get();
        if (t != null) {
            throw t;
        }
        return updated;
    }
}

