/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.leader;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.leader.FollowerInfo;
import org.apache.ratis.server.leader.LeaderState;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LogAppender {
    public static final Logger LOG = LoggerFactory.getLogger(LogAppender.class);
    public static final Class<? extends LogAppender> DEFAULT_CLASS = ReflectionUtils.getClass((String)(LogAppender.class.getName() + "Default"), LogAppender.class);

    public static LogAppender newLogAppenderDefault(RaftServer.Division server, LeaderState leaderState, FollowerInfo f) {
        Class[] argClasses = new Class[]{RaftServer.Division.class, LeaderState.class, FollowerInfo.class};
        return (LogAppender)ReflectionUtils.newInstance(DEFAULT_CLASS, (Class[])argClasses, (Object[])new Object[]{server, leaderState, f});
    }

    public RaftServer.Division getServer();

    default public RaftServerRpc getServerRpc() {
        return this.getServer().getRaftServer().getServerRpc();
    }

    default public RaftLog getRaftLog() {
        return this.getServer().getRaftLog();
    }

    public void start();

    public boolean isRunning();

    public void stop();

    public LeaderState getLeaderState();

    public FollowerInfo getFollower();

    default public RaftPeerId getFollowerId() {
        return this.getFollower().getPeer().getId();
    }

    public RaftProtos.AppendEntriesRequestProto newAppendEntriesRequest(long var1, boolean var3) throws RaftLogIOException;

    public RaftProtos.InstallSnapshotRequestProto newInstallSnapshotNotificationRequest(TermIndex var1);

    public Iterable<RaftProtos.InstallSnapshotRequestProto> newInstallSnapshotRequests(String var1, SnapshotInfo var2);

    default public SnapshotInfo shouldInstallSnapshot() {
        long followerNextIndex = this.getFollower().getNextIndex();
        if (followerNextIndex < this.getRaftLog().getNextIndex()) {
            long logStartIndex = this.getRaftLog().getStartIndex();
            SnapshotInfo snapshot = this.getServer().getStateMachine().getLatestSnapshot();
            if (followerNextIndex < logStartIndex || logStartIndex == -1L && snapshot != null) {
                return snapshot;
            }
        }
        return null;
    }

    public void run() throws InterruptedException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    default public void notifyLogAppender() {
        LogAppender logAppender = this;
        synchronized (logAppender) {
            this.notify();
        }
    }

    default public boolean shouldSendAppendEntries() {
        return this.hasAppendEntries() || this.shouldHeartbeat();
    }

    default public boolean hasAppendEntries() {
        return this.getFollower().getNextIndex() < this.getRaftLog().getNextIndex();
    }

    default public boolean shouldHeartbeat() {
        return this.getHeartbeatRemainingTimeMs() <= 0L;
    }

    default public long getHeartbeatRemainingTimeMs() {
        return (long)(this.getServer().properties().minRpcTimeoutMs() / 2) - this.getFollower().getLastRpcTime().elapsedTimeMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean onFollowerTerm(long followerTerm) {
        RaftServer.Division division = this.getServer();
        synchronized (division) {
            return this.isRunning() && this.getLeaderState().onFollowerTerm(this.getFollower(), followerTerm);
        }
    }
}

