/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftConfiguration;
import org.apache.ratis.server.impl.PeerConfiguration;
import org.apache.ratis.util.Preconditions;

final class RaftConfigurationImpl
implements RaftConfiguration {
    private final PeerConfiguration oldConf;
    private final PeerConfiguration conf;
    private final long logEntryIndex;

    static Builder newBuilder() {
        return new Builder();
    }

    private RaftConfigurationImpl(PeerConfiguration conf, PeerConfiguration oldConf, long logEntryIndex) {
        this.conf = Objects.requireNonNull(conf);
        this.oldConf = oldConf;
        this.logEntryIndex = logEntryIndex;
    }

    boolean isTransitional() {
        return this.oldConf != null;
    }

    boolean isStable() {
        return this.oldConf == null;
    }

    boolean containsInConf(RaftPeerId peerId) {
        return this.conf.contains(peerId);
    }

    boolean isHighestPriority(RaftPeerId peerId) {
        RaftPeer target = this.getPeer(peerId);
        Collection<RaftPeer> peers = this.getCurrentPeers();
        for (RaftPeer peer : peers) {
            if (peer.getPriority() < target.getPriority() || peer.equals((Object)target)) continue;
            return false;
        }
        return true;
    }

    boolean containsInOldConf(RaftPeerId peerId) {
        return this.oldConf != null && this.oldConf.contains(peerId);
    }

    boolean containsInBothConfs(RaftPeerId peerId) {
        return this.containsInConf(peerId) && (this.oldConf == null || this.containsInOldConf(peerId));
    }

    public RaftPeer getPeer(RaftPeerId id) {
        if (id == null) {
            return null;
        }
        RaftPeer peer = this.conf.getPeer(id);
        if (peer != null) {
            return peer;
        }
        if (this.oldConf != null) {
            return this.oldConf.getPeer(id);
        }
        return null;
    }

    public Collection<RaftPeer> getAllPeers() {
        ArrayList<RaftPeer> peers = new ArrayList<RaftPeer>(this.conf.getPeers());
        if (this.oldConf != null) {
            this.oldConf.getPeers().stream().filter(p -> !peers.contains(p)).forEach(peers::add);
        }
        return peers;
    }

    Collection<RaftPeer> getOtherPeers(RaftPeerId selfId) {
        List<RaftPeer> others = this.conf.getOtherPeers(selfId);
        if (this.oldConf != null) {
            this.oldConf.getOtherPeers(selfId).stream().filter(p -> !others.contains(p)).forEach(others::add);
        }
        return others;
    }

    boolean hasMajority(Collection<RaftPeerId> others, RaftPeerId selfId) {
        Preconditions.assertTrue((!others.contains(selfId) ? 1 : 0) != 0);
        return this.conf.hasMajority(others, selfId) && (this.oldConf == null || this.oldConf.hasMajority(others, selfId));
    }

    boolean majorityRejectVotes(Collection<RaftPeerId> rejects) {
        return this.conf.majorityRejectVotes(rejects) || this.oldConf != null && this.oldConf.majorityRejectVotes(rejects);
    }

    public String toString() {
        return this.logEntryIndex + ": " + this.conf + ", old=" + this.oldConf;
    }

    boolean hasNoChange(Collection<RaftPeer> newMembers) {
        if (!this.isStable() || this.conf.size() != newMembers.size()) {
            return false;
        }
        for (RaftPeer peer : newMembers) {
            if (this.conf.contains(peer.getId()) && this.conf.getPeer(peer.getId()).getPriority() == peer.getPriority()) continue;
            return false;
        }
        return true;
    }

    public long getLogEntryIndex() {
        return this.logEntryIndex;
    }

    Collection<RaftPeer> filterNotContainedInConf(List<RaftPeer> peers) {
        return peers.stream().filter(p -> !this.containsInConf(p.getId())).collect(Collectors.toList());
    }

    public Collection<RaftPeer> getPreviousPeers() {
        return this.oldConf != null ? this.oldConf.getPeers() : Collections.emptyList();
    }

    public Collection<RaftPeer> getCurrentPeers() {
        return this.conf.getPeers();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RaftConfigurationImpl that = (RaftConfigurationImpl)obj;
        return this.logEntryIndex == that.logEntryIndex && Objects.equals(this.conf, that.conf) && Objects.equals(this.oldConf, that.oldConf);
    }

    public int hashCode() {
        return Long.hashCode(this.logEntryIndex);
    }

    static final class Builder {
        private PeerConfiguration oldConf;
        private PeerConfiguration conf;
        private long logEntryIndex = -1L;
        private boolean forceStable = false;
        private boolean forceTransitional = false;

        private Builder() {
        }

        Builder setConf(PeerConfiguration conf) {
            Objects.requireNonNull(conf);
            Preconditions.assertTrue((this.conf == null ? 1 : 0) != 0, (Object)"conf is already set.");
            this.conf = conf;
            return this;
        }

        Builder setConf(Iterable<RaftPeer> peers) {
            return this.setConf(new PeerConfiguration(peers));
        }

        Builder setConf(RaftConfigurationImpl transitionalConf) {
            Objects.requireNonNull(transitionalConf);
            Preconditions.assertTrue((boolean)transitionalConf.isTransitional());
            Preconditions.assertTrue((!this.forceTransitional ? 1 : 0) != 0);
            this.forceStable = true;
            return this.setConf(transitionalConf.conf);
        }

        Builder setOldConf(PeerConfiguration oldConf) {
            Objects.requireNonNull(oldConf);
            Preconditions.assertTrue((this.oldConf == null ? 1 : 0) != 0, (Object)"oldConf is already set.");
            this.oldConf = oldConf;
            return this;
        }

        Builder setOldConf(Iterable<RaftPeer> oldPeers) {
            return this.setOldConf(new PeerConfiguration(oldPeers));
        }

        Builder setOldConf(RaftConfigurationImpl stableConf) {
            Objects.requireNonNull(stableConf);
            Preconditions.assertTrue((boolean)stableConf.isStable());
            Preconditions.assertTrue((!this.forceStable ? 1 : 0) != 0);
            this.forceTransitional = true;
            return this.setOldConf(stableConf.conf);
        }

        Builder setLogEntryIndex(long logEntryIndex) {
            Preconditions.assertTrue((logEntryIndex != -1L ? 1 : 0) != 0);
            Preconditions.assertTrue((this.logEntryIndex == -1L ? 1 : 0) != 0, (Object)"logEntryIndex is already set.");
            this.logEntryIndex = logEntryIndex;
            return this;
        }

        RaftConfigurationImpl build() {
            if (this.forceTransitional) {
                Preconditions.assertTrue((this.oldConf != null ? 1 : 0) != 0);
            }
            if (this.forceStable) {
                Preconditions.assertTrue((this.oldConf == null ? 1 : 0) != 0);
            }
            return new RaftConfigurationImpl(this.conf, this.oldConf, this.logEntryIndex);
        }
    }
}

