/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Level;
import org.apache.ratis.BaseTest;
import org.apache.ratis.RaftTestUtil;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.exceptions.GroupMismatchException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.StaleReadException;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.MiniRaftCluster;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Log4jUtils;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.slf4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class RaftExceptionBaseTest<CLUSTER extends MiniRaftCluster>
extends BaseTest
implements MiniRaftCluster.Factory.Get<CLUSTER> {
    static final int NUM_PEERS = 3;

    public RaftExceptionBaseTest() {
        RaftServerConfigKeys.Log.Appender.setBufferByteLimit((RaftProperties)this.getProperties(), (SizeInBytes)SizeInBytes.valueOf((String)"4KB"));
    }

    @Test
    public void testHandleNotLeaderException() throws Exception {
        this.runWithNewCluster(3, cluster -> this.runTestHandleNotLeaderException(cluster));
    }

    void runTestHandleNotLeaderException(CLUSTER cluster) throws Exception {
        RaftPeerId oldLeader = RaftTestUtil.waitForLeader(cluster).getId();
        try (RaftClient client = cluster.createClient(oldLeader);){
            RaftExceptionBaseTest.sendMessage((String)"m1", (RaftClient)client);
            RaftPeerId newLeader = RaftTestUtil.changeLeader(cluster, (RaftPeerId)oldLeader);
            RaftClientRpc rpc = client.getClientRpc();
            JavaUtils.attemptRepeatedly(() -> this.assertNotLeaderException(newLeader, "m2", oldLeader, rpc, cluster), (int)10, (TimeDuration)ONE_SECOND, (String)"assertNotLeaderException", (Logger)this.LOG);
            RaftExceptionBaseTest.sendMessage((String)"m3", (RaftClient)client);
        }
    }

    RaftClientReply assertNotLeaderException(RaftPeerId expectedSuggestedLeader, String messageId, RaftPeerId server, RaftClientRpc rpc, CLUSTER cluster) throws IOException {
        RaftTestUtil.SimpleMessage message = new RaftTestUtil.SimpleMessage(messageId);
        RaftClientReply reply = rpc.sendRequest(cluster.newRaftClientRequest(ClientId.randomId(), server, (Message)message));
        Assert.assertNotNull((Object)reply);
        Assume.assumeFalse((boolean)reply.isSuccess());
        NotLeaderException nle = reply.getNotLeaderException();
        Objects.requireNonNull(nle);
        Assert.assertEquals((Object)expectedSuggestedLeader, (Object)nle.getSuggestedLeader().getId());
        return reply;
    }

    static void sendMessage(String message, RaftClient client) throws IOException {
        RaftClientReply reply = client.io().send((Message)new RaftTestUtil.SimpleMessage(message));
        Assert.assertTrue((boolean)reply.isSuccess());
    }

    @Test
    public void testNotLeaderExceptionWithReconf() throws Exception {
        this.runWithNewCluster(3, arg_0 -> this.runTestNotLeaderExceptionWithReconf(arg_0));
    }

    void runTestNotLeaderExceptionWithReconf(CLUSTER cluster) throws Exception {
        RaftPeerId oldLeader = RaftTestUtil.waitForLeader(cluster).getId();
        try (RaftClient client = cluster.createClient(oldLeader);){
            RaftPeerId newLeader = RaftTestUtil.changeLeader(cluster, (RaftPeerId)oldLeader);
            MiniRaftCluster.PeerChanges change = cluster.addNewPeers(new String[]{"ss1", "ss2"}, true, false);
            this.LOG.info("Start changing the configuration: {}", Arrays.asList(change.allPeersInNewConf));
            try (RaftClient c2 = cluster.createClient(newLeader);){
                RaftClientReply reply = c2.admin().setConfiguration(change.allPeersInNewConf);
                Assert.assertTrue((boolean)reply.isSuccess());
            }
            this.LOG.info(cluster.printServers());
            RaftClientRpc rpc = client.getClientRpc();
            RaftClientReply reply = (RaftClientReply)JavaUtils.attemptRepeatedly(() -> this.assertNotLeaderException(newLeader, "m1", oldLeader, rpc, cluster), (int)10, (TimeDuration)ONE_SECOND, (String)"assertNotLeaderException", (Logger)this.LOG);
            List peers = cluster.getPeers();
            Collection peersFromReply = reply.getNotLeaderException().getPeers();
            Assert.assertEquals((long)peers.size(), (long)peersFromReply.size());
            for (RaftPeer p : peersFromReply) {
                Assert.assertTrue((boolean)peers.contains(p));
            }
            RaftExceptionBaseTest.sendMessage((String)"m2", (RaftClient)client);
        }
    }

    @Test
    public void testGroupMismatchException() throws Exception {
        this.runWithSameCluster(3, arg_0 -> this.runTestGroupMismatchException(arg_0));
    }

    void runTestGroupMismatchException(CLUSTER cluster) throws Exception {
        RaftGroup clusterGroup = cluster.getGroup();
        Assert.assertEquals((long)3L, (long)clusterGroup.getPeers().size());
        RaftGroup anotherGroup = RaftGroup.valueOf((RaftGroupId)RaftGroupId.randomId(), (Collection)clusterGroup.getPeers());
        Assert.assertNotEquals((Object)clusterGroup.getGroupId(), (Object)anotherGroup.getGroupId());
        try (RaftClient client = cluster.createClient(anotherGroup);){
            this.testFailureCase("send(..) with client group being different from the server group", () -> client.io().send(Message.EMPTY), GroupMismatchException.class, new Class[0]);
            this.testFailureCase("sendReadOnly(..) with client group being different from the server group", () -> client.io().sendReadOnly(Message.EMPTY), GroupMismatchException.class, new Class[0]);
            this.testFailureCase("setConfiguration(..) with client group being different from the server group", () -> client.admin().setConfiguration(RaftPeer.emptyArray()), GroupMismatchException.class, new Class[0]);
            this.testFailureCase("groupRemove(..) with another group id", () -> client.getGroupManagementApi(((RaftPeer)clusterGroup.getPeers().iterator().next()).getId()).remove(anotherGroup.getGroupId(), false, false), GroupMismatchException.class, new Class[0]);
        }
    }

    @Test
    public void testStaleReadException() throws Exception {
        this.runWithSameCluster(3, arg_0 -> this.runTestStaleReadException(arg_0));
    }

    void runTestStaleReadException(CLUSTER cluster) throws Exception {
        RaftTestUtil.waitForLeader(cluster);
        try (RaftClient client = cluster.createClient();){
            RaftPeerId follower = ((RaftServer.Division)cluster.getFollowers().iterator().next()).getId();
            this.testFailureCase("sendStaleRead(..) with a large commit index", () -> client.io().sendStaleRead(Message.EMPTY, 1000000000L, follower), StateMachineException.class, new Class[]{StaleReadException.class});
        }
    }

    @Test
    public void testLogAppenderBufferCapacity() throws Exception {
        this.runWithSameCluster(3, arg_0 -> this.runTestLogAppenderBufferCapacity(arg_0));
    }

    void runTestLogAppenderBufferCapacity(CLUSTER cluster) throws Exception {
        RaftPeerId leaderId = RaftTestUtil.waitForLeader(cluster).getId();
        byte[] bytes = new byte[8192];
        Arrays.fill(bytes, (byte)1);
        RaftTestUtil.SimpleMessage msg = new RaftTestUtil.SimpleMessage(new String(bytes));
        try (RaftClient client = cluster.createClient(leaderId);){
            this.testFailureCase("testLogAppenderBufferCapacity", () -> client.io().send((Message)msg), StateMachineException.class, new Class[]{RaftLogIOException.class});
        }
    }

    static {
        Log4jUtils.setLogLevel((Logger)RaftServer.Division.LOG, (Level)Level.DEBUG);
        Log4jUtils.setLogLevel((Logger)RaftLog.LOG, (Level)Level.DEBUG);
        Log4jUtils.setLogLevel((Logger)RaftClient.LOG, (Level)Level.DEBUG);
    }
}

