/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import com.codahale.metrics.Timer;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.management.ObjectName;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientAsynchronousProtocol;
import org.apache.ratis.protocol.RaftClientMessage;
import org.apache.ratis.protocol.RaftClientProtocol;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ratis.protocol.exceptions.GroupMismatchException;
import org.apache.ratis.protocol.exceptions.LeaderNotReadyException;
import org.apache.ratis.protocol.exceptions.LeaderSteppingDownException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.protocol.exceptions.ReconfigurationInProgressException;
import org.apache.ratis.protocol.exceptions.ResourceUnavailableException;
import org.apache.ratis.protocol.exceptions.ServerNotReadyException;
import org.apache.ratis.protocol.exceptions.StaleReadException;
import org.apache.ratis.protocol.exceptions.StateMachineException;
import org.apache.ratis.protocol.exceptions.TransferLeadershipException;
import org.apache.ratis.server.DataStreamMap;
import org.apache.ratis.server.DivisionInfo;
import org.apache.ratis.server.DivisionProperties;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.RaftServerMXBean;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.impl.CommitInfoCache;
import org.apache.ratis.server.impl.DataStreamMapImpl;
import org.apache.ratis.server.impl.DivisionPropertiesImpl;
import org.apache.ratis.server.impl.FollowerState;
import org.apache.ratis.server.impl.LeaderElection;
import org.apache.ratis.server.impl.LeaderStateImpl;
import org.apache.ratis.server.impl.PendingRequest;
import org.apache.ratis.server.impl.PendingRequests;
import org.apache.ratis.server.impl.RaftConfigurationImpl;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.server.impl.RaftServerProxy;
import org.apache.ratis.server.impl.RetryCacheImpl;
import org.apache.ratis.server.impl.RoleInfo;
import org.apache.ratis.server.impl.ServerImplUtils;
import org.apache.ratis.server.impl.ServerProtoUtils;
import org.apache.ratis.server.impl.ServerState;
import org.apache.ratis.server.impl.TransferLeadership;
import org.apache.ratis.server.impl.VoteContext;
import org.apache.ratis.server.leader.FollowerInfo;
import org.apache.ratis.server.leader.LeaderState;
import org.apache.ratis.server.leader.LogAppender;
import org.apache.ratis.server.metrics.LeaderElectionMetrics;
import org.apache.ratis.server.metrics.RaftServerMetricsImpl;
import org.apache.ratis.server.protocol.RaftServerAsynchronousProtocol;
import org.apache.ratis.server.protocol.RaftServerProtocol;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.server.storage.RaftStorageDirectory;
import org.apache.ratis.server.util.ServerStringUtils;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.FileUtils;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.JmxRegister;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.Timestamp;

/*
 * Exception performing whole class analysis ignored.
 */
class RaftServerImpl
implements RaftServer.Division,
RaftServerProtocol,
RaftServerAsynchronousProtocol,
RaftClientProtocol,
RaftClientAsynchronousProtocol {
    private static final String CLASS_NAME = JavaUtils.getClassSimpleName(RaftServerImpl.class);
    static final String REQUEST_VOTE = CLASS_NAME + ".requestVote";
    static final String APPEND_ENTRIES = CLASS_NAME + ".appendEntries";
    static final String INSTALL_SNAPSHOT = CLASS_NAME + ".installSnapshot";
    static final String LOG_SYNC = APPEND_ENTRIES + ".logComplete";
    static final String START_LEADER_ELECTION = CLASS_NAME + ".startLeaderElection";
    private final RaftServerProxy proxy;
    private final StateMachine stateMachine;
    private final Info info = new Info(this);
    private final DivisionProperties divisionProperties;
    private final int maxTimeoutMs;
    private final TimeDuration leaderStepDownWaitTime;
    private final TimeDuration sleepDeviationThreshold;
    private final boolean installSnapshotEnabled;
    private final LifeCycle lifeCycle;
    private final ServerState state;
    private final RoleInfo role;
    private final DataStreamMap dataStreamMap;
    private final MemoizedSupplier<RaftClient> raftClient;
    private final RetryCacheImpl retryCache;
    private final CommitInfoCache commitInfoCache = new CommitInfoCache();
    private final RaftServerJmxAdapter jmxAdapter;
    private final LeaderElectionMetrics leaderElectionMetrics;
    private final RaftServerMetricsImpl raftServerMetrics;
    private final AtomicLong inProgressInstallSnapshotRequest;
    private final AtomicLong installedSnapshotIndex;
    private final AtomicBoolean isSnapshotNull;
    private final AtomicBoolean startComplete;
    private final TransferLeadership transferLeadership;

    RaftServerImpl(RaftGroup group, StateMachine stateMachine, RaftServerProxy proxy) throws IOException {
        RaftPeerId id = proxy.getId();
        LOG.info("{}: new RaftServerImpl for {} with {}", new Object[]{id, group, stateMachine});
        this.lifeCycle = new LifeCycle((Object)id);
        this.stateMachine = stateMachine;
        this.role = new RoleInfo(id);
        RaftProperties properties = proxy.getProperties();
        this.divisionProperties = new DivisionPropertiesImpl(properties);
        this.maxTimeoutMs = this.properties().maxRpcTimeoutMs();
        this.leaderStepDownWaitTime = RaftServerConfigKeys.LeaderElection.leaderStepDownWaitTime((RaftProperties)properties);
        this.sleepDeviationThreshold = RaftServerConfigKeys.sleepDeviationThreshold((RaftProperties)properties);
        this.installSnapshotEnabled = RaftServerConfigKeys.Log.Appender.installSnapshotEnabled((RaftProperties)properties);
        this.proxy = proxy;
        this.state = new ServerState(id, group, properties, this, stateMachine);
        this.retryCache = new RetryCacheImpl(properties);
        this.inProgressInstallSnapshotRequest = new AtomicLong();
        this.installedSnapshotIndex = new AtomicLong();
        this.isSnapshotNull = new AtomicBoolean(false);
        this.dataStreamMap = new DataStreamMapImpl((Object)id);
        this.jmxAdapter = new RaftServerJmxAdapter(this, null);
        this.leaderElectionMetrics = LeaderElectionMetrics.getLeaderElectionMetrics((RaftGroupMemberId)this.getMemberId(), () -> ((ServerState)this.state).getLastLeaderElapsedTimeMs());
        this.raftServerMetrics = RaftServerMetricsImpl.computeIfAbsentRaftServerMetrics((RaftGroupMemberId)this.getMemberId(), () -> arg_0 -> ((CommitInfoCache)this.commitInfoCache).get(arg_0), () -> ((RetryCacheImpl)this.retryCache).getStatistics());
        this.startComplete = new AtomicBoolean(false);
        this.raftClient = JavaUtils.memoize(() -> {
            RaftClient client = RaftClient.newBuilder().setRaftGroup(group).setProperties(this.getRaftServer().getProperties()).build();
            return client;
        });
        this.transferLeadership = new TransferLeadership(this);
    }

    public DivisionProperties properties() {
        return this.divisionProperties;
    }

    LogAppender newLogAppender(LeaderState leaderState, FollowerInfo f) {
        return this.getRaftServer().getFactory().newLogAppender((RaftServer.Division)this, leaderState, f);
    }

    int getMaxTimeoutMs() {
        return this.maxTimeoutMs;
    }

    TimeDuration getRandomElectionTimeout() {
        int min = this.properties().minRpcTimeoutMs();
        int millis = min + ThreadLocalRandom.current().nextInt(this.properties().maxRpcTimeoutMs() - min + 1);
        return TimeDuration.valueOf((long)millis, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    TimeDuration getLeaderStepDownWaitTime() {
        return this.leaderStepDownWaitTime;
    }

    TimeDuration getSleepDeviationThreshold() {
        return this.sleepDeviationThreshold;
    }

    public StateMachine getStateMachine() {
        return this.stateMachine;
    }

    public RaftLog getRaftLog() {
        return this.getState().getLog();
    }

    public RaftStorage getRaftStorage() {
        return this.getState().getStorage();
    }

    public DataStreamMap getDataStreamMap() {
        return this.dataStreamMap;
    }

    public RaftClient getRaftClient() {
        return (RaftClient)this.raftClient.get();
    }

    public RetryCacheImpl getRetryCache() {
        return this.retryCache;
    }

    public RaftServerProxy getRaftServer() {
        return this.proxy;
    }

    RaftServerRpc getServerRpc() {
        return this.proxy.getServerRpc();
    }

    private void setRole(RaftProtos.RaftPeerRole newRole, Object reason) {
        LOG.info("{}: changes role from {} to {} at term {} for {}", new Object[]{this.getMemberId(), this.role, newRole, this.state.getCurrentTerm(), reason});
        this.role.transitionRole(newRole);
    }

    boolean start() {
        if (!this.lifeCycle.compareAndTransition(LifeCycle.State.NEW, LifeCycle.State.STARTING)) {
            return false;
        }
        RaftConfigurationImpl conf = this.getRaftConf();
        if (conf != null && conf.containsInBothConfs(this.getId())) {
            LOG.info("{}: start as a follower, conf={}", (Object)this.getMemberId(), (Object)conf);
            this.startAsFollower();
        } else {
            LOG.info("{}: start with initializing state, conf={}", (Object)this.getMemberId(), (Object)conf);
            this.startInitializing();
        }
        RaftServerImpl.registerMBean((RaftPeerId)this.getId(), (RaftGroupId)this.getMemberId().getGroupId(), (RaftServerMXBean)this.jmxAdapter, (JmxRegister)this.jmxAdapter);
        this.state.start();
        this.startComplete.compareAndSet(false, true);
        return true;
    }

    static boolean registerMBean(RaftPeerId id, RaftGroupId groupdId, RaftServerMXBean mBean, JmxRegister jmx) {
        String prefix = "Ratis:service=RaftServer,group=" + groupdId + ",id=";
        String registered = jmx.register((Object)mBean, Arrays.asList(() -> prefix + id, () -> prefix + ObjectName.quote(id.toString())));
        return registered != null;
    }

    private void startAsFollower() {
        this.setRole(RaftProtos.RaftPeerRole.FOLLOWER, (Object)"startAsFollower");
        this.role.startFollowerState(this, (Object)"startAsFollower");
        this.lifeCycle.transition(LifeCycle.State.RUNNING);
    }

    private void startInitializing() {
        this.setRole(RaftProtos.RaftPeerRole.FOLLOWER, (Object)"startInitializing");
    }

    ServerState getState() {
        return this.state;
    }

    public RaftGroupMemberId getMemberId() {
        return this.getState().getMemberId();
    }

    public DivisionInfo getInfo() {
        return this.info;
    }

    RoleInfo getRole() {
        return this.role;
    }

    public RaftConfigurationImpl getRaftConf() {
        return this.getState().getRaftConf();
    }

    void groupRemove(boolean deleteDirectory, boolean renameDirectory) {
        block6: {
            RaftStorageDirectory dir;
            block7: {
                dir = this.state.getStorage().getStorageDir();
                this.close();
                this.getStateMachine().event().notifyGroupRemove();
                if (!deleteDirectory) break block7;
                for (int i = 0; i < 5; ++i) {
                    try {
                        FileUtils.deleteFully((File)dir.getRoot());
                        LOG.info("{}: Succeed to remove RaftStorageDirectory {}", (Object)this.getMemberId(), (Object)dir);
                        break block6;
                    }
                    catch (NoSuchFileException e) {
                        LOG.warn("{}: Some file does not exist {}", new Object[]{this.getMemberId(), dir, e});
                        continue;
                    }
                    catch (Exception ignored) {
                        LOG.error("{}: Failed to remove RaftStorageDirectory {}", new Object[]{this.getMemberId(), dir, ignored});
                        break block6;
                    }
                }
                break block6;
            }
            if (!renameDirectory) break block6;
            try {
                File toBeRemovedGroupFolder = new File(RaftServerConfigKeys.removedGroupsDir((RaftProperties)this.proxy.getProperties()), dir.getRoot().getName());
                FileUtils.moveDirectory((Path)dir.getRoot().toPath(), (Path)toBeRemovedGroupFolder.toPath());
                LOG.info("{}: Group {} is renamed successfully", (Object)this.getMemberId(), (Object)this.getGroup());
            }
            catch (IOException e) {
                LOG.warn("{}: Failed to remove group {}", new Object[]{this.getMemberId(), dir.getRoot().getName(), e});
            }
        }
    }

    public void close() {
        this.lifeCycle.checkStateAndClose(() -> {
            LOG.info("{}: shutdown", (Object)this.getMemberId());
            try {
                this.jmxAdapter.unregister();
            }
            catch (Exception ignored) {
                LOG.warn("{}: Failed to un-register RaftServer JMX bean", (Object)this.getMemberId(), (Object)ignored);
            }
            try {
                this.role.shutdownFollowerState();
            }
            catch (Exception ignored) {
                LOG.warn("{}: Failed to shutdown FollowerState", (Object)this.getMemberId(), (Object)ignored);
            }
            try {
                this.role.shutdownLeaderElection();
            }
            catch (Exception ignored) {
                LOG.warn("{}: Failed to shutdown LeaderElection", (Object)this.getMemberId(), (Object)ignored);
            }
            try {
                this.role.shutdownLeaderState(true);
            }
            catch (Exception ignored) {
                LOG.warn("{}: Failed to shutdown LeaderState monitor", (Object)this.getMemberId(), (Object)ignored);
            }
            try {
                this.state.close();
            }
            catch (Exception ignored) {
                LOG.warn("{}: Failed to close state", (Object)this.getMemberId(), (Object)ignored);
            }
            try {
                this.leaderElectionMetrics.unregister();
                this.raftServerMetrics.unregister();
                RaftServerMetricsImpl.removeRaftServerMetrics((RaftGroupMemberId)this.getMemberId());
            }
            catch (Exception ignored) {
                LOG.warn("{}: Failed to unregister metric", (Object)this.getMemberId(), (Object)ignored);
            }
            try {
                if (this.raftClient.isInitialized()) {
                    ((RaftClient)this.raftClient.get()).close();
                }
            }
            catch (Exception ignored) {
                LOG.warn("{}: Failed to close raft client", (Object)this.getMemberId(), (Object)ignored);
            }
        });
    }

    private synchronized boolean changeToFollower(long newTerm, boolean force, Object reason) {
        RaftProtos.RaftPeerRole old = this.role.getCurrentRole();
        boolean metadataUpdated = this.state.updateCurrentTerm(newTerm);
        if (old != RaftProtos.RaftPeerRole.FOLLOWER || force) {
            this.setRole(RaftProtos.RaftPeerRole.FOLLOWER, reason);
            if (old == RaftProtos.RaftPeerRole.LEADER) {
                this.role.shutdownLeaderState(false);
            } else if (old == RaftProtos.RaftPeerRole.CANDIDATE) {
                this.role.shutdownLeaderElection();
            } else if (old == RaftProtos.RaftPeerRole.FOLLOWER) {
                this.role.shutdownFollowerState();
            }
            this.role.startFollowerState(this, reason);
        }
        return metadataUpdated;
    }

    synchronized void changeToFollowerAndPersistMetadata(long newTerm, Object reason) throws IOException {
        if (this.changeToFollower(newTerm, false, reason)) {
            this.state.persistMetadata();
        }
    }

    synchronized void changeToLeader() {
        Preconditions.assertTrue((boolean)this.getInfo().isCandidate());
        this.role.shutdownLeaderElection();
        this.setRole(RaftProtos.RaftPeerRole.LEADER, (Object)"changeToLeader");
        this.state.becomeLeader();
        RaftProtos.LogEntryProto e = this.role.startLeaderState(this);
        this.getState().setRaftConf(e);
    }

    Collection<RaftProtos.CommitInfoProto> getCommitInfos() {
        ArrayList<RaftProtos.CommitInfoProto> infos = new ArrayList<RaftProtos.CommitInfoProto>();
        infos.add(this.updateCommitInfoCache());
        if (this.getInfo().isLeader()) {
            this.role.getLeaderState().ifPresent(leader -> leader.updateFollowerCommitInfos(this.commitInfoCache, infos));
        } else {
            this.getRaftConf().getAllPeers().stream().map(RaftPeer::getId).filter(id -> !id.equals((Object)this.getId())).map(arg_0 -> ((CommitInfoCache)this.commitInfoCache).get(arg_0)).filter(Objects::nonNull).forEach(infos::add);
        }
        return infos;
    }

    GroupInfoReply getGroupInfo(GroupInfoRequest request) {
        return new GroupInfoReply((RaftClientRequest)request, this.getCommitInfos(), this.getGroup(), this.getRoleInfoProto(), this.state.getStorage().getStorageDir().isHealthy());
    }

    private RaftProtos.RoleInfoProto getRoleInfoProto(RaftPeer leaderPeerInfo) {
        RaftProtos.RaftPeerRole currentRole = this.role.getCurrentRole();
        RaftProtos.RoleInfoProto.Builder roleInfo = RaftProtos.RoleInfoProto.newBuilder().setSelf(this.getPeer().getRaftPeerProto()).setRole(currentRole).setRoleElapsedTimeMs(this.role.getRoleElapsedTimeMs());
        Optional fs = this.role.getFollowerState();
        RaftProtos.ServerRpcProto leaderInfo = ServerProtoUtils.toServerRpcProto((RaftPeer)leaderPeerInfo, (long)fs.map(FollowerState::getLastRpcTime).map(Timestamp::elapsedTimeMs).orElse(0L));
        roleInfo.setFollowerInfo(RaftProtos.FollowerInfoProto.newBuilder().setLeaderInfo(leaderInfo).setOutstandingOp(fs.map(FollowerState::getOutstandingOp).orElse(0).intValue()));
        return roleInfo.build();
    }

    RaftProtos.RoleInfoProto getRoleInfoProto() {
        RaftProtos.RaftPeerRole currentRole = this.role.getCurrentRole();
        RaftProtos.RoleInfoProto.Builder roleInfo = RaftProtos.RoleInfoProto.newBuilder().setSelf(this.getPeer().getRaftPeerProto()).setRole(currentRole).setRoleElapsedTimeMs(this.role.getRoleElapsedTimeMs());
        switch (1.$SwitchMap$org$apache$ratis$proto$RaftProtos$RaftPeerRole[currentRole.ordinal()]) {
            case 1: {
                RaftProtos.CandidateInfoProto.Builder candidate = RaftProtos.CandidateInfoProto.newBuilder().setLastLeaderElapsedTimeMs(this.state.getLastLeaderElapsedTimeMs());
                roleInfo.setCandidateInfo(candidate);
                break;
            }
            case 2: {
                Optional fs = this.role.getFollowerState();
                RaftProtos.ServerRpcProto leaderInfo = ServerProtoUtils.toServerRpcProto((RaftPeer)this.getRaftConf().getPeer(this.state.getLeaderId()), (long)fs.map(FollowerState::getLastRpcTime).map(Timestamp::elapsedTimeMs).orElse(0L));
                roleInfo.setFollowerInfo(RaftProtos.FollowerInfoProto.newBuilder().setLeaderInfo(leaderInfo).setOutstandingOp(fs.map(FollowerState::getOutstandingOp).orElse(0).intValue()));
                break;
            }
            case 3: {
                this.role.getLeaderState().ifPresent(ls -> {
                    RaftProtos.LeaderInfoProto.Builder leader = RaftProtos.LeaderInfoProto.newBuilder();
                    ls.getLogAppenders().map(LogAppender::getFollower).forEach(f -> leader.addFollowerInfo(ServerProtoUtils.toServerRpcProto((RaftPeer)f.getPeer(), (long)f.getLastRpcResponseTime().elapsedTimeMs())));
                    leader.setTerm(ls.getCurrentTerm());
                    roleInfo.setLeaderInfo(leader);
                });
                break;
            }
            default: {
                throw new IllegalStateException("incorrect role of server " + currentRole);
            }
        }
        return roleInfo.build();
    }

    synchronized void changeToCandidate(boolean forceStartLeaderElection) {
        Preconditions.assertTrue((boolean)this.getInfo().isFollower());
        this.role.shutdownFollowerState();
        this.setRole(RaftProtos.RaftPeerRole.CANDIDATE, (Object)"changeToCandidate");
        if (this.state.shouldNotifyExtendedNoLeader()) {
            this.stateMachine.followerEvent().notifyExtendedNoLeader(this.getRoleInfoProto());
        }
        this.role.startLeaderElection(this, forceStartLeaderElection);
    }

    public String toString() {
        return this.role + " " + this.state + " " + this.lifeCycle.getCurrentState();
    }

    RaftClientReply.Builder newReplyBuilder(RaftClientRequest request) {
        return RaftClientReply.newBuilder().setRequest(request).setCommitInfos(this.getCommitInfos());
    }

    private RaftClientReply.Builder newReplyBuilder(ClientInvocationId invocationId, long logIndex) {
        return RaftClientReply.newBuilder().setClientInvocationId(invocationId).setLogIndex(logIndex).setServerId(this.getMemberId()).setCommitInfos(this.getCommitInfos());
    }

    RaftClientReply newSuccessReply(RaftClientRequest request) {
        return this.newReplyBuilder(request).setSuccess().build();
    }

    RaftClientReply newExceptionReply(RaftClientRequest request, RaftException exception) {
        return this.newReplyBuilder(request).setException(exception).build();
    }

    private CompletableFuture<RaftClientReply> checkLeaderState(RaftClientRequest request, RetryCacheImpl.CacheEntry entry, boolean isWrite) {
        try {
            this.assertGroup((Object)request.getRequestorId(), request.getRaftGroupId());
        }
        catch (GroupMismatchException e) {
            return RetryCacheImpl.failWithException((Throwable)e, (RetryCacheImpl.CacheEntry)entry);
        }
        if (!this.getInfo().isLeader()) {
            NotLeaderException exception = this.generateNotLeaderException();
            RaftClientReply reply = this.newExceptionReply(request, (RaftException)exception);
            return RetryCacheImpl.failWithReply((RaftClientReply)reply, (RetryCacheImpl.CacheEntry)entry);
        }
        if (!this.getInfo().isLeaderReady()) {
            RetryCacheImpl.CacheEntry cacheEntry = this.retryCache.getIfPresent(ClientInvocationId.valueOf((RaftClientMessage)request));
            if (cacheEntry != null && cacheEntry.isCompletedNormally()) {
                return cacheEntry.getReplyFuture();
            }
            LeaderNotReadyException lnre = new LeaderNotReadyException(this.getMemberId());
            RaftClientReply reply = this.newExceptionReply(request, (RaftException)lnre);
            return RetryCacheImpl.failWithReply((RaftClientReply)reply, (RetryCacheImpl.CacheEntry)entry);
        }
        if (isWrite && this.isSteppingDown()) {
            LeaderSteppingDownException lsde = new LeaderSteppingDownException(this.getMemberId() + " is stepping down");
            RaftClientReply reply = this.newExceptionReply(request, (RaftException)lsde);
            return RetryCacheImpl.failWithReply((RaftClientReply)reply, (RetryCacheImpl.CacheEntry)entry);
        }
        return null;
    }

    NotLeaderException generateNotLeaderException() {
        if (this.lifeCycle.getCurrentState() != LifeCycle.State.RUNNING) {
            return new NotLeaderException(this.getMemberId(), null, null);
        }
        RaftPeerId leaderId = this.state.getLeaderId();
        if (leaderId == null || leaderId.equals((Object)this.getId())) {
            leaderId = null;
        }
        RaftConfigurationImpl conf = this.getRaftConf();
        Collection peers = conf.getAllPeers();
        return new NotLeaderException(this.getMemberId(), conf.getPeer(leaderId), peers);
    }

    private LifeCycle.State assertLifeCycleState(Set<LifeCycle.State> expected) throws ServerNotReadyException {
        return this.lifeCycle.assertCurrentState((n, c) -> new ServerNotReadyException(this.getMemberId() + " is not in " + expected + ": current state is " + c), expected);
    }

    void assertGroup(Object requestorId, RaftGroupId requestorGroupId) throws GroupMismatchException {
        RaftGroupId groupId = this.getMemberId().getGroupId();
        if (!groupId.equals((Object)requestorGroupId)) {
            throw new GroupMismatchException(this.getMemberId() + ": The group (" + requestorGroupId + ") of " + requestorId + " does not match the group (" + groupId + ") of the server " + this.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<RaftClientReply> appendTransaction(RaftClientRequest request, TransactionContext context, RetryCacheImpl.CacheEntry cacheEntry) throws IOException {
        PendingRequest pending;
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            CompletableFuture reply = this.checkLeaderState(request, cacheEntry, true);
            if (reply != null) {
                return reply;
            }
            LeaderStateImpl leaderState = this.role.getLeaderStateNonNull();
            PendingRequests.Permit permit = leaderState.tryAcquirePendingRequest(request.getMessage());
            if (permit == null) {
                cacheEntry.failWithException((Throwable)new ResourceUnavailableException(this.getMemberId() + ": Failed to acquire a pending write request for " + request));
                return cacheEntry.getReplyFuture();
            }
            try {
                this.state.appendLog(context);
            }
            catch (StateMachineException e) {
                RaftClientReply exceptionReply = this.newExceptionReply(request, (RaftException)e);
                cacheEntry.failWithReply(exceptionReply);
                if (e.leaderShouldStepDown() && this.getInfo().isLeader()) {
                    leaderState.submitStepDownEvent(LeaderState.StepDownReason.STATE_MACHINE_EXCEPTION);
                }
                return CompletableFuture.completedFuture(exceptionReply);
            }
            pending = leaderState.addPendingRequest(permit, request, context);
            if (pending == null) {
                cacheEntry.failWithException((Throwable)new ResourceUnavailableException(this.getMemberId() + ": Failed to add a pending write request for " + request));
                return cacheEntry.getReplyFuture();
            }
            leaderState.notifySenders();
        }
        return pending.getFuture();
    }

    void stepDownOnJvmPause() {
        this.role.getLeaderState().ifPresent(leader -> leader.submitStepDownEvent(LeaderState.StepDownReason.JVM_PAUSE));
    }

    private RaftClientRequest filterDataStreamRaftClientRequest(RaftClientRequest request) throws InvalidProtocolBufferException {
        return !request.is(RaftProtos.RaftClientRequestProto.TypeCase.FORWARD) ? request : ClientProtoUtils.toRaftClientRequest((RaftProtos.RaftClientRequestProto)RaftProtos.RaftClientRequestProto.parseFrom((ByteBuffer)request.getMessage().getContent().asReadOnlyByteBuffer()));
    }

    public CompletableFuture<RaftClientReply> submitClientRequestAsync(RaftClientRequest request) throws IOException {
        CompletableFuture<RaftClientReply> replyFuture;
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        LOG.debug("{}: receive client request({})", (Object)this.getMemberId(), (Object)request);
        Optional<Timer> timer = Optional.ofNullable(this.raftServerMetrics.getClientRequestTimer(request.getType()));
        if (request.is(RaftProtos.RaftClientRequestProto.TypeCase.STALEREAD)) {
            replyFuture = this.staleReadAsync(request);
        } else {
            CompletableFuture reply = this.checkLeaderState(request, null, !request.is(RaftProtos.RaftClientRequestProto.TypeCase.READ) && !request.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH));
            if (reply != null) {
                return reply;
            }
            RaftClientRequest.Type type = request.getType();
            if (type.is(RaftProtos.RaftClientRequestProto.TypeCase.MESSAGESTREAM) && type.getMessageStream().getEndOfRequest()) {
                CompletableFuture f = this.streamEndOfRequestAsync(request);
                if (f.isCompletedExceptionally()) {
                    return f.thenApply(r -> null);
                }
                request = (RaftClientRequest)f.join();
                type = request.getType();
            }
            if (type.is(RaftProtos.RaftClientRequestProto.TypeCase.READ)) {
                replyFuture = this.processQueryFuture(this.stateMachine.query(request.getMessage()), request);
            } else if (type.is(RaftProtos.RaftClientRequestProto.TypeCase.WATCH)) {
                replyFuture = this.watchAsync(request);
            } else if (type.is(RaftProtos.RaftClientRequestProto.TypeCase.MESSAGESTREAM)) {
                replyFuture = this.streamAsync(request);
            } else {
                RetryCacheImpl.CacheQueryResult queryResult = this.retryCache.queryCache(ClientInvocationId.valueOf((RaftClientMessage)request));
                RetryCacheImpl.CacheEntry cacheEntry = queryResult.getEntry();
                if (queryResult.isRetry()) {
                    replyFuture = cacheEntry.getReplyFuture();
                } else {
                    TransactionContext context = this.stateMachine.startTransaction(this.filterDataStreamRaftClientRequest(request));
                    if (context.getException() != null) {
                        StateMachineException e = new StateMachineException(this.getMemberId(), (Throwable)context.getException());
                        RaftClientReply exceptionReply = this.newExceptionReply(request, (RaftException)e);
                        cacheEntry.failWithReply(exceptionReply);
                        replyFuture = CompletableFuture.completedFuture(exceptionReply);
                    } else {
                        replyFuture = this.appendTransaction(request, context, cacheEntry);
                    }
                }
            }
        }
        RaftClientRequest.Type type = request.getType();
        replyFuture.whenComplete((clientReply, exception) -> {
            if (clientReply.isSuccess()) {
                timer.map(Timer::time).ifPresent(Timer.Context::stop);
            }
            if (exception != null || clientReply.getException() != null) {
                this.raftServerMetrics.incFailedRequestCount(type);
            }
        });
        return replyFuture;
    }

    private CompletableFuture<RaftClientReply> watchAsync(RaftClientRequest request) {
        return this.role.getLeaderState().map(ls -> ls.addWatchReqeust(request)).orElseGet(() -> CompletableFuture.completedFuture(this.newExceptionReply(request, (RaftException)this.generateNotLeaderException())));
    }

    private CompletableFuture<RaftClientReply> staleReadAsync(RaftClientRequest request) {
        long minIndex = request.getType().getStaleRead().getMinIndex();
        long commitIndex = this.state.getLog().getLastCommittedIndex();
        LOG.debug("{}: minIndex={}, commitIndex={}", new Object[]{this.getMemberId(), minIndex, commitIndex});
        if (commitIndex < minIndex) {
            StaleReadException e = new StaleReadException("Unable to serve stale-read due to server commit index = " + commitIndex + " < min = " + minIndex);
            return CompletableFuture.completedFuture(this.newExceptionReply(request, (RaftException)new StateMachineException(this.getMemberId(), (Throwable)e)));
        }
        return this.processQueryFuture(this.stateMachine.queryStale(request.getMessage(), minIndex), request);
    }

    private CompletableFuture<RaftClientReply> streamAsync(RaftClientRequest request) {
        return this.role.getLeaderState().map(ls -> ls.streamAsync(request)).orElseGet(() -> CompletableFuture.completedFuture(this.newExceptionReply(request, (RaftException)this.generateNotLeaderException())));
    }

    private CompletableFuture<RaftClientRequest> streamEndOfRequestAsync(RaftClientRequest request) {
        return this.role.getLeaderState().map(ls -> ls.streamEndOfRequestAsync(request)).orElse(null);
    }

    CompletableFuture<RaftClientReply> processQueryFuture(CompletableFuture<Message> queryFuture, RaftClientRequest request) {
        return ((CompletableFuture)queryFuture.thenApply(r -> this.newReplyBuilder(request).setSuccess().setMessage(r).build())).exceptionally(e -> {
            if ((e = JavaUtils.unwrapCompletionException((Throwable)e)) instanceof StateMachineException) {
                return this.newExceptionReply(request, (RaftException)((StateMachineException)((Object)e)));
            }
            throw new CompletionException((Throwable)e);
        });
    }

    public RaftClientReply submitClientRequest(RaftClientRequest request) throws IOException {
        return this.waitForReply(request, this.submitClientRequestAsync(request));
    }

    RaftClientReply waitForReply(RaftClientRequest request, CompletableFuture<RaftClientReply> future) throws IOException {
        return RaftServerImpl.waitForReply((Object)this.getMemberId(), (RaftClientRequest)request, future, (T e) -> this.newExceptionReply(request, e));
    }

    static <REPLY extends RaftClientReply> REPLY waitForReply(Object id, RaftClientRequest request, CompletableFuture<REPLY> future, Function<RaftException, REPLY> exceptionReply) throws IOException {
        try {
            return (REPLY)((RaftClientReply)future.get());
        }
        catch (InterruptedException e) {
            String s = id + ": Interrupted when waiting for reply, request=" + request;
            LOG.info(s, (Throwable)e);
            Thread.currentThread().interrupt();
            throw IOUtils.toInterruptedIOException((String)s, (InterruptedException)e);
        }
        catch (ExecutionException e) {
            RaftClientReply reply;
            Throwable cause = e.getCause();
            if (cause == null) {
                throw new IOException(e);
            }
            if ((cause instanceof NotLeaderException || cause instanceof StateMachineException) && (reply = (RaftClientReply)exceptionReply.apply((RaftException)cause)) != null) {
                return (REPLY)reply;
            }
            throw IOUtils.asIOException((Throwable)cause);
        }
    }

    public RaftClientReply transferLeadership(TransferLeadershipRequest request) throws IOException {
        return this.waitForReply((RaftClientRequest)request, this.transferLeadershipAsync(request));
    }

    private CompletableFuture<RaftClientReply> logAndReturnTransferLeadershipFail(TransferLeadershipRequest request, String msg) {
        LOG.warn(msg);
        return CompletableFuture.completedFuture(this.newExceptionReply((RaftClientRequest)request, (RaftException)new TransferLeadershipException(msg)));
    }

    boolean isSteppingDown() {
        return this.transferLeadership.isSteppingDown();
    }

    void finishTransferLeadership() {
        this.transferLeadership.finish(this.state.getLeaderId(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<RaftClientReply> transferLeadershipAsync(TransferLeadershipRequest request) throws IOException {
        LOG.info("{}: receive transferLeadership {}", (Object)this.getMemberId(), (Object)request);
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        this.assertGroup((Object)request.getRequestorId(), request.getRaftGroupId());
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            CompletableFuture reply = this.checkLeaderState((RaftClientRequest)request, null, false);
            if (reply != null) {
                return reply;
            }
            if (this.getId().equals((Object)request.getNewLeader())) {
                return CompletableFuture.completedFuture(this.newSuccessReply((RaftClientRequest)request));
            }
            RaftConfigurationImpl conf = this.getRaftConf();
            LeaderStateImpl leaderState = this.role.getLeaderStateNonNull();
            if (!conf.isStable() || leaderState.inStagingState() || !this.state.isConfCommitted()) {
                String msg = this.getMemberId() + " refused to transfer leadership to peer " + request.getNewLeader() + " when raft reconfiguration in progress.";
                return this.logAndReturnTransferLeadershipFail(request, msg);
            }
            if (!conf.containsInConf(request.getNewLeader())) {
                String msg = this.getMemberId() + " refused to transfer leadership to peer " + request.getNewLeader() + " as it is not in " + conf;
                return this.logAndReturnTransferLeadershipFail(request, msg);
            }
            if (!conf.isHighestPriority(request.getNewLeader())) {
                String msg = this.getMemberId() + " refused to transfer leadership to peer " + request.getNewLeader() + " as it does not has highest priority " + conf;
                return this.logAndReturnTransferLeadershipFail(request, msg);
            }
            return this.transferLeadership.start(request);
        }
    }

    public RaftClientReply setConfiguration(SetConfigurationRequest request) throws IOException {
        return this.waitForReply((RaftClientRequest)request, this.setConfigurationAsync(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<RaftClientReply> setConfigurationAsync(SetConfigurationRequest request) throws IOException {
        PendingRequest pending;
        LOG.info("{}: receive setConfiguration {}", (Object)this.getMemberId(), (Object)request);
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        this.assertGroup((Object)request.getRequestorId(), request.getRaftGroupId());
        CompletableFuture reply = this.checkLeaderState((RaftClientRequest)request, null, true);
        if (reply != null) {
            return reply;
        }
        List peersInNewConf = request.getPeersInNewConf();
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            reply = this.checkLeaderState((RaftClientRequest)request, null, false);
            if (reply != null) {
                return reply;
            }
            RaftConfigurationImpl current = this.getRaftConf();
            LeaderStateImpl leaderState = this.role.getLeaderStateNonNull();
            if (!current.isStable() || leaderState.inStagingState() || !this.state.isConfCommitted()) {
                throw new ReconfigurationInProgressException("Reconfiguration is already in progress: " + current);
            }
            if (current.hasNoChange((Collection)peersInNewConf)) {
                PendingRequest pending2 = new PendingRequest(request);
                pending2.setReply(this.newSuccessReply((RaftClientRequest)request));
                return pending2.getFuture();
            }
            this.getRaftServer().addRaftPeers((Collection)peersInNewConf);
            pending = leaderState.startSetConfiguration(request);
        }
        return pending.getFuture();
    }

    private boolean shouldSendShutdown(RaftPeerId candidateId, TermIndex candidateLastEntry) {
        return this.getInfo().isLeader() && this.getRaftConf().isStable() && this.getState().isConfCommitted() && !this.getRaftConf().containsInConf(candidateId) && candidateLastEntry.getIndex() < this.getRaftConf().getLogEntryIndex() && this.role.getLeaderState().map(ls -> !ls.isBootStrappingPeer(candidateId)).orElse(false) != false;
    }

    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto r) throws IOException {
        RaftProtos.RaftRpcRequestProto request = r.getServerRequest();
        return this.requestVote(r.getPreVote() ? LeaderElection.Phase.PRE_VOTE : LeaderElection.Phase.ELECTION, RaftPeerId.valueOf((ByteString)request.getRequestorId()), ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)request.getRaftGroupId()), r.getCandidateTerm(), TermIndex.valueOf((RaftProtos.TermIndexProto)r.getCandidateLastEntry()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaftProtos.RequestVoteReplyProto requestVote(LeaderElection.Phase phase, RaftPeerId candidateId, RaftGroupId candidateGroupId, long candidateTerm, TermIndex candidateLastEntry) throws IOException {
        RaftProtos.RequestVoteReplyProto reply;
        CodeInjectionForTesting.execute((String)REQUEST_VOTE, (Object)this.getId(), (Object)candidateId, (Object[])new Object[]{candidateTerm, candidateLastEntry});
        LOG.info("{}: receive requestVote({}, {}, {}, {}, {})", new Object[]{this.getMemberId(), phase, candidateId, candidateGroupId, candidateTerm, candidateLastEntry});
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        this.assertGroup((Object)candidateId, candidateGroupId);
        boolean shouldShutdown = false;
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            this.assertLifeCycleState(LifeCycle.States.RUNNING);
            VoteContext context = new VoteContext(this, phase, candidateId);
            RaftPeer candidate = context.recognizeCandidate(candidateTerm);
            boolean voteGranted = context.decideVote(candidate, candidateLastEntry);
            if (candidate != null && phase == LeaderElection.Phase.ELECTION) {
                boolean termUpdated = this.changeToFollower(candidateTerm, true, (Object)("candidate:" + candidateId));
                if (voteGranted) {
                    this.state.grantVote(candidate.getId());
                }
                if (termUpdated || voteGranted) {
                    this.state.persistMetadata();
                }
            }
            if (voteGranted) {
                this.role.getFollowerState().ifPresent(fs -> fs.updateLastRpcTime(FollowerState.UpdateType.REQUEST_VOTE));
            } else if (this.shouldSendShutdown(candidateId, candidateLastEntry)) {
                shouldShutdown = true;
            }
            reply = ServerProtoUtils.toRequestVoteReplyProto((RaftPeerId)candidateId, (RaftGroupMemberId)this.getMemberId(), (boolean)voteGranted, (long)this.state.getCurrentTerm(), (boolean)shouldShutdown);
            if (LOG.isInfoEnabled()) {
                LOG.info("{} replies to {} vote request: {}. Peer's state: {}", new Object[]{this.getMemberId(), phase, ServerStringUtils.toRequestVoteReplyString((RaftProtos.RequestVoteReplyProto)reply), this.state});
            }
        }
        return reply;
    }

    private void validateEntries(long expectedTerm, TermIndex previous, RaftProtos.LogEntryProto ... entries) {
        if (entries != null && entries.length > 0) {
            long index0 = entries[0].getIndex();
            if (previous == null || previous.getTerm() == 0L) {
                Preconditions.assertTrue((index0 == 0L ? 1 : 0) != 0, (String)"Unexpected Index: previous is null but entries[%s].getIndex()=%s", (Object[])new Object[]{0, index0});
            } else {
                Preconditions.assertTrue((previous.getIndex() == index0 - 1L ? 1 : 0) != 0, (String)"Unexpected Index: previous is %s but entries[%s].getIndex()=%s", (Object[])new Object[]{previous, 0, index0});
            }
            for (int i = 0; i < entries.length; ++i) {
                long t = entries[i].getTerm();
                Preconditions.assertTrue((expectedTerm >= t ? 1 : 0) != 0, (String)"Unexpected Term: entries[%s].getTerm()=%s but expectedTerm=%s", (Object[])new Object[]{i, t, expectedTerm});
                long indexi = entries[i].getIndex();
                Preconditions.assertTrue((indexi == index0 + (long)i ? 1 : 0) != 0, (String)"Unexpected Index: entries[%s].getIndex()=%s but entries[0].getIndex()=%s", (Object[])new Object[]{i, indexi, index0});
            }
        }
    }

    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto r) throws IOException {
        try {
            return (RaftProtos.AppendEntriesReplyProto)this.appendEntriesAsync(r).join();
        }
        catch (CompletionException e) {
            throw IOUtils.asIOException((Throwable)JavaUtils.unwrapCompletionException((Throwable)e));
        }
    }

    public CompletableFuture<RaftProtos.AppendEntriesReplyProto> appendEntriesAsync(RaftProtos.AppendEntriesRequestProto r) throws IOException {
        RaftProtos.RaftRpcRequestProto request = r.getServerRequest();
        RaftProtos.LogEntryProto[] entries = r.getEntriesList().toArray(new RaftProtos.LogEntryProto[r.getEntriesCount()]);
        TermIndex previous = r.hasPreviousLog() ? TermIndex.valueOf((RaftProtos.TermIndexProto)r.getPreviousLog()) : null;
        RaftPeerId requestorId = RaftPeerId.valueOf((ByteString)request.getRequestorId());
        this.preAppendEntriesAsync(requestorId, ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)request.getRaftGroupId()), r.getLeaderTerm(), previous, r.getLeaderCommit(), r.getInitializing(), entries);
        try {
            return this.appendEntriesAsync(requestorId, r.getLeaderTerm(), previous, r.getLeaderCommit(), request.getCallId(), r.getInitializing(), r.getCommitInfosList(), entries);
        }
        catch (Exception t) {
            LOG.error("{}: Failed appendEntriesAsync {}", new Object[]{this.getMemberId(), r, t});
            throw t;
        }
    }

    static void logAppendEntries(boolean isHeartbeat, Supplier<String> message) {
        if (isHeartbeat) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("HEARTBEAT: " + message.get());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(message.get());
        }
    }

    private Optional<FollowerState> updateLastRpcTime(FollowerState.UpdateType updateType) {
        Optional fs = this.role.getFollowerState();
        if (fs.isPresent() && this.lifeCycle.getCurrentState() == LifeCycle.State.RUNNING) {
            ((FollowerState)fs.get()).updateLastRpcTime(updateType);
            return fs;
        }
        return Optional.empty();
    }

    private void preAppendEntriesAsync(RaftPeerId leaderId, RaftGroupId leaderGroupId, long leaderTerm, TermIndex previous, long leaderCommit, boolean initializing, RaftProtos.LogEntryProto ... entries) throws IOException {
        CodeInjectionForTesting.execute((String)APPEND_ENTRIES, (Object)this.getId(), (Object)leaderId, (Object[])new Object[]{leaderTerm, previous, leaderCommit, initializing, entries});
        this.assertLifeCycleState(LifeCycle.States.STARTING_OR_RUNNING);
        if (!this.startComplete.get()) {
            throw new ServerNotReadyException(this.getMemberId() + ": The server role is not yet initialized.");
        }
        this.assertGroup((Object)leaderId, leaderGroupId);
        try {
            this.validateEntries(leaderTerm, previous, entries);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    private RaftProtos.CommitInfoProto updateCommitInfoCache() {
        return this.commitInfoCache.update(this.getPeer(), this.state.getLog().getLastCommittedIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<RaftProtos.AppendEntriesReplyProto> appendEntriesAsync(RaftPeerId leaderId, long leaderTerm, TermIndex previous, long leaderCommit, long callId, boolean initializing, List<RaftProtos.CommitInfoProto> commitInfos, RaftProtos.LogEntryProto ... entries) throws IOException {
        Optional followerState;
        long currentTerm;
        boolean isHeartbeat = entries.length == 0;
        RaftServerImpl.logAppendEntries((boolean)isHeartbeat, () -> this.getMemberId() + ": receive appendEntries(" + leaderId + ", " + leaderTerm + ", " + previous + ", " + leaderCommit + ", " + initializing + ", commits" + ProtoUtils.toString((Collection)commitInfos) + ", entries: " + LogProtoUtils.toLogEntriesString((RaftProtos.LogEntryProto[])entries));
        long followerCommit = this.state.getLog().getLastCommittedIndex();
        Timer.Context timer = this.raftServerMetrics.getFollowerAppendEntryTimer(isHeartbeat).time();
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            this.assertLifeCycleState(LifeCycle.States.STARTING_OR_RUNNING);
            boolean recognized = this.state.recognizeLeader(leaderId, leaderTerm);
            currentTerm = this.state.getCurrentTerm();
            if (!recognized) {
                RaftProtos.AppendEntriesReplyProto reply = ServerProtoUtils.toAppendEntriesReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (long)followerCommit, (long)this.state.getNextIndex(), (RaftProtos.AppendEntriesReplyProto.AppendResult)RaftProtos.AppendEntriesReplyProto.AppendResult.NOT_LEADER, (long)callId, (long)-1L, (boolean)isHeartbeat);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: Not recognize {} (term={}) as leader, state: {} reply: {}", new Object[]{this.getMemberId(), leaderId, leaderTerm, this.state, ServerStringUtils.toAppendEntriesReplyString((RaftProtos.AppendEntriesReplyProto)reply)});
                }
                return CompletableFuture.completedFuture(reply);
            }
            try {
                this.changeToFollowerAndPersistMetadata(leaderTerm, (Object)"appendEntries");
            }
            catch (IOException e) {
                return JavaUtils.completeExceptionally((Throwable)e);
            }
            this.state.setLeader(leaderId, (Object)"appendEntries");
            if (!initializing && this.lifeCycle.compareAndTransition(LifeCycle.State.STARTING, LifeCycle.State.RUNNING)) {
                this.role.startFollowerState(this, (Object)RaftServerProtocol.Op.APPEND_ENTRIES);
            }
            followerState = this.updateLastRpcTime(FollowerState.UpdateType.APPEND_START);
            RaftProtos.AppendEntriesReplyProto inconsistencyReply = this.checkInconsistentAppendEntries(leaderId, currentTerm, followerCommit, previous, callId, isHeartbeat, entries);
            if (inconsistencyReply != null) {
                followerState.ifPresent(fs -> fs.updateLastRpcTime(FollowerState.UpdateType.APPEND_COMPLETE));
                return CompletableFuture.completedFuture(inconsistencyReply);
            }
            this.state.updateConfiguration(entries);
        }
        List futures = entries.length == 0 ? Collections.emptyList() : this.state.getLog().append(entries);
        commitInfos.forEach(arg_0 -> ((CommitInfoCache)this.commitInfoCache).update(arg_0));
        if (!isHeartbeat) {
            CodeInjectionForTesting.execute((String)LOG_SYNC, (Object)this.getId(), null, (Object[])new Object[0]);
        }
        return ((CompletableFuture)JavaUtils.allOf((Collection)futures).whenCompleteAsync((r, t) -> followerState.ifPresent(fs -> fs.updateLastRpcTime(FollowerState.UpdateType.APPEND_COMPLETE)))).thenApply(v -> {
            RaftProtos.AppendEntriesReplyProto reply;
            RaftServerImpl raftServerImpl = this;
            synchronized (raftServerImpl) {
                long commitIndex = ServerImplUtils.effectiveCommitIndex((long)leaderCommit, (TermIndex)previous, (int)entries.length);
                this.state.updateCommitIndex(commitIndex, currentTerm, false);
                this.updateCommitInfoCache();
                long n = isHeartbeat ? this.state.getLog().getNextIndex() : entries[entries.length - 1].getIndex() + 1L;
                long matchIndex = entries.length != 0 ? entries[entries.length - 1].getIndex() : -1L;
                reply = ServerProtoUtils.toAppendEntriesReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (long)this.state.getLog().getLastCommittedIndex(), (long)n, (RaftProtos.AppendEntriesReplyProto.AppendResult)RaftProtos.AppendEntriesReplyProto.AppendResult.SUCCESS, (long)callId, (long)matchIndex, (boolean)isHeartbeat);
            }
            RaftServerImpl.logAppendEntries((boolean)isHeartbeat, () -> this.getMemberId() + ": succeeded to handle AppendEntries. Reply: " + ServerStringUtils.toAppendEntriesReplyString((RaftProtos.AppendEntriesReplyProto)reply));
            timer.stop();
            return reply;
        });
    }

    private RaftProtos.AppendEntriesReplyProto checkInconsistentAppendEntries(RaftPeerId leaderId, long currentTerm, long followerCommit, TermIndex previous, long callId, boolean isHeartbeat, RaftProtos.LogEntryProto ... entries) {
        long replyNextIndex = this.checkInconsistentAppendEntries(previous, entries);
        if (replyNextIndex == -1L) {
            return null;
        }
        RaftProtos.AppendEntriesReplyProto reply = ServerProtoUtils.toAppendEntriesReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (long)followerCommit, (long)replyNextIndex, (RaftProtos.AppendEntriesReplyProto.AppendResult)RaftProtos.AppendEntriesReplyProto.AppendResult.INCONSISTENCY, (long)callId, (long)-1L, (boolean)isHeartbeat);
        LOG.info("{}: inconsistency entries. Reply:{}", (Object)this.getMemberId(), (Object)ServerStringUtils.toAppendEntriesReplyString((RaftProtos.AppendEntriesReplyProto)reply));
        return reply;
    }

    private long checkInconsistentAppendEntries(TermIndex previous, RaftProtos.LogEntryProto ... entries) {
        long installSnapshot = this.inProgressInstallSnapshotRequest.get();
        if (installSnapshot != 0L) {
            LOG.info("{}: Failed appendEntries as snapshot ({}) installation is in progress", (Object)this.getMemberId(), (Object)installSnapshot);
            return this.state.getNextIndex();
        }
        if (entries != null && entries.length > 0) {
            long firstEntryIndex = entries[0].getIndex();
            long snapshotIndex = this.state.getSnapshotIndex();
            if (snapshotIndex > 0L && snapshotIndex >= firstEntryIndex) {
                LOG.info("{}: Failed appendEntries: the first entry (index {}) is already in snapshot (snapshot index: {})", new Object[]{this.getMemberId(), firstEntryIndex, snapshotIndex});
                return snapshotIndex + 1L;
            }
            long commitIndex = this.state.getLog().getLastCommittedIndex();
            if (commitIndex > 0L && commitIndex >= firstEntryIndex) {
                LOG.info("{}: Failed appendEntries: the first entry (index {}) is already committed (commit index: {})", new Object[]{this.getMemberId(), firstEntryIndex, commitIndex});
                return commitIndex + 1L;
            }
        }
        if (previous != null && !this.state.containsTermIndex(previous)) {
            long replyNextIndex = Math.min(this.state.getNextIndex(), previous.getIndex());
            LOG.info("{}: Failed appendEntries as previous log entry ({}) is not found", (Object)this.getMemberId(), (Object)previous);
            return replyNextIndex;
        }
        return -1L;
    }

    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        RaftProtos.InstallSnapshotReplyProto reply;
        if (LOG.isInfoEnabled()) {
            LOG.info("{}: receive installSnapshot: {}", (Object)this.getMemberId(), (Object)ServerStringUtils.toInstallSnapshotRequestString((RaftProtos.InstallSnapshotRequestProto)request));
        }
        try {
            reply = this.installSnapshotImpl(request);
        }
        catch (Exception e) {
            LOG.error("{}: installSnapshot failed", (Object)this.getMemberId(), (Object)e);
            throw e;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("{}: reply installSnapshot: {}", (Object)this.getMemberId(), (Object)ServerStringUtils.toInstallSnapshotReplyString((RaftProtos.InstallSnapshotReplyProto)reply));
        }
        return reply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean pause() throws IOException {
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            if (!this.lifeCycle.compareAndTransition(LifeCycle.State.RUNNING, LifeCycle.State.PAUSING)) {
                return false;
            }
            this.stateMachine.pause();
            this.lifeCycle.compareAndTransition(LifeCycle.State.PAUSING, LifeCycle.State.PAUSED);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean resume() throws IOException {
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            if (!this.lifeCycle.compareAndTransition(LifeCycle.State.PAUSED, LifeCycle.State.STARTING)) {
                return false;
            }
            try {
                this.stateMachine.reinitialize();
            }
            catch (IOException e) {
                LOG.warn("Failed to reinitialize statemachine: {}", (Object)this.stateMachine.toString());
                this.lifeCycle.compareAndTransition(LifeCycle.State.STARTING, LifeCycle.State.EXCEPTION);
                throw e;
            }
            this.lifeCycle.compareAndTransition(LifeCycle.State.STARTING, LifeCycle.State.RUNNING);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaftProtos.StartLeaderElectionReplyProto startLeaderElection(RaftProtos.StartLeaderElectionRequestProto request) throws IOException {
        RaftProtos.RaftRpcRequestProto r = request.getServerRequest();
        RaftPeerId leaderId = RaftPeerId.valueOf((ByteString)r.getRequestorId());
        RaftGroupId leaderGroupId = ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)r.getRaftGroupId());
        TermIndex leaderLastEntry = TermIndex.valueOf((RaftProtos.TermIndexProto)request.getLeaderLastEntry());
        CodeInjectionForTesting.execute((String)START_LEADER_ELECTION, (Object)this.getId(), (Object)leaderId, (Object[])new Object[]{request});
        LOG.debug("{}: receive startLeaderElection from:{}, leaderLastEntry:{},", new Object[]{this.getMemberId(), leaderId, request.getLeaderLastEntry()});
        this.assertLifeCycleState(LifeCycle.States.RUNNING);
        this.assertGroup((Object)leaderId, leaderGroupId);
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            if (leaderLastEntry == null) {
                LOG.warn("{}: receive null leaderLastEntry which is unexpected", (Object)this.getMemberId());
                return ServerProtoUtils.toStartLeaderElectionReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (boolean)false);
            }
            this.assertLifeCycleState(LifeCycle.States.STARTING_OR_RUNNING);
            boolean recognized = this.state.recognizeLeader(leaderId, leaderLastEntry.getTerm());
            if (!recognized) {
                LOG.warn("{}: Not recognize {} (term={}) as leader, state: {}", new Object[]{this.getMemberId(), leaderId, leaderLastEntry.getTerm(), this.state});
                return ServerProtoUtils.toStartLeaderElectionReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (boolean)false);
            }
            if (!this.getInfo().isFollower()) {
                LOG.warn("{} refused StartLeaderElectionRequest from {}, because role is:{}", new Object[]{this.getMemberId(), leaderId, this.role.getCurrentRole()});
                return ServerProtoUtils.toStartLeaderElectionReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (boolean)false);
            }
            if (ServerState.compareLog((TermIndex)this.state.getLastEntry(), (TermIndex)leaderLastEntry) < 0) {
                LOG.warn("{} refused StartLeaderElectionRequest from {}, because lastEntry:{} less than leaderEntry:{}", new Object[]{this.getMemberId(), leaderId, leaderLastEntry, this.state.getLastEntry()});
                return ServerProtoUtils.toStartLeaderElectionReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (boolean)false);
            }
            this.changeToCandidate(true);
            return ServerProtoUtils.toStartLeaderElectionReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (boolean)true);
        }
    }

    private RaftProtos.InstallSnapshotReplyProto installSnapshotImpl(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        RaftProtos.RaftRpcRequestProto r = request.getServerRequest();
        RaftPeerId leaderId = RaftPeerId.valueOf((ByteString)r.getRequestorId());
        RaftGroupId leaderGroupId = ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)r.getRaftGroupId());
        CodeInjectionForTesting.execute((String)INSTALL_SNAPSHOT, (Object)this.getId(), (Object)leaderId, (Object[])new Object[]{request});
        this.assertLifeCycleState(LifeCycle.States.STARTING_OR_RUNNING);
        this.assertGroup((Object)leaderId, leaderGroupId);
        RaftProtos.InstallSnapshotReplyProto reply = null;
        if (this.installSnapshotEnabled) {
            if (request.hasSnapshotChunk()) {
                reply = this.checkAndInstallSnapshot(request, leaderId);
            }
        } else if (request.hasNotification()) {
            reply = this.notifyStateMachineToInstallSnapshot(request, leaderId);
        }
        if (reply != null) {
            if (request.hasLastRaftConfigurationLogEntryProto()) {
                RaftProtos.LogEntryProto newConfLogEntryProto = request.getLastRaftConfigurationLogEntryProto();
                LOG.info("{}: set new configuration {} from snapshot", (Object)this.getMemberId(), (Object)newConfLogEntryProto);
                this.state.setRaftConf(newConfLogEntryProto);
                this.state.writeRaftConfiguration(newConfLogEntryProto);
                this.stateMachine.event().notifyConfigurationChanged(newConfLogEntryProto.getTerm(), newConfLogEntryProto.getIndex(), newConfLogEntryProto.getConfigurationEntry());
            }
            return reply;
        }
        RaftProtos.InstallSnapshotReplyProto failedReply = ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.CONF_MISMATCH);
        LOG.error("{}: Configuration Mismatch ({}): Leader {} has it set to {} but follower {} has it set to {}", new Object[]{this.getMemberId(), "raft.server.log.appender.install.snapshot.enabled", leaderId, request.hasSnapshotChunk(), this.getId(), this.installSnapshotEnabled});
        return failedReply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaftProtos.InstallSnapshotReplyProto checkAndInstallSnapshot(RaftProtos.InstallSnapshotRequestProto request, RaftPeerId leaderId) throws IOException {
        long currentTerm;
        long leaderTerm = request.getLeaderTerm();
        RaftProtos.InstallSnapshotRequestProto.SnapshotChunkProto snapshotChunkRequest = request.getSnapshotChunk();
        long lastIncludedIndex = snapshotChunkRequest.getTermIndex().getIndex();
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            boolean recognized = this.state.recognizeLeader(leaderId, leaderTerm);
            currentTerm = this.state.getCurrentTerm();
            if (!recognized) {
                RaftProtos.InstallSnapshotReplyProto reply = ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (int)snapshotChunkRequest.getRequestIndex(), (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.NOT_LEADER);
                LOG.warn("{}: Failed to recognize leader for installSnapshot chunk.", (Object)this.getMemberId());
                return reply;
            }
            this.changeToFollowerAndPersistMetadata(leaderTerm, (Object)"installSnapshot");
            this.state.setLeader(leaderId, (Object)"installSnapshot");
            this.updateLastRpcTime(FollowerState.UpdateType.INSTALL_SNAPSHOT_START);
            try {
                Preconditions.assertTrue((this.state.getLog().getNextIndex() <= lastIncludedIndex ? 1 : 0) != 0, (String)"%s log's next id is %s, last included index in snapshot is %s", (Object[])new Object[]{this.getMemberId(), this.state.getLog().getNextIndex(), lastIncludedIndex});
                this.state.installSnapshot(request);
                if (snapshotChunkRequest.getDone()) {
                    this.state.reloadStateMachine(lastIncludedIndex);
                }
            }
            finally {
                this.updateLastRpcTime(FollowerState.UpdateType.INSTALL_SNAPSHOT_COMPLETE);
            }
        }
        if (snapshotChunkRequest.getDone()) {
            LOG.info("{}: successfully install the entire snapshot-{}", (Object)this.getMemberId(), (Object)lastIncludedIndex);
        }
        return ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (int)snapshotChunkRequest.getRequestIndex(), (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.SUCCESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaftProtos.InstallSnapshotReplyProto notifyStateMachineToInstallSnapshot(RaftProtos.InstallSnapshotRequestProto request, RaftPeerId leaderId) throws IOException {
        long leaderTerm = request.getLeaderTerm();
        TermIndex firstAvailableLogTermIndex = TermIndex.valueOf((RaftProtos.TermIndexProto)request.getNotification().getFirstAvailableTermIndex());
        long firstAvailableLogIndex = firstAvailableLogTermIndex.getIndex();
        RaftServerImpl raftServerImpl = this;
        synchronized (raftServerImpl) {
            boolean recognized = this.state.recognizeLeader(leaderId, leaderTerm);
            long currentTerm = this.state.getCurrentTerm();
            if (!recognized) {
                RaftProtos.InstallSnapshotReplyProto reply2 = ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.NOT_LEADER, (long)-1L);
                LOG.warn("{}: Failed to recognize leader for installSnapshot notification.", (Object)this.getMemberId());
                return reply2;
            }
            this.changeToFollowerAndPersistMetadata(leaderTerm, (Object)"installSnapshot");
            this.state.setLeader(leaderId, (Object)"installSnapshot");
            long snapshotIndex = this.state.getSnapshotIndex();
            this.updateLastRpcTime(FollowerState.UpdateType.INSTALL_SNAPSHOT_NOTIFICATION);
            if (this.inProgressInstallSnapshotRequest.compareAndSet(0L, firstAvailableLogIndex)) {
                LOG.info("{}: Received notification to install snapshot at index {}", (Object)this.getMemberId(), (Object)firstAvailableLogIndex);
                if (snapshotIndex + 1L >= firstAvailableLogIndex && firstAvailableLogIndex > 0L) {
                    this.inProgressInstallSnapshotRequest.compareAndSet(firstAvailableLogIndex, 0L);
                    LOG.info("{}: InstallSnapshot notification result: {}, current snapshot index: {}", new Object[]{this.getMemberId(), RaftProtos.InstallSnapshotResult.ALREADY_INSTALLED, snapshotIndex});
                    return ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.ALREADY_INSTALLED, (long)snapshotIndex);
                }
                Optional<RaftProtos.RaftPeerProto> leaderPeerInfo = null;
                if (request.hasLastRaftConfigurationLogEntryProto()) {
                    List peerList = request.getLastRaftConfigurationLogEntryProto().getConfigurationEntry().getPeersList();
                    leaderPeerInfo = peerList.stream().filter(p -> RaftPeerId.valueOf((ByteString)p.getId()).equals((Object)leaderId)).findFirst();
                    Preconditions.assertTrue((boolean)leaderPeerInfo.isPresent());
                }
                RaftProtos.RoleInfoProto roleInfoProto = this.getRaftConf().getPeer(this.state.getLeaderId()) == null ? this.getRoleInfoProto(ProtoUtils.toRaftPeer((RaftProtos.RaftPeerProto)((RaftProtos.RaftPeerProto)leaderPeerInfo.get()))) : this.getRoleInfoProto();
                LOG.info("{}: notifyInstallSnapshot: nextIndex is {} but the leader's first available index is {}.", new Object[]{this.getMemberId(), this.state.getLog().getNextIndex(), firstAvailableLogIndex});
                try {
                    ((CompletableFuture)this.stateMachine.followerEvent().notifyInstallSnapshotFromLeader(roleInfoProto, firstAvailableLogTermIndex).whenComplete((reply, exception) -> {
                        if (exception != null) {
                            LOG.warn("{}: Failed to notify StateMachine to InstallSnapshot. Exception: {}", (Object)this.getMemberId(), (Object)exception.getMessage());
                            this.inProgressInstallSnapshotRequest.compareAndSet(firstAvailableLogIndex, 0L);
                            return;
                        }
                        if (reply != null) {
                            LOG.info("{}: StateMachine successfully installed snapshot index {}. Reloading the StateMachine.", (Object)this.getMemberId(), (Object)reply.getIndex());
                            this.stateMachine.pause();
                            this.state.updateInstalledSnapshotIndex(reply);
                            this.state.reloadStateMachine(reply.getIndex());
                            this.installedSnapshotIndex.set(reply.getIndex());
                        } else {
                            this.isSnapshotNull.set(true);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("{}: StateMachine could not install snapshot as it is not available", (Object)this);
                            }
                        }
                    })).get(1L, TimeUnit.SECONDS);
                }
                catch (ExecutionException t) {
                    this.inProgressInstallSnapshotRequest.compareAndSet(firstAvailableLogIndex, 0L);
                    LOG.warn("{}: Failed to notify StateMachine to InstallSnapshot. ExecutionException: {}", (Object)this.getMemberId(), (Object)t.getMessage());
                    throw new IOException("Failed to install snapshot");
                }
                catch (InterruptedException | TimeoutException exception2) {
                    // empty catch block
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: StateMachine is processing Snapshot Installation Request.", (Object)this.getMemberId());
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("{}: StateMachine is already installing a snapshot.", (Object)this.getMemberId());
            }
            if (this.isSnapshotNull.compareAndSet(true, false)) {
                LOG.info("{}: InstallSnapshot notification result: {}", (Object)this.getMemberId(), (Object)RaftProtos.InstallSnapshotResult.SNAPSHOT_UNAVAILABLE);
                this.inProgressInstallSnapshotRequest.compareAndSet(firstAvailableLogIndex, 0L);
                return ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.SNAPSHOT_UNAVAILABLE, (long)-1L);
            }
            long latestInstalledSnapshotIndex = this.installedSnapshotIndex.getAndSet(0L);
            if (latestInstalledSnapshotIndex > 0L) {
                LOG.info("{}: InstallSnapshot notification result: {}, at index: {}", new Object[]{this.getMemberId(), RaftProtos.InstallSnapshotResult.SNAPSHOT_INSTALLED, latestInstalledSnapshotIndex});
                this.inProgressInstallSnapshotRequest.compareAndSet(firstAvailableLogIndex, 0L);
                return ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.SNAPSHOT_INSTALLED, (long)latestInstalledSnapshotIndex);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: InstallSnapshot notification result: {}", (Object)this.getMemberId(), (Object)RaftProtos.InstallSnapshotResult.IN_PROGRESS);
            }
            return ServerProtoUtils.toInstallSnapshotReplyProto((RaftPeerId)leaderId, (RaftGroupMemberId)this.getMemberId(), (long)currentTerm, (RaftProtos.InstallSnapshotResult)RaftProtos.InstallSnapshotResult.IN_PROGRESS, (long)-1L);
        }
    }

    void submitUpdateCommitEvent() {
        this.role.getLeaderState().ifPresent(LeaderStateImpl::submitUpdateCommitEvent);
    }

    private CompletableFuture<Message> replyPendingRequest(RaftProtos.LogEntryProto logEntry, CompletableFuture<Message> stateMachineFuture) {
        Preconditions.assertTrue((boolean)logEntry.hasStateMachineLogEntry());
        ClientInvocationId invocationId = ClientInvocationId.valueOf((RaftProtos.StateMachineLogEntryProto)logEntry.getStateMachineLogEntry());
        RetryCacheImpl.CacheEntry cacheEntry = this.retryCache.getOrCreateEntry(invocationId);
        if (this.getInfo().isLeader()) {
            Preconditions.assertTrue((cacheEntry != null && !cacheEntry.isCompletedNormally() ? 1 : 0) != 0, (String)"retry cache entry should be pending: %s", (Object[])new Object[]{cacheEntry});
        }
        if (cacheEntry.isFailed()) {
            this.retryCache.refreshEntry(new RetryCacheImpl.CacheEntry(cacheEntry.getKey()));
        }
        long logIndex = logEntry.getIndex();
        return stateMachineFuture.whenComplete((reply, exception) -> {
            RaftClientReply r;
            RaftClientReply.Builder b = this.newReplyBuilder(invocationId, logIndex);
            if (exception == null) {
                r = b.setSuccess().setMessage(reply).build();
            } else {
                StateMachineException e = new StateMachineException(this.getMemberId(), exception);
                r = b.setException((RaftException)e).build();
            }
            this.role.getLeaderState().ifPresent(leader -> leader.replyPendingRequest(logIndex, r));
            cacheEntry.updateResult(r);
        });
    }

    CompletableFuture<Message> applyLogToStateMachine(RaftProtos.LogEntryProto next) throws RaftLogIOException {
        if (!next.hasStateMachineLogEntry()) {
            this.stateMachine.event().notifyTermIndexUpdated(next.getTerm(), next.getIndex());
        }
        if (next.hasConfigurationEntry()) {
            this.state.writeRaftConfiguration(next);
            this.stateMachine.event().notifyConfigurationChanged(next.getTerm(), next.getIndex(), next.getConfigurationEntry());
        } else if (next.hasStateMachineLogEntry()) {
            TransactionContext trx = this.role.getLeaderState().map(leader -> leader.getTransactionContext(next.getIndex())).orElseGet(() -> TransactionContext.newBuilder().setServerRole(this.role.getCurrentRole()).setStateMachine(this.stateMachine).setLogEntry(next).build());
            try {
                trx = this.stateMachine.applyTransactionSerial(trx);
                CompletableFuture stateMachineFuture = this.stateMachine.applyTransaction(trx);
                return this.replyPendingRequest(next, stateMachineFuture);
            }
            catch (Exception e) {
                throw new RaftLogIOException((Throwable)e);
            }
        }
        return null;
    }

    void notifyTruncatedLogEntry(RaftProtos.LogEntryProto logEntry) {
        if (logEntry.hasStateMachineLogEntry()) {
            ClientInvocationId invocationId = ClientInvocationId.valueOf((RaftProtos.StateMachineLogEntryProto)logEntry.getStateMachineLogEntry());
            RetryCacheImpl.CacheEntry cacheEntry = this.getRetryCache().getIfPresent(invocationId);
            if (cacheEntry != null) {
                cacheEntry.failWithReply(this.newReplyBuilder(invocationId, logEntry.getIndex()).setException((RaftException)this.generateNotLeaderException()).build());
            }
        }
    }

    LeaderElectionMetrics getLeaderElectionMetrics() {
        return this.leaderElectionMetrics;
    }

    public RaftServerMetricsImpl getRaftServerMetrics() {
        return this.raftServerMetrics;
    }

    static /* synthetic */ LifeCycle access$000(RaftServerImpl x0) {
        return x0.lifeCycle;
    }

    static /* synthetic */ RoleInfo access$100(RaftServerImpl x0) {
        return x0.role;
    }

    static /* synthetic */ RaftServerProxy access$300(RaftServerImpl x0) {
        return x0.proxy;
    }
}

