/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.impl.FollowerState;
import org.apache.ratis.server.impl.LeaderElection;
import org.apache.ratis.server.impl.LeaderStateImpl;
import org.apache.ratis.server.impl.RaftServerImpl;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RoleInfo {
    public static final Logger LOG = LoggerFactory.getLogger(RoleInfo.class);
    private final RaftPeerId id;
    private volatile RaftProtos.RaftPeerRole role;
    private final AtomicReference<LeaderStateImpl> leaderState = new AtomicReference();
    private final AtomicReference<FollowerState> followerState = new AtomicReference();
    private final AtomicReference<LeaderElection> leaderElection = new AtomicReference();
    private final AtomicReference<Timestamp> transitionTime;

    RoleInfo(RaftPeerId id) {
        this.id = id;
        this.transitionTime = new AtomicReference<Timestamp>(Timestamp.currentTime());
    }

    void transitionRole(RaftProtos.RaftPeerRole newRole) {
        this.role = newRole;
        this.transitionTime.set(Timestamp.currentTime());
    }

    long getRoleElapsedTimeMs() {
        return ((Timestamp)this.transitionTime.get()).elapsedTimeMs();
    }

    RaftProtos.RaftPeerRole getCurrentRole() {
        return this.role;
    }

    boolean isLeaderReady() {
        return this.getLeaderState().map(LeaderStateImpl::isReady).orElse(false);
    }

    Optional<LeaderStateImpl> getLeaderState() {
        return Optional.ofNullable(this.leaderState.get());
    }

    LeaderStateImpl getLeaderStateNonNull() {
        return (LeaderStateImpl)Objects.requireNonNull(this.leaderState.get(), "leaderState is null");
    }

    RaftProtos.LogEntryProto startLeaderState(RaftServerImpl server) {
        return ((LeaderStateImpl)this.updateAndGet(this.leaderState, (Object)new LeaderStateImpl(server))).start();
    }

    void shutdownLeaderState(boolean allowNull) {
        LeaderStateImpl leader = this.leaderState.getAndSet(null);
        if (leader == null) {
            if (!allowNull) {
                throw new NullPointerException("leaderState == null");
            }
        } else {
            LOG.info("{}: shutdown {}", (Object)this.id, (Object)leader);
            leader.stop();
        }
    }

    Optional<FollowerState> getFollowerState() {
        return Optional.ofNullable(this.followerState.get());
    }

    void startFollowerState(RaftServerImpl server, Object reason) {
        ((FollowerState)this.updateAndGet(this.followerState, (Object)new FollowerState(server, reason))).start();
    }

    void shutdownFollowerState() {
        FollowerState follower = this.followerState.getAndSet(null);
        if (follower != null) {
            LOG.info("{}: shutdown {}", (Object)this.id, (Object)follower);
            follower.stopRunning();
            follower.interrupt();
        }
    }

    void startLeaderElection(RaftServerImpl server, boolean force) {
        ((LeaderElection)this.updateAndGet(this.leaderElection, (Object)new LeaderElection(server, force))).start();
    }

    void shutdownLeaderElection() {
        LeaderElection election = this.leaderElection.getAndSet(null);
        if (election != null) {
            LOG.info("{}: shutdown {}", (Object)this.id, (Object)election);
            election.shutdown();
        }
    }

    private <T> T updateAndGet(AtomicReference<T> ref, T current) {
        T updated = ref.updateAndGet(previous -> previous != null ? previous : current);
        Preconditions.assertTrue((updated == current ? 1 : 0) != 0, (Object)"previous != null");
        LOG.info("{}: start {}", (Object)this.id, current);
        return updated;
    }

    public String toString() {
        return String.format("%9s", this.role);
    }
}

