/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.leader;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.leader.FollowerInfo;
import org.apache.ratis.server.leader.InstallSnapshotRequests;
import org.apache.ratis.server.leader.LeaderProtoUtils;
import org.apache.ratis.server.leader.LeaderState;
import org.apache.ratis.server.leader.LogAppender;
import org.apache.ratis.server.leader.LogAppenderDaemon;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.RaftLog;
import org.apache.ratis.server.raftlog.RaftLogIOException;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.util.DataQueue;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.SizeInBytes;

public abstract class LogAppenderBase
implements LogAppender {
    private final String name;
    private final RaftServer.Division server;
    private final LeaderState leaderState;
    private final FollowerInfo follower;
    private final DataQueue<RaftLog.EntryWithData> buffer;
    private final int snapshotChunkMaxSize;
    private final LogAppenderDaemon daemon;

    protected LogAppenderBase(RaftServer.Division server, LeaderState leaderState, FollowerInfo f) {
        this.follower = f;
        this.name = this.follower.getName() + "-" + JavaUtils.getClassSimpleName(this.getClass());
        this.server = server;
        this.leaderState = leaderState;
        RaftProperties properties = server.getRaftServer().getProperties();
        this.snapshotChunkMaxSize = RaftServerConfigKeys.Log.Appender.snapshotChunkSizeMax((RaftProperties)properties).getSizeInt();
        SizeInBytes bufferByteLimit = RaftServerConfigKeys.Log.Appender.bufferByteLimit((RaftProperties)properties);
        int bufferElementLimit = RaftServerConfigKeys.Log.Appender.bufferElementLimit((RaftProperties)properties);
        this.buffer = new DataQueue((Object)this, bufferByteLimit, bufferElementLimit, RaftLog.EntryWithData::getSerializedSize);
        this.daemon = new LogAppenderDaemon((LogAppender)this);
    }

    public final RaftServer.Division getServer() {
        return this.server;
    }

    public String toString() {
        return this.name;
    }

    public void start() {
        this.daemon.tryToStart();
    }

    public boolean isRunning() {
        return this.daemon.isWorking();
    }

    public void stop() {
        this.daemon.tryToClose();
    }

    public final FollowerInfo getFollower() {
        return this.follower;
    }

    public final LeaderState getLeaderState() {
        return this.leaderState;
    }

    private TermIndex getPrevious(long nextIndex) {
        TermIndex snapshotTermIndex;
        if (nextIndex == 0L) {
            return null;
        }
        long previousIndex = nextIndex - 1L;
        TermIndex previous = this.getRaftLog().getTermIndex(previousIndex);
        if (previous != null) {
            return previous;
        }
        SnapshotInfo snapshot = this.server.getStateMachine().getLatestSnapshot();
        if (snapshot != null && (snapshotTermIndex = snapshot.getTermIndex()).getIndex() == previousIndex) {
            return snapshotTermIndex;
        }
        return null;
    }

    public RaftProtos.AppendEntriesRequestProto newAppendEntriesRequest(long callId, boolean heartbeat) throws RaftLogIOException {
        TermIndex previous = this.getPrevious(this.follower.getNextIndex());
        long snapshotIndex = this.follower.getSnapshotIndex();
        long heartbeatRemainingMs = this.getHeartbeatRemainingTimeMs();
        if (heartbeatRemainingMs <= 0L || heartbeat) {
            return this.leaderState.newAppendEntriesRequestProto(this.follower, Collections.emptyList(), previous, callId);
        }
        Preconditions.assertTrue((boolean)this.buffer.isEmpty(), () -> "buffer has " + this.buffer.getNumElements() + " elements.");
        long leaderNext = this.getRaftLog().getNextIndex();
        long followerNext = this.follower.getNextIndex();
        long halfMs = heartbeatRemainingMs / 2L;
        long next = followerNext;
        while (leaderNext > next && this.getHeartbeatRemainingTimeMs() - halfMs > 0L && this.buffer.offer((Object)this.getRaftLog().getEntryWithData(next++))) {
        }
        if (this.buffer.isEmpty()) {
            return null;
        }
        List protos = this.buffer.pollList(this.getHeartbeatRemainingTimeMs(), RaftLog.EntryWithData::getEntry, (entry, time, exception) -> LOG.warn("{}: Failed to get {} in {}: {}", new Object[]{this.follower.getName(), entry, time, exception}));
        this.buffer.clear();
        this.assertProtos(protos, followerNext, previous, snapshotIndex);
        return this.leaderState.newAppendEntriesRequestProto(this.follower, protos, previous, callId);
    }

    private void assertProtos(List<RaftProtos.LogEntryProto> protos, long nextIndex, TermIndex previous, long snapshotIndex) {
        if (protos.isEmpty()) {
            return;
        }
        long firstIndex = protos.get(0).getIndex();
        Preconditions.assertTrue((firstIndex == nextIndex ? 1 : 0) != 0, () -> this.follower.getName() + ": firstIndex = " + firstIndex + " != nextIndex = " + nextIndex);
        if (firstIndex > 0L && nextIndex != snapshotIndex + 1L) {
            Objects.requireNonNull(previous, () -> this.follower.getName() + ": Previous TermIndex not found for firstIndex = " + firstIndex);
            Preconditions.assertTrue((previous.getIndex() == firstIndex - 1L ? 1 : 0) != 0, () -> this.follower.getName() + ": Previous = " + previous + " but firstIndex = " + firstIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RaftProtos.InstallSnapshotRequestProto newInstallSnapshotNotificationRequest(TermIndex firstAvailableLogTermIndex) {
        Preconditions.assertTrue((firstAvailableLogTermIndex.getIndex() >= 0L ? 1 : 0) != 0);
        RaftServer.Division division = this.server;
        synchronized (division) {
            return LeaderProtoUtils.toInstallSnapshotRequestProto((RaftServer.Division)this.server, (RaftPeerId)this.getFollowerId(), (TermIndex)firstAvailableLogTermIndex);
        }
    }

    public Iterable<RaftProtos.InstallSnapshotRequestProto> newInstallSnapshotRequests(String requestId, SnapshotInfo snapshot) {
        return new InstallSnapshotRequests(this.server, this.getFollowerId(), requestId, snapshot, this.snapshotChunkMaxSize);
    }
}

