/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.Checksum;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.raftlog.segmented.BufferedWriteChannel;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogFormat;
import org.apache.ratis.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.PureJavaCrc32C;
import org.apache.ratis.util.function.CheckedConsumer;
import org.apache.ratis.util.function.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SegmentedRaftLogOutputStream
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SegmentedRaftLogOutputStream.class);
    private static final ByteBuffer FILL = ByteBuffer.allocateDirect(0x100000);
    private static final int BUFFER_SIZE = 0x100000;
    private final File file;
    private final BufferedWriteChannel out;
    private final Checksum checksum;
    private final long segmentMaxSize;
    private final long preallocatedSize;

    public SegmentedRaftLogOutputStream(File file, boolean append, long segmentMaxSize, long preallocatedSize, ByteBuffer byteBuffer) throws IOException {
        this.file = file;
        this.checksum = new PureJavaCrc32C();
        this.segmentMaxSize = segmentMaxSize;
        this.preallocatedSize = preallocatedSize;
        this.out = BufferedWriteChannel.open((File)file, (boolean)append, (ByteBuffer)byteBuffer);
        if (!append) {
            this.preallocateIfNecessary(SegmentedRaftLogFormat.getHeaderLength());
            SegmentedRaftLogFormat.applyHeaderTo((CheckedFunction)CheckedConsumer.asCheckedFunction(arg_0 -> ((BufferedWriteChannel)this.out).write(arg_0)));
            this.out.flush();
        }
    }

    public void write(RaftProtos.LogEntryProto entry) throws IOException {
        int serialized = entry.getSerializedSize();
        int proto = CodedOutputStream.computeUInt32SizeNoTag((int)serialized) + serialized;
        byte[] buf = new byte[proto + 4];
        this.preallocateIfNecessary(buf.length);
        CodedOutputStream cout = CodedOutputStream.newInstance((byte[])buf);
        cout.writeUInt32NoTag(serialized);
        entry.writeTo(cout);
        this.checksum.reset();
        this.checksum.update(buf, 0, proto);
        ByteBuffer.wrap(buf, proto, 4).putInt((int)this.checksum.getValue());
        this.out.write(buf);
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Logger)LOG, (Closeable[])new Closeable[]{this.out});
            throw throwable;
        }
        IOUtils.cleanup((Logger)LOG, (Closeable[])new Closeable[]{this.out});
    }

    public void flush() throws IOException {
        try {
            this.out.flush();
        }
        catch (IOException ioe) {
            throw new IOException("Failed to flush " + this, ioe);
        }
    }

    private static long actualPreallocateSize(long outstandingData, long remainingSpace, long preallocate) {
        return outstandingData > remainingSpace ? outstandingData : (outstandingData > preallocate ? outstandingData : Math.min(preallocate, remainingSpace));
    }

    private long preallocate(FileChannel fc, long outstanding) throws IOException {
        long actual = SegmentedRaftLogOutputStream.actualPreallocateSize((long)outstanding, (long)(this.segmentMaxSize - fc.size()), (long)this.preallocatedSize);
        Preconditions.assertTrue((actual >= outstanding ? 1 : 0) != 0);
        long allocated = IOUtils.preallocate((FileChannel)fc, (long)actual, (ByteBuffer)FILL);
        LOG.debug("Pre-allocated {} bytes for {}", (Object)allocated, (Object)this);
        return allocated;
    }

    private void preallocateIfNecessary(int size) throws IOException {
        this.out.preallocateIfNecessary((long)size, (arg_0, arg_1) -> this.preallocate(arg_0, arg_1));
    }

    public String toString() {
        return JavaUtils.getClassSimpleName(this.getClass()) + "(" + this.file + ")";
    }

    static {
        for (int i = 0; i < FILL.capacity(); ++i) {
            FILL.put(SegmentedRaftLogFormat.getTerminator());
        }
        FILL.flip();
    }
}

