/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.simulation;

import java.util.Objects;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftRpcMessage;
import org.apache.ratis.util.ProtoUtils;

public class RaftServerReply
implements RaftRpcMessage {
    private final RaftProtos.AppendEntriesReplyProto appendEntries;
    private final RaftProtos.RequestVoteReplyProto requestVote;
    private final RaftProtos.InstallSnapshotReplyProto installSnapshot;
    private final RaftProtos.StartLeaderElectionReplyProto startLeaderElection;

    RaftServerReply(RaftProtos.AppendEntriesReplyProto a) {
        this.appendEntries = Objects.requireNonNull(a);
        this.requestVote = null;
        this.installSnapshot = null;
        this.startLeaderElection = null;
    }

    RaftServerReply(RaftProtos.RequestVoteReplyProto r) {
        this.appendEntries = null;
        this.requestVote = Objects.requireNonNull(r);
        this.installSnapshot = null;
        this.startLeaderElection = null;
    }

    RaftServerReply(RaftProtos.InstallSnapshotReplyProto i) {
        this.appendEntries = null;
        this.requestVote = null;
        this.installSnapshot = Objects.requireNonNull(i);
        this.startLeaderElection = null;
    }

    RaftServerReply(RaftProtos.StartLeaderElectionReplyProto i) {
        this.appendEntries = null;
        this.requestVote = null;
        this.installSnapshot = null;
        this.startLeaderElection = Objects.requireNonNull(i);
    }

    boolean isAppendEntries() {
        return this.appendEntries != null;
    }

    boolean isRequestVote() {
        return this.requestVote != null;
    }

    boolean isInstallSnapshot() {
        return this.installSnapshot != null;
    }

    boolean isStartLeaderElection() {
        return this.startLeaderElection != null;
    }

    RaftProtos.AppendEntriesReplyProto getAppendEntries() {
        return this.appendEntries;
    }

    RaftProtos.RequestVoteReplyProto getRequestVote() {
        return this.requestVote;
    }

    RaftProtos.InstallSnapshotReplyProto getInstallSnapshot() {
        return this.installSnapshot;
    }

    RaftProtos.StartLeaderElectionReplyProto getStartLeaderElection() {
        return this.startLeaderElection;
    }

    public boolean isRequest() {
        return false;
    }

    public String getRequestorId() {
        if (this.isAppendEntries()) {
            return this.appendEntries.getServerReply().getRequestorId().toStringUtf8();
        }
        if (this.isRequestVote()) {
            return this.requestVote.getServerReply().getRequestorId().toStringUtf8();
        }
        if (this.isInstallSnapshot()) {
            return this.installSnapshot.getServerReply().getRequestorId().toStringUtf8();
        }
        return this.startLeaderElection.getServerReply().getRequestorId().toStringUtf8();
    }

    public String getReplierId() {
        if (this.isAppendEntries()) {
            return this.appendEntries.getServerReply().getReplyId().toStringUtf8();
        }
        if (this.isRequestVote()) {
            return this.requestVote.getServerReply().getReplyId().toStringUtf8();
        }
        if (this.isInstallSnapshot()) {
            return this.installSnapshot.getServerReply().getReplyId().toStringUtf8();
        }
        return this.startLeaderElection.getServerReply().getReplyId().toStringUtf8();
    }

    public RaftGroupId getRaftGroupId() {
        if (this.isAppendEntries()) {
            return ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)this.appendEntries.getServerReply().getRaftGroupId());
        }
        if (this.isRequestVote()) {
            return ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)this.requestVote.getServerReply().getRaftGroupId());
        }
        if (this.isInstallSnapshot()) {
            return ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)this.installSnapshot.getServerReply().getRaftGroupId());
        }
        return ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)this.startLeaderElection.getServerReply().getRaftGroupId());
    }
}

