/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.simulation;

import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftRpcMessage;
import org.apache.ratis.util.ProtoUtils;

class RaftServerRequest
implements RaftRpcMessage {
    private final RaftProtos.AppendEntriesRequestProto appendEntries;
    private final RaftProtos.RequestVoteRequestProto requestVote;
    private final RaftProtos.InstallSnapshotRequestProto installSnapshot;
    private final RaftProtos.StartLeaderElectionRequestProto startLeaderElection;

    RaftServerRequest(RaftProtos.AppendEntriesRequestProto a) {
        this.appendEntries = a;
        this.requestVote = null;
        this.installSnapshot = null;
        this.startLeaderElection = null;
    }

    RaftServerRequest(RaftProtos.RequestVoteRequestProto r) {
        this.appendEntries = null;
        this.requestVote = r;
        this.installSnapshot = null;
        this.startLeaderElection = null;
    }

    RaftServerRequest(RaftProtos.InstallSnapshotRequestProto i) {
        this.appendEntries = null;
        this.requestVote = null;
        this.installSnapshot = i;
        this.startLeaderElection = null;
    }

    RaftServerRequest(RaftProtos.StartLeaderElectionRequestProto i) {
        this.appendEntries = null;
        this.requestVote = null;
        this.installSnapshot = null;
        this.startLeaderElection = i;
    }

    boolean isAppendEntries() {
        return this.appendEntries != null;
    }

    boolean isRequestVote() {
        return this.requestVote != null;
    }

    boolean isInstallSnapshot() {
        return this.installSnapshot != null;
    }

    boolean isStartLeaderElection() {
        return this.startLeaderElection != null;
    }

    RaftProtos.AppendEntriesRequestProto getAppendEntries() {
        return this.appendEntries;
    }

    RaftProtos.RequestVoteRequestProto getRequestVote() {
        return this.requestVote;
    }

    RaftProtos.InstallSnapshotRequestProto getInstallSnapshot() {
        return this.installSnapshot;
    }

    RaftProtos.StartLeaderElectionRequestProto getStartLeaderElection() {
        return this.startLeaderElection;
    }

    public boolean isRequest() {
        return true;
    }

    public String getRequestorId() {
        if (this.isAppendEntries()) {
            return this.appendEntries.getServerRequest().getRequestorId().toStringUtf8();
        }
        if (this.isRequestVote()) {
            return this.requestVote.getServerRequest().getRequestorId().toStringUtf8();
        }
        if (this.isInstallSnapshot()) {
            return this.installSnapshot.getServerRequest().getRequestorId().toStringUtf8();
        }
        return this.startLeaderElection.getServerRequest().getRequestorId().toStringUtf8();
    }

    public String getReplierId() {
        if (this.isAppendEntries()) {
            return this.appendEntries.getServerRequest().getReplyId().toStringUtf8();
        }
        if (this.isRequestVote()) {
            return this.requestVote.getServerRequest().getReplyId().toStringUtf8();
        }
        if (this.isInstallSnapshot()) {
            return this.installSnapshot.getServerRequest().getReplyId().toStringUtf8();
        }
        return this.startLeaderElection.getServerRequest().getReplyId().toStringUtf8();
    }

    public RaftGroupId getRaftGroupId() {
        if (this.isAppendEntries()) {
            return ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)this.appendEntries.getServerRequest().getRaftGroupId());
        }
        if (this.isRequestVote()) {
            return ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)this.requestVote.getServerRequest().getRaftGroupId());
        }
        if (this.isInstallSnapshot()) {
            return ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)this.installSnapshot.getServerRequest().getRaftGroupId());
        }
        return ProtoUtils.toRaftGroupId((RaftProtos.RaftGroupIdProto)this.startLeaderElection.getServerRequest().getRaftGroupId());
    }
}

