/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.simulation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.ratis.protocol.RaftRpcMessage;
import org.apache.ratis.server.simulation.RequestHandler;
import org.apache.ratis.server.simulation.SimulatedRequestReply;
import org.apache.ratis.util.Daemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler<REQUEST extends RaftRpcMessage, REPLY extends RaftRpcMessage> {
    public static final Logger LOG = LoggerFactory.getLogger(RequestHandler.class);
    private final Supplier<String> serverIdSupplier;
    private final String name;
    private final SimulatedRequestReply<REQUEST, REPLY> rpc;
    private final HandlerInterface<REQUEST, REPLY> handlerImpl;
    private final List<HandlerDaemon> daemons;

    RequestHandler(Supplier<String> serverIdSupplier, String name, SimulatedRequestReply<REQUEST, REPLY> rpc, HandlerInterface<REQUEST, REPLY> handlerImpl, int numHandlers) {
        this.serverIdSupplier = serverIdSupplier;
        this.name = name;
        this.rpc = rpc;
        this.handlerImpl = handlerImpl;
        this.daemons = new ArrayList(numHandlers);
        for (int i = 0; i < numHandlers; ++i) {
            this.daemons.add(new HandlerDaemon(this, i));
        }
    }

    private String getServerId() {
        return (String)this.serverIdSupplier.get();
    }

    void startDaemon() {
        this.daemons.forEach(Thread::start);
    }

    void shutdown() {
        this.rpc.shutdown(this.getServerId());
    }

    void interruptAndJoinDaemon() throws InterruptedException {
        this.daemons.forEach(Thread::interrupt);
        for (Daemon d : this.daemons) {
            d.join(1000L);
        }
    }

    SimulatedRequestReply<REQUEST, REPLY> getRpc() {
        return this.rpc;
    }

    void handleRequest(REQUEST request) throws IOException {
        RaftRpcMessage reply;
        try {
            reply = this.handlerImpl.handleRequest(request);
        }
        catch (IOException ioe) {
            LOG.debug("IOException for " + request, (Throwable)ioe);
            this.rpc.sendReply(request, null, ioe);
            return;
        }
        if (reply != null) {
            this.rpc.sendReply(request, reply, null);
        }
    }

    static /* synthetic */ String access$000(RequestHandler x0) {
        return x0.getServerId();
    }

    static /* synthetic */ String access$100(RequestHandler x0) {
        return x0.name;
    }

    static /* synthetic */ HandlerInterface access$200(RequestHandler x0) {
        return x0.handlerImpl;
    }

    static /* synthetic */ SimulatedRequestReply access$300(RequestHandler x0) {
        return x0.rpc;
    }
}

