/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.Collection;
import java.util.function.Function;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.impl.PendingRequest;
import org.apache.ratis.server.impl.PendingRequests;
import org.apache.ratis.server.metrics.RaftServerMetricsImpl;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.SizeInBytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PendingRequests {
    public static final Logger LOG = LoggerFactory.getLogger(PendingRequests.class);
    private static final int ONE_MB = SizeInBytes.ONE_MB.getSizeInt();
    private PendingRequest pendingSetConf;
    private final String name;
    private final RequestMap pendingRequests;

    static int roundUpMb(long bytes) {
        return Math.toIntExact((bytes - 1L) / (long)ONE_MB + 1L);
    }

    PendingRequests(RaftGroupMemberId id, RaftProperties properties, RaftServerMetricsImpl raftServerMetrics) {
        this.name = id + "-" + JavaUtils.getClassSimpleName(this.getClass());
        this.pendingRequests = new RequestMap((Object)id, RaftServerConfigKeys.Write.elementLimit((RaftProperties)properties), Math.toIntExact(RaftServerConfigKeys.Write.byteLimit((RaftProperties)properties).getSize() / SizeInBytes.ONE_MB.getSize()), raftServerMetrics);
    }

    Permit tryAcquire(Message message) {
        return this.pendingRequests.tryAcquire(message);
    }

    PendingRequest add(Permit permit, RaftClientRequest request, TransactionContext entry) {
        long index = entry.getLogEntry().getIndex();
        LOG.debug("{}: addPendingRequest at index={}, request={}", new Object[]{this.name, index, request});
        PendingRequest pending = new PendingRequest(index, request, entry);
        return this.pendingRequests.put(permit, index, pending);
    }

    PendingRequest addConfRequest(SetConfigurationRequest request) {
        Preconditions.assertTrue((this.pendingSetConf == null ? 1 : 0) != 0);
        this.pendingSetConf = new PendingRequest(request);
        return this.pendingSetConf;
    }

    void replySetConfiguration(Function<RaftClientRequest, RaftClientReply> newSuccessReply) {
        if (this.pendingSetConf != null) {
            RaftClientRequest request = this.pendingSetConf.getRequest();
            LOG.debug("{}: sends success for {}", (Object)this.name, (Object)request);
            this.pendingSetConf.setReply(newSuccessReply.apply(request));
            this.pendingSetConf = null;
        }
    }

    void failSetConfiguration(RaftException e) {
        Preconditions.assertTrue((this.pendingSetConf != null ? 1 : 0) != 0);
        this.pendingSetConf.setException((Throwable)e);
        this.pendingSetConf = null;
    }

    TransactionContext getTransactionContext(long index) {
        PendingRequest pendingRequest = this.pendingRequests.get(index);
        return pendingRequest != null ? pendingRequest.getEntry() : null;
    }

    void replyPendingRequest(long index, RaftClientReply reply) {
        PendingRequest pending = this.pendingRequests.remove(index);
        if (pending != null) {
            Preconditions.assertTrue((pending.getIndex() == index ? 1 : 0) != 0);
            pending.setReply(reply);
        }
    }

    Collection<TransactionContext> sendNotLeaderResponses(NotLeaderException nle, Collection<RaftProtos.CommitInfoProto> commitInfos) {
        LOG.info("{}: sendNotLeaderResponses", (Object)this.name);
        Collection transactions = this.pendingRequests.setNotLeaderException(nle, commitInfos);
        if (this.pendingSetConf != null) {
            this.pendingSetConf.setNotLeaderException(nle, commitInfos);
        }
        return transactions;
    }

    void close() {
        if (this.pendingRequests != null) {
            this.pendingRequests.close();
        }
    }
}

