/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.simulation;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.RaftRpcMessage;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerRpc;
import org.apache.ratis.server.simulation.RaftServerReply;
import org.apache.ratis.server.simulation.RaftServerRequest;
import org.apache.ratis.server.simulation.RequestHandler;
import org.apache.ratis.server.simulation.SimulatedRequestReply;
import org.apache.ratis.server.simulation.SimulatedRpc;
import org.apache.ratis.util.Daemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimulatedServerRpc
implements RaftServerRpc {
    static final Logger LOG = LoggerFactory.getLogger(SimulatedServerRpc.class);
    static final AtomicInteger THREAD_COUNT = new AtomicInteger(0);
    private final RaftServer server;
    private final RequestHandler<RaftServerRequest, RaftServerReply> serverHandler;
    private final RequestHandler<RaftClientRequest, RaftClientReply> clientHandler;
    private final ExecutorService executor = Executors.newFixedThreadPool(3, t -> Daemon.newBuilder().setName("SimulatedServerRpc-" + THREAD_COUNT.incrementAndGet()).setRunnable(t).build());
    final RequestHandler.HandlerInterface<RaftServerRequest, RaftServerReply> serverHandlerImpl = new /* Unavailable Anonymous Inner Class!! */;
    final RequestHandler.HandlerInterface<RaftClientRequest, RaftClientReply> clientHandlerImpl = new /* Unavailable Anonymous Inner Class!! */;

    SimulatedServerRpc(RaftServer server, SimulatedRequestReply<RaftServerRequest, RaftServerReply> serverRequestReply, SimulatedRequestReply<RaftClientRequest, RaftClientReply> clientRequestReply) {
        this.server = server;
        Supplier<String> id = () -> server.getId().toString();
        this.serverHandler = new RequestHandler(id, "serverHandler", serverRequestReply, this.serverHandlerImpl, 3);
        this.clientHandler = new RequestHandler(id, "clientHandler", clientRequestReply, this.clientHandlerImpl, 3);
    }

    public SimulatedRpc getRpcType() {
        return SimulatedRpc.INSTANCE;
    }

    public void start() {
        this.serverHandler.startDaemon();
        this.clientHandler.startDaemon();
    }

    private void interruptAndJoin() throws InterruptedException {
        this.clientHandler.interruptAndJoinDaemon();
        this.serverHandler.interruptAndJoinDaemon();
    }

    public void close() {
        try {
            this.interruptAndJoin();
            this.executor.shutdown();
            this.executor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        this.clientHandler.shutdown();
        this.serverHandler.shutdown();
    }

    public InetSocketAddress getInetSocketAddress() {
        return null;
    }

    public RaftProtos.AppendEntriesReplyProto appendEntries(RaftProtos.AppendEntriesRequestProto request) throws IOException {
        RaftServerReply reply = (RaftServerReply)this.serverHandler.getRpc().sendRequest((RaftRpcMessage)new RaftServerRequest(request));
        return reply.getAppendEntries();
    }

    public RaftProtos.InstallSnapshotReplyProto installSnapshot(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
        RaftServerReply reply = (RaftServerReply)this.serverHandler.getRpc().sendRequest((RaftRpcMessage)new RaftServerRequest(request));
        return reply.getInstallSnapshot();
    }

    public RaftProtos.RequestVoteReplyProto requestVote(RaftProtos.RequestVoteRequestProto request) throws IOException {
        RaftServerReply reply = (RaftServerReply)this.serverHandler.getRpc().sendRequest((RaftRpcMessage)new RaftServerRequest(request));
        return reply.getRequestVote();
    }

    public RaftProtos.StartLeaderElectionReplyProto startLeaderElection(RaftProtos.StartLeaderElectionRequestProto request) throws IOException {
        RaftServerReply reply = (RaftServerReply)this.serverHandler.getRpc().sendRequest((RaftRpcMessage)new RaftServerRequest(request));
        return reply.getStartLeaderElection();
    }

    public void addRaftPeers(Collection<RaftPeer> peers) {
    }

    public void handleException(RaftPeerId serverId, Exception e, boolean reconnect) {
    }

    static /* synthetic */ RaftServer access$000(SimulatedServerRpc x0) {
        return x0.server;
    }

    static /* synthetic */ ExecutorService access$100(SimulatedServerRpc x0) {
        return x0.executor;
    }

    static /* synthetic */ RequestHandler access$200(SimulatedServerRpc x0) {
        return x0.clientHandler;
    }
}

