/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.integrationtests.steps;

import org.apache.rave.integrationtests.pages.Portal;
import org.apache.rave.integrationtests.steps.Step;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.springframework.beans.factory.annotation.Autowired;

@Step
public class DeleteNewUserSteps {
    @Autowired
    private Portal portal;

    @When(value="I go to \"$url\"")
    public void goTo(String url) {
        this.portal.go(url);
    }

    @Then(value="I see the login page")
    public void isLoginPage() {
        WebElement title = this.portal.findElement(By.tagName((String)"title"));
        MatcherAssert.assertThat((Object)title.getText().trim(), (Matcher)CoreMatchers.equalTo((Object)"Login - Rave"));
    }

    @When(value="I log in as an administrator with username \"$username\" and password \"$password\"")
    public void loginAsAdmin(String username, String password) {
        this.portal.login(username, password);
    }

    @Then(value="I see the admin interface link")
    public void getAdminInterfaceLink() {
        WebElement adminInterfaceLink = this.portal.findElement(By.linkText((String)"Admin interface"));
    }

    @When(value="I click the admin interface link")
    public void clickAdminInterfaceLink() {
        WebElement adminInterfaceLink = this.portal.findElement(By.linkText((String)"Admin interface"));
        this.portal.clickLink(adminInterfaceLink);
    }

    @Then(value="I see the admin interface")
    public void getAdminInterface() {
        WebElement adminInterface = this.portal.findElement(By.tagName((String)"title"));
        MatcherAssert.assertThat((Object)adminInterface.getText().trim(), (Matcher)Matchers.startsWith((String)"Rave admin interface"));
    }

    @When(value="I click the \"$usersLinkName\" link")
    public void clickUsersLink(String usersLinkName) {
        WebElement usersLink = this.portal.findElement(By.linkText((String)usersLinkName));
        usersLink.click();
    }

    @Then(value="I get the user search form")
    public void getUserList() {
        WebElement searchForm = this.portal.findElement(By.id((String)"userSearchForm"));
    }

    @When(value="I search for username \"$newuser\"")
    public void searchForNewUser(String newuser) {
        WebElement searchForm = this.portal.findElement(By.id((String)"userSearchForm"));
        searchForm.findElement(By.id((String)"searchTerm")).sendKeys(new CharSequence[]{newuser});
        searchForm.submit();
    }

    @Then(value="I see the matches for \"$newuser\"")
    public void getUserSearchMatches() {
        WebElement searchResultsHeading = this.portal.findElement(By.tagName((String)"h2"));
        MatcherAssert.assertThat((Object)searchResultsHeading.getText().trim(), (Matcher)CoreMatchers.equalTo((Object)"Showing 1 - 1 of 1 results that match 'newuser'"));
    }

    @When(value="I click the link for information on \"$newuser\"")
    public void clickLinkForUser(String newuser) {
        WebElement userLink = this.portal.findElement(By.linkText((String)newuser));
        userLink.click();
    }

    @Then(value="I see the information for user \"$newuser\"")
    public void getUserInformation(String newuser) {
        WebElement userProfileHeader = this.portal.findElement(By.tagName((String)"h2"));
        MatcherAssert.assertThat((Object)userProfileHeader.getText().trim(), (Matcher)CoreMatchers.equalTo((Object)newuser));
    }

    @When(value="I delete the the user \"$newuser\"")
    public void deleteNewUser() {
        WebElement deleteUserProfileForm = this.portal.findElement(By.id((String)"deleteUserProfile"));
        deleteUserProfileForm.findElement(By.id((String)"confirmdelete")).click();
        deleteUserProfileForm.submit();
    }

    @Then(value="I see \"$deletionConfirmationStatement\"")
    public void noResultsFound(String deletionConfirmationStatement) {
        WebElement confirmationText = this.portal.findElement(By.className((String)"alert"));
        MatcherAssert.assertThat((Object)confirmationText.getText().trim(), (Matcher)Matchers.startsWith((String)deletionConfirmationStatement));
    }

    @When(value="I log out")
    public void iLogOut() {
        this.portal.logout();
    }

    @Then(value="I see the Rave login page")
    public void backToLoginPage() {
        WebElement title = this.portal.findElement(By.tagName((String)"title"));
        MatcherAssert.assertThat((Object)title.getText().trim(), (Matcher)CoreMatchers.equalTo((Object)"Login - Rave"));
    }
}

