/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.integrationtests.steps;

import org.apache.rave.integrationtests.pages.Portal;
import org.apache.rave.integrationtests.steps.Step;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.springframework.beans.factory.annotation.Autowired;

@Step
public class UserAdminSteps {
    @Autowired
    private Portal portal;

    @Then(value="I get the user search form")
    public void getUserList() {
        WebElement searchForm = this.portal.findElement(By.id((String)"userSearchForm"));
    }

    @When(value="I search for username \"$newuser\"")
    public void searchForNewUser(String newuser) {
        WebElement searchForm = this.portal.findElement(By.id((String)"userSearchForm"));
        searchForm.findElement(By.id((String)"searchTerm")).sendKeys(new CharSequence[]{newuser});
        searchForm.submit();
    }

    @Then(value="I see the user matches for \"$newuser\"")
    public void getUserSearchMatches() {
        WebElement searchResultsHeading = this.portal.findElement(By.tagName((String)"h2"));
        MatcherAssert.assertThat((Object)searchResultsHeading.getText().trim(), (Matcher)CoreMatchers.equalTo((Object)"Showing 1 - 1 of 1 results that match 'newuser'"));
    }

    @When(value="I click the link for information on \"$newuser\"")
    public void clickLinkForUser(String newuser) {
        WebElement userLink = this.portal.findElement(By.linkText((String)newuser));
        userLink.click();
    }

    @Then(value="I see the information for user \"$newuser\"")
    public void getUserInformation(String newuser) {
        WebElement userProfileHeader = this.portal.findElement(By.tagName((String)"h2"));
        MatcherAssert.assertThat((Object)userProfileHeader.getText().trim(), (Matcher)CoreMatchers.equalTo((Object)newuser));
    }

    @When(value="I delete the the user \"$newuser\"")
    public void deleteNewUser() {
        WebElement deleteUserProfileForm = this.portal.findElement(By.id((String)"deleteUserProfile"));
        deleteUserProfileForm.findElement(By.id((String)"confirmdelete")).click();
        deleteUserProfileForm.submit();
    }

    @Then(value="I see \"$deletionConfirmationStatement\"")
    public void noResultsFound(String deletionConfirmationStatement) {
        WebElement confirmationText = this.portal.findElement(By.className((String)"alert"));
        MatcherAssert.assertThat((Object)confirmationText.getText().trim(), (Matcher)Matchers.startsWith((String)deletionConfirmationStatement));
    }
}

