/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.integrationtests.steps;

import org.apache.rave.integrationtests.pages.Portal;
import org.apache.rave.integrationtests.steps.Step;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.springframework.beans.factory.annotation.Autowired;

@Step
public class CategoryAdminSteps {
    @Autowired
    private Portal portal;

    @Given(value="I see the categories list table")
    @Then(value="I see the categories list table")
    public void isCategoryTableVisible() {
        WebElement table = this.portal.findElement(By.tagName((String)"H2"));
        MatcherAssert.assertThat((Object)table.getText().trim(), (Matcher)CoreMatchers.equalTo((Object)"Categories"));
    }

    @Given(value="I see the create category form")
    public void isCreateCategoryVisible() {
        WebElement btn = this.portal.findElement(By.tagName((String)"button"));
        MatcherAssert.assertThat((Object)btn.getText().trim(), (Matcher)CoreMatchers.equalTo((Object)"Create Category"));
    }

    @When(value="I fill in a new category named \"$categoryName\"")
    public void fillInNewCategory(String categoryName) {
        WebElement form = this.portal.findElement(By.id((String)"createCategory"));
        WebElement field = form.findElement(By.id((String)"text"));
        field.sendKeys(new CharSequence[]{categoryName});
    }

    @When(value="I click the \"Create Category\" button")
    public void clickCreateCategoryButton() {
        WebElement form = this.portal.findElement(By.id((String)"createCategory"));
        WebElement btn = form.findElement(By.tagName((String)"button"));
        btn.click();
    }

    @Given(value="I see a category called \"$categoryName\" in the categories list table")
    @Then(value="I see a category called \"$categoryName\" in the categories list table")
    public void isCategoryInTable(String categoryName) {
        WebElement categoryLink = this.getCategoryLinkFromListTable(categoryName);
        MatcherAssert.assertThat((Object)categoryLink, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)categoryLink.getText(), (Matcher)CoreMatchers.equalTo((Object)categoryName));
    }

    @When(value="I click on the category named \"$categoryName\"")
    public void clickOnCategoryInListTable(String categoryName) {
        WebElement link = this.getCategoryLinkFromListTable(categoryName);
        MatcherAssert.assertThat((Object)link, (Matcher)CoreMatchers.notNullValue());
        link.click();
    }

    @Then(value="I see the category details page")
    public void isCategoryDetailsPageVisible() {
        WebElement element = this.portal.findElement(By.id((String)"deleteCategory"));
        MatcherAssert.assertThat((Object)element, (Matcher)CoreMatchers.notNullValue());
    }

    @When(value="I change the name of the category to \"$categoryName\"")
    public void fillInUpdatedCategory(String categoryName) {
        WebElement form = this.portal.findElement(By.id((String)"updateCategory"));
        WebElement field = form.findElement(By.id((String)"text"));
        field.clear();
        field.sendKeys(new CharSequence[]{categoryName});
    }

    @When(value="I click the \"Update Category\" button")
    public void clickUpdateCategoryButton() {
        WebElement form = this.portal.findElement(By.id((String)"updateCategory"));
        WebElement btn = form.findElement(By.tagName((String)"button"));
        btn.click();
    }

    @When(value="I click the \"Delete Category\" button")
    public void clickDeleteCategoryButton() {
        WebElement form = this.portal.findElement(By.id((String)"deleteCategory"));
        WebElement btn = form.findElement(By.tagName((String)"button"));
        btn.click();
    }

    @Given(value="I do not see a category called \"$categoryName\" in the categories list table")
    @Then(value="I do not see a category called \"$categoryName\" in the categories list table")
    public void isCategoryNotInTable(String categoryName) {
        try {
            WebElement categoryLink = this.getCategoryLinkFromListTable(categoryName);
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @When(value="I select the delete checkbox")
    public void selectDeleteCategoryCheckbox() {
        WebElement form = this.portal.findElement(By.id((String)"deleteCategory"));
        WebElement chk = form.findElement(By.xpath((String)"fieldset/div/label/input"));
        chk.click();
    }

    private WebElement getCategoryLinkFromListTable(String categoryName) {
        WebElement table = this.portal.findElement(By.id((String)"categoryList"));
        return table.findElement(By.linkText((String)categoryName));
    }
}

