/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.webserver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.inject.Inject;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.reef.webserver.AvroDriverInfo;
import org.apache.reef.webserver.AvroReefServiceInfo;
import org.apache.reef.webserver.DriverInfoSerializer;

public class AvroDriverInfoSerializer
implements DriverInfoSerializer {
    @Inject
    AvroDriverInfoSerializer() {
    }

    @Override
    public AvroDriverInfo toAvro(String id, String startTime, List<AvroReefServiceInfo> services) {
        return AvroDriverInfo.newBuilder().setRemoteId(id).setStartTime(startTime).setServices(services).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String toString(AvroDriverInfo avroDriverInfo) {
        SpecificDatumWriter driverWriter = new SpecificDatumWriter(AvroDriverInfo.class);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            JsonEncoder encoder = EncoderFactory.get().jsonEncoder(avroDriverInfo.getSchema(), (OutputStream)out);
            driverWriter.write((Object)avroDriverInfo, (Encoder)encoder);
            encoder.flush();
            String string = out.toString("ISO-8859-1");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

