/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.webserver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.inject.Inject;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.reef.driver.evaluator.EvaluatorDescriptor;
import org.apache.reef.webserver.AvroEvaluatorEntry;
import org.apache.reef.webserver.AvroEvaluatorList;
import org.apache.reef.webserver.EvaluatorListSerializer;

public class AvroEvaluatorListSerializer
implements EvaluatorListSerializer {
    @Inject
    AvroEvaluatorListSerializer() {
    }

    @Override
    public AvroEvaluatorList toAvro(Map<String, EvaluatorDescriptor> evaluatorMap, int totalEvaluators, String startTime) {
        ArrayList<AvroEvaluatorEntry> EvaluatorEntities = new ArrayList<AvroEvaluatorEntry>();
        for (Map.Entry<String, EvaluatorDescriptor> entry : evaluatorMap.entrySet()) {
            EvaluatorDescriptor descriptor = entry.getValue();
            EvaluatorEntities.add(AvroEvaluatorEntry.newBuilder().setId(entry.getKey()).setName(descriptor.getNodeDescriptor().getName()).build());
        }
        return AvroEvaluatorList.newBuilder().setEvaluators(EvaluatorEntities).setTotal(totalEvaluators).setStartTime(startTime != null ? startTime : new Date().toString()).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String toString(AvroEvaluatorList avroEvaluatorList) {
        SpecificDatumWriter evaluatorWriter = new SpecificDatumWriter(AvroEvaluatorList.class);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            JsonEncoder encoder = EncoderFactory.get().jsonEncoder(avroEvaluatorList.getSchema(), (OutputStream)out);
            evaluatorWriter.write((Object)avroEvaluatorList, (Encoder)encoder);
            encoder.flush();
            String string = out.toString("ISO-8859-1");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

