/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.webserver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.servlet.ServletException;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.reef.webserver.AvroHttpRequest;
import org.apache.reef.webserver.ParsedHttpRequest;

public class AvroHttpSerializer {
    public static final String JSON_CHARSET = "ISO-8859-1";

    public AvroHttpRequest toAvro(ParsedHttpRequest parsedRequest) throws ServletException, IOException {
        return AvroHttpRequest.newBuilder().setRequestUrl(parsedRequest.getRequestUrl()).setHttpMethod(parsedRequest.getMethod()).setQueryString(parsedRequest.getQueryString()).setPathInfo(parsedRequest.getPathInfo()).setInputStream(ByteBuffer.wrap(parsedRequest.getInputStream())).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString(AvroHttpRequest request) {
        SpecificDatumWriter configurationWriter = new SpecificDatumWriter(AvroHttpRequest.class);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            JsonEncoder encoder = EncoderFactory.get().jsonEncoder(AvroHttpRequest.SCHEMA$, (OutputStream)out);
            configurationWriter.write((Object)request, (Encoder)encoder);
            encoder.flush();
            String string = out.toString(JSON_CHARSET);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] toBytes(AvroHttpRequest request) {
        SpecificDatumWriter requestWriter = new SpecificDatumWriter(AvroHttpRequest.class);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)out, null);
            requestWriter.write((Object)request, (Encoder)encoder);
            encoder.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public AvroHttpRequest fromString(String jasonStr) {
        try {
            JsonDecoder decoder = DecoderFactory.get().jsonDecoder(AvroHttpRequest.getClassSchema(), jasonStr);
            SpecificDatumReader reader = new SpecificDatumReader(AvroHttpRequest.class);
            return (AvroHttpRequest)((Object)reader.read(null, (Decoder)decoder));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public AvroHttpRequest fromBytes(byte[] theBytes) {
        try {
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(theBytes, null);
            SpecificDatumReader reader = new SpecificDatumReader(AvroHttpRequest.class);
            return (AvroHttpRequest)((Object)reader.read(null, (Decoder)decoder));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

