/*
 * Decompiled with CFR 0.152.
 */
package org.apache.reef.webserver;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.reef.runtime.yarn.driver.TrackingURLProvider;
import org.apache.reef.webserver.HttpServer;

public final class HttpTrackingURLProvider
implements TrackingURLProvider {
    private static final Logger LOG = Logger.getLogger(HttpTrackingURLProvider.class.getName());
    private final HttpServer httpServer;

    @Inject
    public HttpTrackingURLProvider(HttpServer httpServer) {
        this.httpServer = httpServer;
    }

    public final String getTrackingUrl() {
        try {
            return InetAddress.getLocalHost().getHostAddress() + ":" + this.httpServer.getPort();
        }
        catch (UnknownHostException e) {
            LOG.log(Level.WARNING, "Cannot get host address.", e);
            throw new RuntimeException("Cannot get host address.", e);
        }
    }
}

