/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.sun.jini.collection.WeakIdentityMap;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import net.jini.security.policy.DynamicPolicy;

public class LoaderSplitPolicyProvider
extends Policy
implements DynamicPolicy {
    private static final ProtectionDomain myDomain = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return LoaderSplitPolicyProvider.class.getProtectionDomain();
        }
    });
    private final ClassLoader loader;
    private final Policy loaderPolicy;
    private final Policy defaultPolicy;
    private final WeakIdentityMap delegateMap = new WeakIdentityMap();

    public LoaderSplitPolicyProvider(ClassLoader loader, Policy loaderPolicy, Policy defaultPolicy) {
        if (loader == null || loaderPolicy == null || defaultPolicy == null) {
            throw new NullPointerException();
        }
        this.loader = loader;
        this.loaderPolicy = loaderPolicy;
        this.defaultPolicy = defaultPolicy;
        this.ensureDependenciesResolved();
    }

    public PermissionCollection getPermissions(CodeSource source) {
        return this.defaultPolicy.getPermissions(source);
    }

    public PermissionCollection getPermissions(ProtectionDomain domain) {
        if (domain == myDomain) {
            Permissions pc = new Permissions();
            ((PermissionCollection)pc).add(new AllPermission());
            return pc;
        }
        return this.getDelegate(domain.getClassLoader()).getPermissions(domain);
    }

    public boolean implies(ProtectionDomain domain, Permission permission) {
        return domain == myDomain || this.getDelegate(domain.getClassLoader()).implies(domain, permission);
    }

    public void refresh() {
        this.loaderPolicy.refresh();
        this.defaultPolicy.refresh();
    }

    public boolean grantSupported() {
        return this.loaderPolicy instanceof DynamicPolicy && ((DynamicPolicy)this.loaderPolicy).grantSupported() && this.defaultPolicy instanceof DynamicPolicy && ((DynamicPolicy)this.defaultPolicy).grantSupported();
    }

    public void grant(Class cl, Principal[] principals, Permission[] permissions) {
        if (!this.grantSupported()) {
            throw new UnsupportedOperationException("grants not supported");
        }
        ((DynamicPolicy)this.getDelegate(LoaderSplitPolicyProvider.getClassLoader(cl))).grant(cl, principals, permissions);
    }

    public Permission[] getGrants(Class cl, Principal[] principals) {
        if (!this.grantSupported()) {
            throw new UnsupportedOperationException("grants not supported");
        }
        return ((DynamicPolicy)this.getDelegate(LoaderSplitPolicyProvider.getClassLoader(cl))).getGrants(cl, principals);
    }

    private void ensureDependenciesResolved() {
        this.getDelegate(this.loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Policy getDelegate(final ClassLoader ldr) {
        Policy p;
        if (ldr == null) {
            return this.loaderPolicy;
        }
        WeakIdentityMap weakIdentityMap = this.delegateMap;
        synchronized (weakIdentityMap) {
            p = (Policy)this.delegateMap.get(ldr);
        }
        if (p == null) {
            p = (Policy)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    for (ClassLoader l = ldr; l != null; l = l.getParent()) {
                        if (l != LoaderSplitPolicyProvider.this.loader) continue;
                        return LoaderSplitPolicyProvider.this.loaderPolicy;
                    }
                    return LoaderSplitPolicyProvider.this.defaultPolicy;
                }
            });
            weakIdentityMap = this.delegateMap;
            synchronized (weakIdentityMap) {
                this.delegateMap.put(ldr, p);
            }
        }
        return p;
    }

    private static ClassLoader getClassLoader(final Class cl) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cl.getClassLoader();
            }
        });
    }
}

