/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.sun.jini.config.Config;
import com.sun.jini.start.ActivateWrapper;
import com.sun.jini.start.ClassLoaderUtil;
import com.sun.jini.start.HTTPDStatus;
import com.sun.jini.start.NonActivatableServiceDescriptor;
import com.sun.jini.start.ServiceProxyAccessor;
import com.sun.jini.start.ServiceStarter;
import com.sun.jini.start.SharedActivationGroupDescriptor;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.rmi.MarshalledObject;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;

public class SharedActivatableServiceDescriptor
extends NonActivatableServiceDescriptor {
    private static final long serialVersionUID = 1L;
    private final String sharedGroupLog;
    private final boolean restart;
    private final String host;
    private final int port;
    private static final Logger logger = ServiceStarter.logger;
    private transient ProxyPreparer innerProxyPreparer;

    public SharedActivatableServiceDescriptor(String exportCodebase, String policy, String importCodebase, String implClassName, String sharedGroupLog, String[] serverConfigArgs, boolean restart) {
        this(exportCodebase, policy, importCodebase, implClassName, sharedGroupLog, serverConfigArgs, null, null, restart, null, ServiceStarter.getActivationSystemPort());
    }

    public SharedActivatableServiceDescriptor(String exportCodebase, String policy, String importCodebase, String implClassName, String sharedGroupLog, String[] serverConfigArgs, ProxyPreparer innerProxyPreparer, ProxyPreparer outerProxyPreparer, boolean restart) {
        this(exportCodebase, policy, importCodebase, implClassName, sharedGroupLog, serverConfigArgs, innerProxyPreparer, outerProxyPreparer, restart, null, ServiceStarter.getActivationSystemPort());
    }

    public SharedActivatableServiceDescriptor(String exportCodebase, String policy, String importCodebase, String implClassName, String sharedGroupLog, String[] serverConfigArgs, boolean restart, String host, int port) {
        this(exportCodebase, policy, importCodebase, implClassName, sharedGroupLog, serverConfigArgs, null, null, restart, host, port);
    }

    public SharedActivatableServiceDescriptor(String exportCodebase, String policy, String importCodebase, String implClassName, String sharedGroupLog, String[] serverConfigArgs, ProxyPreparer innerProxyPreparer, ProxyPreparer outerProxyPreparer, boolean restart, String host, int port) {
        super(exportCodebase, policy, importCodebase, implClassName, serverConfigArgs, outerProxyPreparer);
        if (sharedGroupLog == null) {
            throw new NullPointerException("Shared VM log cannot be null");
        }
        this.sharedGroupLog = sharedGroupLog;
        this.restart = restart;
        this.host = host == null ? "" : host;
        this.port = port <= 0 ? ServiceStarter.getActivationSystemPort() : port;
        this.innerProxyPreparer = innerProxyPreparer;
    }

    public final String getSharedGroupLog() {
        return this.sharedGroupLog;
    }

    public final boolean getRestart() {
        return this.restart;
    }

    public final String getActivationSystemHost() {
        return this.host;
    }

    public final int getActivationSystemPort() {
        return this.port;
    }

    public final ProxyPreparer getInnerProxyPreparer() {
        return this.innerProxyPreparer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInnerProxyPreparer(ProxyPreparer pp) {
        Object object = this.descCreatedLock;
        synchronized (object) {
            if (this.descCreated) {
                throw new IllegalStateException("Can't set ProxyPreparer after descriptor creation");
            }
            this.innerProxyPreparer = pp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create(Configuration config) throws Exception {
        ServiceStarter.ensureSecurityManager();
        logger.entering(SharedActivatableServiceDescriptor.class.getName(), "create", new Object[]{config});
        if (config == null) {
            throw new NullPointerException("Configuration argument cannot be null");
        }
        ProxyPreparer globalServicePreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)"com.sun.jini.start", (String)"servicePreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        if (this.getServicePreparer() == null) {
            this.setServicePreparer(globalServicePreparer);
        }
        Object object = this.descCreatedLock;
        synchronized (object) {
            this.descCreated = true;
        }
        Created created = null;
        ActivationSystem sys = ServiceStarter.getActivationSystem(this.getActivationSystemHost(), this.getActivationSystemPort(), config);
        ProxyPreparer activationIDPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)"com.sun.jini.start", (String)"activationIdPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        if (this.innerProxyPreparer == null) {
            this.innerProxyPreparer = globalServicePreparer;
        }
        HTTPDStatus.httpdWarning(this.getExportCodebase());
        ActivationGroupID gid = null;
        ActivationID aid = null;
        Object proxy = null;
        try {
            MarshalledObject<String[]> params = new MarshalledObject<String[]>(this.getServerConfigArgs());
            ActivateWrapper.ActivateDesc adesc = new ActivateWrapper.ActivateDesc(this.getImplClassName(), ClassLoaderUtil.getImportCodebaseURLs(this.getImportCodebase()), ClassLoaderUtil.getCodebaseURLs(this.getExportCodebase()), this.getPolicy(), params);
            logger.finest("ActivateDesc: " + adesc);
            gid = SharedActivationGroupDescriptor.restoreGroupID(this.getSharedGroupLog());
            aid = ActivateWrapper.register(gid, adesc, this.getRestart(), sys);
            aid = (ActivationID)activationIDPreparer.prepareProxy((Object)aid);
            proxy = aid.activate(true);
            if (proxy != null && (proxy = this.innerProxyPreparer.prepareProxy(proxy)) instanceof ServiceProxyAccessor) {
                if ((proxy = ((ServiceProxyAccessor)proxy).getServiceProxy()) != null) {
                    proxy = this.getServicePreparer().prepareProxy(proxy);
                } else {
                    logger.log(Level.FINE, "Service's getServiceProxy() returned null");
                }
            }
        }
        catch (Exception e) {
            try {
                if (aid != null) {
                    sys.unregisterObject(aid);
                }
            }
            catch (Exception ee) {
                logger.log(Level.FINEST, "Unable to unregister with activation system", ee);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ActivationException) {
                throw (ActivationException)e;
            }
            if (e instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e;
            }
            throw new RuntimeException("Unexpected Exception", e);
        }
        created = new Created(gid, aid, proxy);
        logger.exiting(SharedActivatableServiceDescriptor.class.getName(), "create", created);
        return created;
    }

    public String toString() {
        ArrayList<Object> fields = new ArrayList<Object>(12);
        fields.add(this.getExportCodebase());
        fields.add(this.getPolicy());
        fields.add(this.getImportCodebase());
        fields.add(this.getImplClassName());
        fields.add(this.getServerConfigArgs() == null ? null : Arrays.asList(this.getServerConfigArgs()));
        fields.add(this.getLifeCycle());
        fields.add(this.getServicePreparer());
        fields.add(this.getInnerProxyPreparer());
        fields.add(this.sharedGroupLog);
        fields.add(this.restart);
        fields.add(this.host);
        fields.add(new Integer(this.port));
        return fields.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.sharedGroupLog == null) {
            throw new InvalidObjectException("null shared group log");
        }
        if (this.host == null) {
            throw new InvalidObjectException("null activation host name");
        }
        if (this.port <= 0) {
            throw new InvalidObjectException("invalid activation port value: " + this.port);
        }
        this.innerProxyPreparer = null;
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("no data");
    }

    public static class Created {
        public final ActivationGroupID gid;
        public final ActivationID aid;
        public final Object proxy;

        public Created(ActivationGroupID gid, ActivationID aid, Object proxy) {
            this.gid = gid;
            this.aid = aid;
            this.proxy = proxy;
        }
    }
}

