/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import java.io.File;
import java.io.FilePermission;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public final class SharedActivationPolicyPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private FilePermission policyPermission;

    public SharedActivationPolicyPermission(String policy) {
        super(policy);
        this.init(policy);
    }

    public SharedActivationPolicyPermission(String policy, String action) {
        super(policy);
        this.init(policy);
    }

    private void init(String policy) {
        String uncanonicalPath = null;
        try {
            URL url = new URL(policy);
            uncanonicalPath = url.toExternalForm();
            uncanonicalPath = uncanonicalPath.replace('/', File.separatorChar);
        }
        catch (MalformedURLException me) {
            uncanonicalPath = policy;
        }
        this.policyPermission = new FilePermission(uncanonicalPath, "read");
    }

    public boolean implies(Permission p) {
        if (p == null) {
            return false;
        }
        if (!(p instanceof SharedActivationPolicyPermission)) {
            return false;
        }
        SharedActivationPolicyPermission other = (SharedActivationPolicyPermission)p;
        boolean answer = this.policyPermission.implies(other.policyPermission);
        return answer;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SharedActivationPolicyPermission)) {
            return false;
        }
        SharedActivationPolicyPermission other = (SharedActivationPolicyPermission)obj;
        boolean answer = this.policyPermission.equals(other.policyPermission);
        return answer;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return new Collection();
    }

    private static class Collection
    extends PermissionCollection {
        private static final long serialVersionUID = 1L;
        private final ArrayList perms = new ArrayList(3);

        private Collection() {
        }

        public synchronized void add(Permission p) {
            if (this.isReadOnly()) {
                throw new SecurityException("Collection cannot be modified.");
            }
            if (this.perms.indexOf(p) < 0) {
                this.perms.add(p);
            }
        }

        public synchronized boolean implies(Permission p) {
            int i = this.perms.size();
            while (--i >= 0) {
                if (!((Permission)this.perms.get(i)).implies(p)) continue;
                return true;
            }
            return false;
        }

        public Enumeration elements() {
            return Collections.enumeration(this.perms);
        }
    }
}

