/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JarWrapper {
    private static ResourceBundle resources;
    private static final Object resourcesLock;
    private static final Logger logger;
    private final File destJar;
    private final File baseDir;
    private final SourceJarURL[] srcJars;
    private final Manifest manifest;
    private final MessageDigest digest;
    private final JarIndexWriter indexWriter;
    private final PreferredListWriter prefWriter;
    private final StringBuffer classPath = new StringBuffer();
    private String mainClass = null;
    private final Set seenJars = new HashSet();
    private static final String DEFAULT_HTTPMD_ALGORITHM = "SHA-1";

    private JarWrapper(String destJar, String baseDir, String[] srcJars, String httpmdAlg, boolean index, Manifest mf, List apiClasses) {
        this.destJar = new File(destJar);
        if (this.destJar.exists()) {
            throw new LocalizedIllegalArgumentException("jarwrapper.fileexists", destJar);
        }
        if (baseDir != null) {
            this.baseDir = new File(baseDir);
            if (!this.baseDir.isDirectory()) {
                throw new LocalizedIllegalArgumentException("jarwrapper.invalidbasedir", baseDir);
            }
        } else {
            this.baseDir = null;
        }
        this.srcJars = new SourceJarURL[srcJars.length];
        for (int i = 0; i < srcJars.length; ++i) {
            try {
                SourceJarURL url;
                if (baseDir == null) {
                    File file = new File(srcJars[i]);
                    url = new SourceJarURL(file.getName(), file.getParentFile());
                } else {
                    url = new SourceJarURL(srcJars[i]);
                }
                if (url.algorithm != null) {
                    throw new LocalizedIllegalArgumentException("jarwrapper.urlhasdigest", url);
                }
                this.srcJars[i] = url;
                continue;
            }
            catch (LocalizedIOException e) {
                throw new LocalizedIllegalArgumentException(e);
            }
            catch (IOException e) {
                throw (IllegalArgumentException)new IllegalArgumentException(e.getMessage()).initCause(e);
            }
        }
        if (httpmdAlg != null) {
            try {
                this.digest = MessageDigest.getInstance(httpmdAlg);
            }
            catch (NoSuchAlgorithmException e) {
                throw (IllegalArgumentException)new LocalizedIllegalArgumentException("jarwrapper.invalidhttpmdalg", httpmdAlg).initCause(e);
            }
        } else {
            this.digest = null;
        }
        this.manifest = mf != null ? new Manifest(mf) : new Manifest();
        this.indexWriter = index ? new JarIndexWriter() : null;
        ArrayList<String> classes = new ArrayList<String>();
        if (apiClasses != null) {
            for (String className : apiClasses) {
                if (className == null) continue;
                classes.add(className.replace('.', '/') + ".class");
            }
        }
        this.prefWriter = new PreferredListWriter(classes);
    }

    public static void main(String[] args) {
        String httpmdAlg = null;
        boolean index = true;
        Manifest mf = null;
        int i = 0;
        while (i < args.length && args[i].startsWith("-")) {
            int split;
            String s;
            if ((s = args[i++]).equals("-help")) {
                System.err.println(JarWrapper.localize("jarwrapper.usage"));
                System.exit(0);
                continue;
            }
            if (s.equals("-verbose")) {
                JarWrapper.setLoggingLevel(Level.FINER);
                continue;
            }
            if (s.equals("-debug")) {
                JarWrapper.setLoggingLevel(Level.ALL);
                continue;
            }
            if (s.equals("-httpmd") || s.startsWith("-httpmd=")) {
                if (httpmdAlg != null) {
                    System.err.println(JarWrapper.localize("jarwrapper.multiplehttpmd"));
                    System.err.println(JarWrapper.localize("jarwrapper.usage"));
                    System.exit(1);
                }
                httpmdAlg = (split = s.indexOf(61)) != -1 ? s.substring(split + 1) : DEFAULT_HTTPMD_ALGORITHM;
                continue;
            }
            if (s.startsWith("-manifest=")) {
                split = s.indexOf(61);
                String fileName = s.substring(split + 1);
                try {
                    mf = JarWrapper.retrieveManifest(fileName);
                }
                catch (IOException ioe) {
                    System.err.println(JarWrapper.localize("jarwrapper.badmanifest", s));
                    System.exit(1);
                }
                continue;
            }
            if (s.equals("-noindex")) {
                index = false;
                continue;
            }
            System.err.println(JarWrapper.localize("jarwrapper.badoption", s));
            System.err.println(JarWrapper.localize("jarwrapper.usage"));
            System.exit(1);
        }
        if (args.length - i < 3) {
            System.err.println(JarWrapper.localize("jarwrapper.insufficientargs"));
            System.err.println(JarWrapper.localize("jarwrapper.usage"));
            System.exit(1);
        }
        String destJar = args[i++];
        String baseDir = args[i++];
        String[] srcJars = new String[args.length - i];
        System.arraycopy(args, i, srcJars, 0, srcJars.length);
        try {
            JarWrapper.wrap(destJar, baseDir, srcJars, httpmdAlg, index, mf);
        }
        catch (Throwable t) {
            if (t instanceof LocalizedIllegalArgumentException || t instanceof LocalizedIOException) {
                System.err.println(t.getMessage());
            } else {
                System.err.println(JarWrapper.localize("jarwrapper.fatalexception"));
                t.printStackTrace();
            }
            System.exit(1);
        }
    }

    public static void wrap(String destJar, String baseDir, String[] srcJars, String httpmdAlg, boolean index) throws IOException {
        JarWrapper.wrap(destJar, baseDir, srcJars, httpmdAlg, index, null);
    }

    public static void wrap(String destJar, String baseDir, String[] srcJars, String httpmdAlg, boolean index, Manifest mf) throws IOException {
        JarWrapper.wrap(destJar, baseDir, srcJars, httpmdAlg, index, mf, null);
    }

    public static void wrap(String destJar, String baseDir, String[] srcJars, String httpmdAlg, boolean index, Manifest mf, List apiClasses) throws IOException {
        new JarWrapper(destJar, baseDir, srcJars, httpmdAlg, index, mf, apiClasses).wrap();
    }

    public static void wrap(String destJar, String[] srcJars, String httpmdAlg, boolean index, Manifest mf, List apiClasses) throws IOException {
        new JarWrapper(destJar, null, srcJars, httpmdAlg, index, mf, apiClasses).wrap();
    }

    private void wrap() throws IOException {
        for (int i = 0; i < this.srcJars.length; ++i) {
            this.process(this.srcJars[i], null);
        }
        this.outputWrapperJar();
    }

    private void process(SourceJarURL url, PreferredListReader prefReader) throws IOException {
        boolean checkMainClass;
        File file = this.baseDir == null ? url.toFile() : url.toFile(this.baseDir);
        boolean seen = this.seenJars.contains(file);
        boolean bl = checkMainClass = this.mainClass == null && prefReader == null;
        if (seen && !checkMainClass) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "processing {0}", new Object[]{file});
        }
        if (!file.exists()) {
            throw new LocalizedIOException("jarwrapper.filenotfound", file);
        }
        JarFile jar = new JarFile(file, false);
        if (checkMainClass) {
            this.mainClass = JarWrapper.getMainClass(jar);
        }
        if (!seen) {
            this.seenJars.add(file);
            if (this.digest != null) {
                url = new SourceJarURL(url.path, this.digest.getAlgorithm(), JarWrapper.getDigestString(this.digest, file), null);
            }
            if (this.classPath.length() > 0) {
                this.classPath.append(' ');
            }
            this.classPath.append(url);
            if (this.indexWriter != null) {
                this.indexWriter.addEntries(jar, url);
            }
            if (prefReader == null) {
                prefReader = new PreferredListReader(jar);
            }
            this.prefWriter.addEntries(jar, prefReader);
            ArrayList l = new ArrayList();
            l.addAll(new JarIndexReader(jar).getJars());
            l.addAll(this.getClassPath(jar));
            for (SourceJarURL u : l) {
                u = url.resolve(new SourceJarURL(u.path, null, null, null));
                this.process(u, prefReader);
            }
        }
    }

    private List getClassPath(JarFile jar) throws IOException {
        Manifest mf = jar.getManifest();
        if (mf == null) {
            return Collections.EMPTY_LIST;
        }
        Attributes atts = mf.getMainAttributes();
        String cp = atts.getValue(Attributes.Name.CLASS_PATH);
        if (cp == null) {
            return Collections.EMPTY_LIST;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Class-Path: {0}", new Object[]{cp});
        }
        ArrayList<SourceJarURL> l = new ArrayList<SourceJarURL>();
        StringTokenizer tok = new StringTokenizer(cp, " ");
        while (tok.hasMoreTokens()) {
            SourceJarURL url = new SourceJarURL(tok.nextToken());
            if (this.digest != null && url.algorithm == null) {
                throw new LocalizedIOException("jarwrapper.nonhttpmdurl", url);
            }
            l.add(url);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputWrapperJar() throws IOException {
        Attributes.Name creatorName;
        Attributes atts;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "writing {0}", new Object[]{this.destJar});
        }
        if ((atts = this.manifest.getMainAttributes()).get(Attributes.Name.MANIFEST_VERSION) == null) {
            atts.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        if (atts.get(creatorName = new Attributes.Name("Created-By")) == null) {
            atts.put(creatorName, JarWrapper.class.getName());
        }
        if (atts.get(Attributes.Name.CLASS_PATH) == null) {
            atts.put(Attributes.Name.CLASS_PATH, this.classPath.toString());
        }
        if (atts.get(Attributes.Name.MAIN_CLASS) == null && this.mainClass != null) {
            atts.put(Attributes.Name.MAIN_CLASS, this.mainClass);
        }
        boolean completed = false;
        try {
            JarOutputStream jout = new JarOutputStream((OutputStream)new FileOutputStream(this.destJar), this.manifest);
            if (this.indexWriter != null) {
                this.indexWriter.write(jout);
            }
            this.prefWriter.write(jout);
            jout.close();
            completed = true;
            Object var6_5 = null;
            if (!completed) {
                this.deleteWrapperJar();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!completed) {
                this.deleteWrapperJar();
            }
            throw throwable;
        }
    }

    private void deleteWrapperJar() {
        try {
            if (!this.destJar.delete() && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "failed to delete {0}", new Object[]{this.destJar});
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "exception deleting wrapper JAR file", t);
        }
    }

    private static String getMainClass(JarFile jar) throws IOException {
        Manifest mf = jar.getManifest();
        if (mf == null) {
            return null;
        }
        Attributes atts = mf.getMainAttributes();
        String mc = atts.getValue(Attributes.Name.MAIN_CLASS);
        if (mc != null && logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Main-Class: {0}", new Object[]{mc});
        }
        return mc;
    }

    private static String getDigestString(MessageDigest digest, File file) throws IOException {
        int n;
        FileInputStream fin = new FileInputStream(file);
        byte[] buf = new byte[2048];
        while ((n = fin.read(buf)) >= 0) {
            digest.update(buf, 0, n);
        }
        buf = digest.digest();
        fin.close();
        StringBuffer sb = new StringBuffer(buf.length * 2);
        for (int i = 0; i < buf.length; ++i) {
            byte b = buf[i];
            sb.append(Character.forDigit(b >> 4 & 0xF, 16));
            sb.append(Character.forDigit(b & 0xF, 16));
        }
        return sb.toString();
    }

    private static void setLoggingLevel(Level level) {
        logger.setLevel(level);
        for (Logger l = logger; l != null; l = l.getParent()) {
            Handler[] handlers = l.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                if (!(handlers[i] instanceof ConsoleHandler)) continue;
                handlers[i].setLevel(level);
            }
            if (!l.getUseParentHandlers()) break;
        }
    }

    static String localize(String key) {
        return JarWrapper.localize(key, new Object[0]);
    }

    static String localize(String key, Object val) {
        return JarWrapper.localize(key, new Object[]{val});
    }

    static String localize(String key, Object[] vals) {
        String fmt = JarWrapper.getResourceString(key);
        if (fmt == null) {
            return "error: no text found in resource bundle for key: " + key;
        }
        return MessageFormat.format(fmt, vals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResourceString(String key) {
        Object object = resourcesLock;
        synchronized (object) {
            if (resources == null) {
                resources = ResourceBundle.getBundle("com.sun.jini.tool.resources.jarwrapper");
            }
        }
        try {
            return resources.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static Manifest retrieveManifest(String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        Manifest mf = new Manifest(fis);
        fis.close();
        return mf;
    }

    static {
        resourcesLock = new Object();
        logger = Logger.getLogger(JarWrapper.class.getName());
    }

    private static class PreferredListWriter {
        private static final int NAME_LEN = "Name: ".length();
        private static final int PREFERRED_LEN = "Preferred: ".length();
        private static final int TRUE_LEN = "true".length();
        private static final int FALSE_LEN = "false".length();
        private static final int NEWLINE_LEN = "\n".length();
        private final HashMap pathMap = new HashMap();
        private final DirNode rootNode = new DirNode("");
        private int numPrefs = 0;
        private final List apiClasses;

        PreferredListWriter(List apiClasses) {
            this.apiClasses = apiClasses;
            this.pathMap.put("", this.rootNode);
        }

        void addEntries(JarFile jar, PreferredListReader prefReader) throws IOException {
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                String path = e.nextElement().getName();
                if (path.startsWith("META-INF") || path.endsWith("/")) continue;
                boolean pref = prefReader.isPreferred(path);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, pref ? "preferred: {0}" : "not preferred: {0}", new Object[]{path});
                }
                this.addFile(path, jar.getName(), pref);
            }
        }

        void write(JarOutputStream jout) throws IOException {
            if (this.numPrefs == 0) {
                logger.finer("omitting empty preferred list");
                return;
            }
            logger.finer("writing preferred list");
            jout.putNextEntry(new JarEntry("META-INF/PREFERRED.LIST"));
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)jout, "UTF8"));
            w.write("PreferredResources-Version: 1.0\n");
            this.rootNode.compileList();
            this.rootNode.writeList(w);
            ((Writer)w).flush();
            jout.closeEntry();
        }

        private void addFile(String path, String jarFileName, boolean preferred) throws IOException {
            DirNode dn;
            FileNode fn = (FileNode)this.pathMap.get(path);
            if (fn != null) {
                if (fn.preferred != preferred) {
                    if (this.apiClasses.contains(path)) {
                        if (fn.preferred) {
                            fn.preferred = false;
                            --this.numPrefs;
                        }
                    } else {
                        throw new LocalizedIOException("jarwrapper.prefconflict", new Object[]{path, jarFileName, fn.jarFileName});
                    }
                }
                return;
            }
            fn = new FileNode(path, jarFileName, preferred);
            this.pathMap.put(path, fn);
            if (preferred) {
                ++this.numPrefs;
            }
            if ((dn = (DirNode)this.pathMap.get(path = PreferredListWriter.parentPath(path))) != null) {
                dn.files.add(fn);
                return;
            }
            dn = new DirNode(path);
            this.pathMap.put(path, dn);
            dn.files.add(fn);
            path = PreferredListWriter.parentPath(path);
            while (true) {
                DirNode pn;
                if ((pn = (DirNode)this.pathMap.get(path)) != null) {
                    pn.subdirs.add(dn);
                    return;
                }
                pn = new DirNode(path);
                this.pathMap.put(path, pn);
                pn.subdirs.add(dn);
                dn = pn;
                path = PreferredListWriter.parentPath(path);
            }
        }

        private static String parentPath(String path) {
            int i;
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            return (i = path.lastIndexOf(47)) >= 0 ? path.substring(0, i + 1) : "";
        }

        static int min(int i1, int i2, int i3) {
            return Math.min(i1, Math.min(i2, i3));
        }

        static int calcEntryLength(String name, boolean pref) {
            int len = NEWLINE_LEN;
            if (name != null) {
                len += NAME_LEN + name.length() + NEWLINE_LEN;
            }
            return len += PREFERRED_LEN + (pref ? TRUE_LEN : FALSE_LEN) + NEWLINE_LEN;
        }

        static void writeEntry(Writer w, String name, boolean pref) throws IOException {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "writing preferred list entry {0}: {1}", new Object[]{name != null ? name : "<default>", pref});
            }
            w.write("\n");
            if (name != null) {
                w.write("Name: " + name + "\n");
            }
            w.write("Preferred: " + pref + "\n");
        }

        private class DirNode {
            final String path;
            final List subdirs = new ArrayList();
            final List files = new ArrayList();
            int prefSubtreeLen;
            int prefPackageLen;
            int unprefSubtreeLen;
            int unprefPackageLen;

            DirNode(String path) {
                this.path = path;
            }

            void compileList() {
                int prefLen = 0;
                int unprefLen = 0;
                for (FileNode fn : this.files) {
                    int j = fn.path.lastIndexOf(36);
                    while (j != -1) {
                        FileNode fn2 = (FileNode)PreferredListWriter.this.pathMap.get(fn.path.substring(0, j) + ".class");
                        if (fn2 != null) {
                            fn.action = fn.preferred == fn2.preferred ? 1 : 2;
                            break;
                        }
                        j = fn.path.lastIndexOf(36, j - 1);
                    }
                    int entryLen = PreferredListWriter.calcEntryLength(fn.path, fn.preferred);
                    if (fn.action == 1) continue;
                    if (fn.action == 2) {
                        prefLen += entryLen;
                        unprefLen += entryLen;
                        continue;
                    }
                    if (fn.preferred) {
                        unprefLen += entryLen;
                        continue;
                    }
                    prefLen += entryLen;
                }
                this.prefSubtreeLen = prefLen;
                this.prefPackageLen = prefLen;
                this.unprefSubtreeLen = unprefLen;
                this.unprefPackageLen = unprefLen;
                for (DirNode dn : this.subdirs) {
                    dn.compileList();
                    String subtreePath = dn.path + "-";
                    this.prefSubtreeLen += PreferredListWriter.min(dn.prefSubtreeLen, dn.unprefSubtreeLen + PreferredListWriter.calcEntryLength(subtreePath, false), dn.unprefPackageLen + PreferredListWriter.calcEntryLength(dn.path, false));
                    this.prefPackageLen += PreferredListWriter.min(dn.prefSubtreeLen + PreferredListWriter.calcEntryLength(subtreePath, true), dn.prefPackageLen + PreferredListWriter.calcEntryLength(dn.path, true), dn.unprefSubtreeLen);
                    this.unprefSubtreeLen += PreferredListWriter.min(dn.prefSubtreeLen + PreferredListWriter.calcEntryLength(subtreePath, true), dn.prefPackageLen + PreferredListWriter.calcEntryLength(dn.path, true), dn.unprefSubtreeLen);
                    this.unprefPackageLen += PreferredListWriter.min(dn.prefSubtreeLen, dn.unprefSubtreeLen + PreferredListWriter.calcEntryLength(subtreePath, false), dn.unprefPackageLen + PreferredListWriter.calcEntryLength(dn.path, false));
                }
            }

            void writeList(Writer w) throws IOException {
                boolean defaultPref;
                int totalPrefSubtreeLen = this.prefSubtreeLen + PreferredListWriter.calcEntryLength(null, true);
                boolean bl = defaultPref = totalPrefSubtreeLen < this.unprefSubtreeLen;
                if (defaultPref) {
                    PreferredListWriter.writeEntry(w, null, true);
                }
                this.writeFiles(w, defaultPref);
                Iterator i = this.subdirs.iterator();
                while (i.hasNext()) {
                    ((DirNode)i.next()).writeDir(w, defaultPref);
                }
            }

            void writeDir(Writer w, boolean contextPref) throws IOException {
                boolean subdirPref;
                boolean dirPref;
                int best;
                String subtreePath = this.path + "-";
                if (contextPref) {
                    int totalUnprefSubtreeLen;
                    int totalUnprefPackageLen = this.unprefPackageLen + PreferredListWriter.calcEntryLength(this.path, false);
                    best = PreferredListWriter.min(this.prefSubtreeLen, totalUnprefPackageLen, totalUnprefSubtreeLen = this.unprefSubtreeLen + PreferredListWriter.calcEntryLength(subtreePath, false));
                    if (best == this.prefSubtreeLen) {
                        dirPref = true;
                        subdirPref = true;
                    } else if (best == totalUnprefPackageLen) {
                        PreferredListWriter.writeEntry(w, this.path, false);
                        dirPref = false;
                        subdirPref = true;
                    } else {
                        PreferredListWriter.writeEntry(w, subtreePath, false);
                        dirPref = false;
                        subdirPref = false;
                    }
                } else {
                    int totalPrefSubtreeLen;
                    int totalPrefPackageLen = this.prefPackageLen + PreferredListWriter.calcEntryLength(this.path, true);
                    best = PreferredListWriter.min(this.unprefSubtreeLen, totalPrefPackageLen, totalPrefSubtreeLen = this.prefSubtreeLen + PreferredListWriter.calcEntryLength(subtreePath, true));
                    if (best == this.unprefSubtreeLen) {
                        dirPref = false;
                        subdirPref = false;
                    } else if (best == totalPrefPackageLen) {
                        PreferredListWriter.writeEntry(w, this.path, true);
                        dirPref = true;
                        subdirPref = false;
                    } else {
                        PreferredListWriter.writeEntry(w, subtreePath, true);
                        dirPref = true;
                        subdirPref = true;
                    }
                }
                this.writeFiles(w, dirPref);
                Iterator i = this.subdirs.iterator();
                while (i.hasNext()) {
                    ((DirNode)i.next()).writeDir(w, subdirPref);
                }
            }

            void writeFiles(Writer w, boolean contextPref) throws IOException {
                for (FileNode fn : this.files) {
                    if (fn.action == 1 || fn.action != 2 && fn.preferred == contextPref) continue;
                    PreferredListWriter.writeEntry(w, fn.path, fn.preferred);
                }
            }
        }

        private static class FileNode {
            static final int NONE = 0;
            static final int SKIP = 1;
            static final int INCLUDE = 2;
            final String path;
            final String jarFileName;
            boolean preferred;
            int action;

            FileNode(String path, String jarFileName, boolean preferred) {
                this.path = path;
                this.preferred = preferred;
                this.jarFileName = jarFileName;
            }
        }
    }

    private static class PreferredListReader {
        private static final Pattern headerPattern = Pattern.compile("^PreferredResources-Version:\\s*(.*?)$");
        private static final Pattern versionPattern = Pattern.compile("^1\\.\\d+$");
        private static final Pattern namePattern = Pattern.compile("^Name:\\s*(.*)$");
        private static final Pattern preferredPattern = Pattern.compile("^Preferred:\\s*(.*)$");
        private final boolean defaultPref;
        private final Map namePrefs = new HashMap();
        private final Map packagePrefs = new HashMap();
        private final Map subtreePrefs = new HashMap();

        PreferredListReader(JarFile jar) throws IOException {
            JarEntry ent = jar.getJarEntry("META-INF/PREFERRED.LIST");
            if (ent == null) {
                this.defaultPref = false;
                return;
            }
            logger.finer("reading preferred list");
            BufferedReader r = new BufferedReader(new InputStreamReader(jar.getInputStream(ent), "UTF8"));
            String s = r.readLine();
            if (s == null) {
                throw new IOException("missing preferred list header");
            }
            Matcher m = headerPattern.matcher(s = s.trim());
            if (!m.matches()) {
                throw new IOException("illegal preferred list header: " + s);
            }
            s = m.group(1);
            if (!versionPattern.matcher(s).matches()) {
                throw new IOException("unsupported preferred list version: " + s);
            }
            s = PreferredListReader.nextNonBlankLine(r);
            if (s == null) {
                throw new IOException("empty preferred list");
            }
            m = preferredPattern.matcher(s);
            if (m.matches()) {
                this.defaultPref = Boolean.valueOf(m.group(1));
                s = PreferredListReader.nextNonBlankLine(r);
            } else {
                this.defaultPref = false;
            }
            while (s != null) {
                Map map;
                String key;
                m = namePattern.matcher(s);
                if (!m.matches()) {
                    throw new IOException("expected preferred entry name: " + s);
                }
                String name = m.group(1);
                s = PreferredListReader.nextNonBlankLine(r);
                if (s == null) {
                    throw new IOException("EOF before preferred entry");
                }
                m = preferredPattern.matcher(s);
                if (!m.matches()) {
                    throw new IOException("expected preferred entry: " + s);
                }
                Boolean pref = Boolean.valueOf(m.group(1));
                if (name.endsWith("/*")) {
                    key = name.substring(0, name.length() - 2);
                    map = this.packagePrefs;
                } else if (name.endsWith("/")) {
                    key = name.substring(0, name.length() - 1);
                    map = this.packagePrefs;
                } else if (name.endsWith("/-")) {
                    key = name.substring(0, name.length() - 2);
                    map = this.subtreePrefs;
                } else {
                    key = name;
                    map = this.namePrefs;
                }
                if (key.length() == 0) {
                    throw new IOException("invalid preferred entry name: " + name);
                }
                map.put(key, pref);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "read preferred list entry {0}: {1}", new Object[]{name, pref});
                }
                s = PreferredListReader.nextNonBlankLine(r);
            }
        }

        boolean isPreferred(String entry) {
            int i;
            Boolean b = (Boolean)this.namePrefs.get(entry);
            if (b != null) {
                return b;
            }
            if (entry.endsWith(".class")) {
                i = entry.lastIndexOf(36);
                while (i >= 0) {
                    String outer = entry.substring(0, i) + ".class";
                    b = (Boolean)this.namePrefs.get(outer);
                    if (b != null) {
                        return b;
                    }
                    i = entry.lastIndexOf(36, i - 1);
                }
            }
            if ((i = entry.lastIndexOf(47)) >= 0) {
                String base = entry.substring(0, i);
                b = (Boolean)this.packagePrefs.get(base);
                if (b != null) {
                    return b;
                }
                while (true) {
                    if ((b = (Boolean)this.subtreePrefs.get(base)) != null) {
                        return b;
                    }
                    i = base.lastIndexOf(47);
                    if (i < 0) break;
                    base = base.substring(0, i);
                }
            }
            return this.defaultPref;
        }

        private static String nextNonBlankLine(BufferedReader reader) throws IOException {
            String s;
            while ((s = reader.readLine()) != null) {
                if ((s = s.trim()).length() <= 0 || s.charAt(0) == '#') continue;
                return s;
            }
            return null;
        }
    }

    private static class JarIndexWriter {
        private final List urls = new ArrayList();
        private final Map contentMap = new HashMap();

        JarIndexWriter() {
        }

        void addEntries(JarFile jar, SourceJarURL url) {
            HashSet<String> contents = new HashSet<String>();
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                String name = e.nextElement().getName();
                if (name.startsWith("META-INF") || name.endsWith("/")) continue;
                int pos = name.lastIndexOf("/");
                contents.add(pos != -1 ? name.substring(0, pos) : name);
            }
            if (!contents.isEmpty()) {
                this.urls.add(url);
                this.contentMap.put(url, contents);
            }
        }

        void write(JarOutputStream jout) throws IOException {
            if (this.contentMap.isEmpty()) {
                logger.finer("omitting empty JAR index");
                return;
            }
            logger.finer("writing JAR index");
            jout.putNextEntry(new JarEntry("META-INF/INDEX.LIST"));
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)jout, "UTF8"));
            w.write("JarIndex-Version: 1.0\n\n");
            for (SourceJarURL url : this.urls) {
                Set contents = (Set)this.contentMap.get(url);
                if (!url.raw.endsWith(".jar")) {
                    if (url.algorithm != null) {
                        url = new SourceJarURL(url.path, url.algorithm, url.digest, ".jar");
                    } else if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "JAR index entry {0} does not end in .jar", new Object[]{url});
                    }
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "writing JAR index entry {0}: {1}", new Object[]{url, contents});
                }
                w.write(url + "\n");
                Iterator j = contents.iterator();
                while (j.hasNext()) {
                    w.write(j.next() + "\n");
                }
                w.write("\n");
            }
            ((Writer)w).flush();
            jout.closeEntry();
        }
    }

    private static class JarIndexReader {
        private static final Pattern headerPattern = Pattern.compile("^JarIndex-Version:\\s*(.*?)$");
        private static final Pattern versionPattern = Pattern.compile("^1(\\.\\d+)*$");
        private final List jars;

        JarIndexReader(JarFile jar) throws IOException {
            ArrayList<SourceJarURL> l = new ArrayList<SourceJarURL>();
            this.jars = Collections.unmodifiableList(l);
            JarEntry ent = jar.getJarEntry("META-INF/INDEX.LIST");
            if (ent == null) {
                return;
            }
            logger.finer("reading JAR index");
            BufferedReader r = new BufferedReader(new InputStreamReader(jar.getInputStream(ent), "UTF8"));
            String s = r.readLine();
            if (s == null) {
                throw new IOException("missing JAR index header");
            }
            Matcher m = headerPattern.matcher(s = s.trim());
            if (!m.matches()) {
                throw new IOException("illegal JAR index header: " + s);
            }
            s = m.group(1);
            if (!versionPattern.matcher(s).matches()) {
                throw new IOException("unsupported JAR index version: " + s);
            }
            s = r.readLine();
            if (s == null) {
                throw new IOException("truncated JAR index");
            }
            if ((s = s.trim()).length() > 0) {
                throw new IOException("non-empty line after JAR index header: " + s);
            }
            while ((s = r.readLine()) != null) {
                SourceJarURL url = new SourceJarURL(s.trim());
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "JAR index references {0}", new Object[]{url});
                }
                l.add(url);
                while ((s = r.readLine()) != null && s.trim().length() > 0) {
                }
            }
            if (l.isEmpty()) {
                throw new IOException("empty JAR index");
            }
        }

        List getJars() {
            return this.jars;
        }
    }

    private static class SourceJarURL {
        private static final Pattern httpmdPattern = Pattern.compile("(.*);(.+?)=(.+?)(?:,(.*))?$");
        final String raw;
        final String path;
        final String algorithm;
        final String digest;
        final String comment;
        private File baseDir;

        SourceJarURL(String raw) throws IOException {
            try {
                this.raw = raw;
                Matcher m = httpmdPattern.matcher(raw);
                if (m.matches()) {
                    this.path = m.group(1);
                    this.algorithm = m.group(2);
                    this.digest = m.group(3);
                    this.comment = m.group(4);
                } else {
                    this.path = raw;
                    this.algorithm = null;
                    this.digest = null;
                    this.comment = null;
                }
                URI uri = new URI(this.path);
                if (uri.getScheme() != null) {
                    throw new LocalizedIOException("jarwrapper.urlhasscheme", raw);
                }
                if (uri.getAuthority() != null) {
                    throw new LocalizedIOException("jarwrapper.urlhasauthority", raw);
                }
                String p = uri.getPath();
                if (p == null || p.length() == 0) {
                    throw new LocalizedIOException("jarwrapper.urlemptypath", raw);
                }
                if (p.startsWith("/")) {
                    throw new LocalizedIOException("jarwrapper.urlabsolute", raw);
                }
            }
            catch (URISyntaxException e) {
                throw (IOException)new LocalizedIOException("jarwrapper.invalidurlsyntax", raw).initCause(e);
            }
        }

        SourceJarURL(String raw, File baseDir) throws IOException {
            this(raw);
            this.baseDir = baseDir;
        }

        SourceJarURL(String path, String algorithm, String digest, String comment) {
            this.raw = algorithm != null ? path + ';' + algorithm + '=' + digest + (comment != null ? ',' + comment : "") : path;
            this.path = path;
            this.algorithm = algorithm;
            this.digest = digest;
            this.comment = comment;
        }

        SourceJarURL resolve(SourceJarURL other) {
            try {
                URI uri = new URI('/' + this.path);
                String p = uri.resolve(other.path).getPath().substring(1);
                return new SourceJarURL(p, other.algorithm, other.digest, other.comment);
            }
            catch (URISyntaxException e) {
                throw new AssertionError((Object)e);
            }
        }

        File toFile() {
            return this.toFile(this.baseDir);
        }

        File toFile(File base) {
            try {
                String p = new URI(this.path).getPath();
                return new File(base, p.replace('/', File.separatorChar));
            }
            catch (URISyntaxException e) {
                throw (Error)new InternalError().initCause(e);
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof SourceJarURL && this.raw.equals(((SourceJarURL)obj).raw);
        }

        public int hashCode() {
            return this.raw.hashCode();
        }

        public String toString() {
            return this.raw;
        }
    }

    private static class LocalizedIOException
    extends IOException {
        private static final long serialVersionUID = 0L;

        LocalizedIOException(String key, Object val) {
            super(JarWrapper.localize(key, val));
        }

        LocalizedIOException(String key, Object[] vals) {
            super(JarWrapper.localize(key, vals));
        }
    }

    private static class LocalizedIllegalArgumentException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 0L;

        LocalizedIllegalArgumentException(String key, Object val) {
            super(JarWrapper.localize(key, val));
        }

        LocalizedIllegalArgumentException(LocalizedIOException cause) {
            super(cause.getMessage());
            this.initCause(cause);
        }
    }
}

