/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool.envcheck;

import com.sun.jini.tool.envcheck.EnvCheck;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class Util {
    private static final HashMap resourceMap = new HashMap();
    private static ResourceBundle bundle = Util.getResourceBundle(EnvCheck.class);
    private static Properties nonStandardProperties = null;

    public static String checkFileName(String name, String desc) {
        File file = new File(name);
        String canonicalPath = null;
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (Exception e) {
            return Util.getString("util.cantresolve", bundle, desc, name);
        }
        if (!file.exists()) {
            return Util.getString("util.notexist", bundle, desc, canonicalPath);
        }
        if (file.isDirectory()) {
            return Util.getString("util.isdir", bundle, desc, canonicalPath);
        }
        if (!file.canRead()) {
            return Util.getString("util.cantread", bundle, desc, canonicalPath);
        }
        return null;
    }

    public static String checkURL(URL url, String desc) {
        if ("file".equals(url.getProtocol())) {
            String path = url.getFile().replace('/', File.separatorChar);
            return Util.checkFileName(path, desc);
        }
        try {
            url.openStream().close();
            return null;
        }
        catch (IOException e) {
            return Util.getString("util.cantreadURL", bundle, url.toString(), desc);
        }
    }

    public static String checkSystemPropertyFile(String prop, String desc) {
        String name = System.getProperty(prop);
        if (name == null) {
            return Util.getString("util.undef", bundle, desc);
        }
        return Util.checkFileName(name, desc);
    }

    public static ResourceBundle getResourceBundle(Class clazz) {
        if (resourceMap.containsKey(clazz)) {
            return (ResourceBundle)resourceMap.get(clazz);
        }
        String className = clazz.getName();
        int lastDot = className.lastIndexOf(".");
        if (lastDot < 0) {
            throw new IllegalStateException("Class is in default package");
        }
        String pkgName = className.substring(0, lastDot);
        String resourceName = className.substring(lastDot).toLowerCase();
        String bundleName = pkgName + ".resources" + resourceName;
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), clazz.getClassLoader());
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
        }
        resourceMap.put(clazz, bundle);
        return bundle;
    }

    private static String getFormat(String key, ResourceBundle bundle) {
        String fmt = "no text found: \"" + key + "\" {0}";
        if (bundle != null) {
            try {
                fmt = bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return fmt;
    }

    public static String getString(String key, ResourceBundle bundle) {
        return MessageFormat.format(Util.getFormat(key, bundle), null);
    }

    public static String getString(String key, ResourceBundle bundle, Object val) {
        return MessageFormat.format(Util.getFormat(key, bundle), val);
    }

    public static String getString(String key, ResourceBundle bundle, Object val1, Object val2) {
        return MessageFormat.format(Util.getFormat(key, bundle), val1, val2);
    }

    public static String getString(String key, ResourceBundle bundle, Object val1, Object val2, Object val3) {
        return MessageFormat.format(Util.getFormat(key, bundle), val1, val2, val3);
    }
}

