/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.out;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.broker.latency.BrokerFixedThreadPoolExecutor;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.common.DataVersion;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.namesrv.RegisterBrokerResult;
import org.apache.rocketmq.common.namesrv.TopAddressing;
import org.apache.rocketmq.common.protocol.body.ConsumerOffsetSerializeWrapper;
import org.apache.rocketmq.common.protocol.body.KVTable;
import org.apache.rocketmq.common.protocol.body.RegisterBrokerBody;
import org.apache.rocketmq.common.protocol.body.SubscriptionGroupWrapper;
import org.apache.rocketmq.common.protocol.body.TopicConfigSerializeWrapper;
import org.apache.rocketmq.common.protocol.header.namesrv.QueryDataVersionRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.QueryDataVersionResponseHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.RegisterBrokerRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.RegisterBrokerResponseHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.UnRegisterBrokerRequestHeader;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.RemotingClient;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyRemotingClient;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class BrokerOuterAPI {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private final RemotingClient remotingClient;
    private final TopAddressing topAddressing = new TopAddressing(MixAll.getWSAddr());
    private String nameSrvAddr = null;
    private BrokerFixedThreadPoolExecutor brokerOuterExecutor = new BrokerFixedThreadPoolExecutor(4, 10, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(32), (ThreadFactory)new ThreadFactoryImpl("brokerOutApi_thread_", true));

    public BrokerOuterAPI(NettyClientConfig nettyClientConfig) {
        this(nettyClientConfig, null);
    }

    public BrokerOuterAPI(NettyClientConfig nettyClientConfig, RPCHook rpcHook) {
        this.remotingClient = new NettyRemotingClient(nettyClientConfig);
        this.remotingClient.registerRPCHook(rpcHook);
    }

    public void start() {
        this.remotingClient.start();
    }

    public void shutdown() {
        this.remotingClient.shutdown();
        this.brokerOuterExecutor.shutdown();
    }

    public String fetchNameServerAddr() {
        try {
            String addrs = this.topAddressing.fetchNSAddr();
            if (addrs != null && !addrs.equals(this.nameSrvAddr)) {
                log.info("name server address changed, old: {} new: {}", (Object)this.nameSrvAddr, (Object)addrs);
                this.updateNameServerAddressList(addrs);
                this.nameSrvAddr = addrs;
                return this.nameSrvAddr;
            }
        }
        catch (Exception e) {
            log.error("fetchNameServerAddr Exception", (Throwable)e);
        }
        return this.nameSrvAddr;
    }

    public void updateNameServerAddressList(String addrs) {
        String[] addrArray;
        ArrayList<String> lst = new ArrayList<String>();
        for (String addr : addrArray = addrs.split(";")) {
            lst.add(addr);
        }
        this.remotingClient.updateNameServerAddressList(lst);
    }

    public List<RegisterBrokerResult> registerBrokerAll(String clusterName, String brokerAddr, String brokerName, long brokerId, String haServerAddr, TopicConfigSerializeWrapper topicConfigWrapper, List<String> filterServerList, boolean oneway, int timeoutMills, boolean compressed) {
        CopyOnWriteArrayList<RegisterBrokerResult> registerBrokerResultList = new CopyOnWriteArrayList<RegisterBrokerResult>();
        List nameServerAddressList = this.remotingClient.getNameServerAddressList();
        if (nameServerAddressList != null && nameServerAddressList.size() > 0) {
            RegisterBrokerRequestHeader requestHeader = new RegisterBrokerRequestHeader();
            requestHeader.setBrokerAddr(brokerAddr);
            requestHeader.setBrokerId(Long.valueOf(brokerId));
            requestHeader.setBrokerName(brokerName);
            requestHeader.setClusterName(clusterName);
            requestHeader.setHaServerAddr(haServerAddr);
            requestHeader.setCompressed(compressed);
            RegisterBrokerBody requestBody = new RegisterBrokerBody();
            requestBody.setTopicConfigSerializeWrapper(topicConfigWrapper);
            requestBody.setFilterServerList(filterServerList);
            byte[] body = requestBody.encode(compressed);
            int bodyCrc32 = UtilAll.crc32((byte[])body);
            requestHeader.setBodyCrc32(Integer.valueOf(bodyCrc32));
            CountDownLatch countDownLatch = new CountDownLatch(nameServerAddressList.size());
            for (String namesrvAddr : nameServerAddressList) {
                this.brokerOuterExecutor.execute(() -> {
                    try {
                        RegisterBrokerResult result = this.registerBroker(namesrvAddr, oneway, timeoutMills, requestHeader, body);
                        if (result != null) {
                            registerBrokerResultList.add(result);
                        }
                        log.info("register broker[{}]to name server {} OK", (Object)brokerId, (Object)namesrvAddr);
                    }
                    catch (Exception e) {
                        log.warn("registerBroker Exception, {}", (Object)namesrvAddr, (Object)e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
            }
            try {
                countDownLatch.await(timeoutMills, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return registerBrokerResultList;
    }

    private RegisterBrokerResult registerBroker(String namesrvAddr, boolean oneway, int timeoutMills, RegisterBrokerRequestHeader requestHeader, byte[] body) throws RemotingCommandException, MQBrokerException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)103, (CommandCustomHeader)requestHeader);
        request.setBody(body);
        if (oneway) {
            try {
                this.remotingClient.invokeOneway(namesrvAddr, request, (long)timeoutMills);
            }
            catch (RemotingTooMuchRequestException remotingTooMuchRequestException) {
                // empty catch block
            }
            return null;
        }
        RemotingCommand response = this.remotingClient.invokeSync(namesrvAddr, request, (long)timeoutMills);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                RegisterBrokerResponseHeader responseHeader = (RegisterBrokerResponseHeader)response.decodeCommandCustomHeader(RegisterBrokerResponseHeader.class);
                RegisterBrokerResult result = new RegisterBrokerResult();
                result.setMasterAddr(responseHeader.getMasterAddr());
                result.setHaServerAddr(responseHeader.getHaServerAddr());
                if (response.getBody() != null) {
                    result.setKvTable((KVTable)KVTable.decode((byte[])response.getBody(), KVTable.class));
                }
                return result;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), requestHeader == null ? null : requestHeader.getBrokerAddr());
    }

    public void unregisterBrokerAll(String clusterName, String brokerAddr, String brokerName, long brokerId) {
        List nameServerAddressList = this.remotingClient.getNameServerAddressList();
        if (nameServerAddressList != null) {
            for (String namesrvAddr : nameServerAddressList) {
                try {
                    this.unregisterBroker(namesrvAddr, clusterName, brokerAddr, brokerName, brokerId);
                    log.info("unregisterBroker OK, NamesrvAddr: {}", (Object)namesrvAddr);
                }
                catch (Exception e) {
                    log.warn("unregisterBroker Exception, {}", (Object)namesrvAddr, (Object)e);
                }
            }
        }
    }

    public void unregisterBroker(String namesrvAddr, String clusterName, String brokerAddr, String brokerName, long brokerId) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        UnRegisterBrokerRequestHeader requestHeader = new UnRegisterBrokerRequestHeader();
        requestHeader.setBrokerAddr(brokerAddr);
        requestHeader.setBrokerId(Long.valueOf(brokerId));
        requestHeader.setBrokerName(brokerName);
        requestHeader.setClusterName(clusterName);
        RemotingCommand request = RemotingCommand.createRequestCommand((int)104, (CommandCustomHeader)requestHeader);
        RemotingCommand response = this.remotingClient.invokeSync(namesrvAddr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return;
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), brokerAddr);
    }

    public List<Boolean> needRegister(String clusterName, String brokerAddr, String brokerName, long brokerId, TopicConfigSerializeWrapper topicConfigWrapper, int timeoutMills) {
        CopyOnWriteArrayList<Boolean> changedList = new CopyOnWriteArrayList<Boolean>();
        List nameServerAddressList = this.remotingClient.getNameServerAddressList();
        if (nameServerAddressList != null && nameServerAddressList.size() > 0) {
            CountDownLatch countDownLatch = new CountDownLatch(nameServerAddressList.size());
            for (String namesrvAddr : nameServerAddressList) {
                this.brokerOuterExecutor.execute(() -> {
                    try {
                        QueryDataVersionRequestHeader requestHeader = new QueryDataVersionRequestHeader();
                        requestHeader.setBrokerAddr(brokerAddr);
                        requestHeader.setBrokerId(Long.valueOf(brokerId));
                        requestHeader.setBrokerName(brokerName);
                        requestHeader.setClusterName(clusterName);
                        RemotingCommand request = RemotingCommand.createRequestCommand((int)322, (CommandCustomHeader)requestHeader);
                        request.setBody(topicConfigWrapper.getDataVersion().encode());
                        RemotingCommand response = this.remotingClient.invokeSync(namesrvAddr, request, (long)timeoutMills);
                        DataVersion nameServerDataVersion = null;
                        Boolean changed = false;
                        switch (response.getCode()) {
                            case 0: {
                                QueryDataVersionResponseHeader queryDataVersionResponseHeader = (QueryDataVersionResponseHeader)response.decodeCommandCustomHeader(QueryDataVersionResponseHeader.class);
                                changed = queryDataVersionResponseHeader.getChanged();
                                byte[] body = response.getBody();
                                if (body != null) {
                                    nameServerDataVersion = (DataVersion)DataVersion.decode((byte[])body, DataVersion.class);
                                    if (!topicConfigWrapper.getDataVersion().equals((Object)nameServerDataVersion)) {
                                        changed = true;
                                    }
                                }
                                if (changed != null && !changed.booleanValue()) break;
                                changedList.add(Boolean.TRUE);
                            }
                        }
                        log.warn("Query data version from name server {} OK,changed {}, broker {},name server {}", new Object[]{namesrvAddr, changed, topicConfigWrapper.getDataVersion(), nameServerDataVersion == null ? "" : nameServerDataVersion});
                    }
                    catch (Exception e) {
                        changedList.add(Boolean.TRUE);
                        log.error("Query data version from name server {}  Exception, {}", (Object)namesrvAddr, (Object)e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
            }
            try {
                countDownLatch.await(timeoutMills, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.error("query dataversion from nameserver countDownLatch await Exception", (Throwable)e);
            }
        }
        return changedList;
    }

    public TopicConfigSerializeWrapper getAllTopicConfig(String addr) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)21, null);
        RemotingCommand response = this.remotingClient.invokeSync(MixAll.brokerVIPChannel((boolean)true, (String)addr), request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (TopicConfigSerializeWrapper)TopicConfigSerializeWrapper.decode((byte[])response.getBody(), TopicConfigSerializeWrapper.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public ConsumerOffsetSerializeWrapper getAllConsumerOffset(String addr) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)43, null);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (ConsumerOffsetSerializeWrapper)ConsumerOffsetSerializeWrapper.decode((byte[])response.getBody(), ConsumerOffsetSerializeWrapper.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public String getAllDelayOffset(String addr) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException, UnsupportedEncodingException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)45, null);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return new String(response.getBody(), "UTF-8");
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public SubscriptionGroupWrapper getAllSubscriptionGroupConfig(String addr) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        RemotingCommand request = RemotingCommand.createRequestCommand((int)201, null);
        RemotingCommand response = this.remotingClient.invokeSync(addr, request, 3000L);
        assert (response != null);
        switch (response.getCode()) {
            case 0: {
                return (SubscriptionGroupWrapper)SubscriptionGroupWrapper.decode((byte[])response.getBody(), SubscriptionGroupWrapper.class);
            }
        }
        throw new MQBrokerException(response.getCode(), response.getRemark(), addr);
    }

    public void registerRPCHook(RPCHook rpcHook) {
        this.remotingClient.registerRPCHook(rpcHook);
    }
}

