/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spring.config;

import io.netty.util.internal.ConcurrentSet;
import java.util.Set;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.spring.config.TransactionHandler;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.beans.factory.DisposableBean;

public class TransactionHandlerRegistry
implements DisposableBean {
    private RocketMQTemplate rocketMQTemplate;
    private final Set<String> listenerContainers = new ConcurrentSet();

    public TransactionHandlerRegistry(RocketMQTemplate template) {
        this.rocketMQTemplate = template;
    }

    public void destroy() throws Exception {
        this.listenerContainers.clear();
    }

    public void registerTransactionHandler(TransactionHandler handler) throws MQClientException {
        if (this.listenerContainers.contains(handler.getName())) {
            throw new MQClientException(-1, String.format("The transaction name [%s] has been defined in TransactionListener [%s]", handler.getName(), handler.getBeanName()));
        }
        this.listenerContainers.add(handler.getName());
        this.rocketMQTemplate.createAndStartTransactionMQProducer(handler.getName(), handler.getListener(), handler.getCheckExecutor(), handler.getRpcHook());
    }
}

