/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logger$;
import org.apache.samza.config.Config;
import org.apache.samza.container.SamzaContainerContext;
import org.apache.samza.storage.kv.LevelDbKeyValueStore;
import org.apache.samza.storage.kv.LevelDbKeyValueStoreMetrics;
import org.apache.samza.storage.kv.LevelDbKeyValueStoreMetrics$;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.Options;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;

public final class LevelDbKeyValueStore$ {
    public static final LevelDbKeyValueStore$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new LevelDbKeyValueStore$();
    }

    private Logger logger$lzycompute() {
        LevelDbKeyValueStore$ levelDbKeyValueStore$ = this;
        synchronized (levelDbKeyValueStore$) {
            if (!this.bitmap$0) {
                this.logger = Logger$.MODULE$.apply(LevelDbKeyValueStore.class);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    private Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Options options(Config storeConfig, SamzaContainerContext containerContext) {
        CompressionType compressionType;
        String string;
        long cacheSize = storeConfig.getLong("container.cache.size.bytes", 0x6400000L);
        long writeBufSize = storeConfig.getLong("container.write.buffer.size.bytes", 0x2000000L);
        Options options2 = new Options();
        options2.cacheSize(cacheSize / (long)containerContext.partitions.size());
        options2.writeBufferSize((int)(writeBufSize / (long)containerContext.partitions.size()));
        options2.blockSize(storeConfig.getInt("leveldb.block.size.bytes", 4096));
        String string2 = string = storeConfig.get("leveldb.compression", "snappy");
        if (!("snappy" != null ? !"snappy".equals(string2) : string2 != null)) {
            compressionType = CompressionType.SNAPPY;
        } else {
            String string3 = string;
            if (!("none" != null ? !"none".equals(string3) : string3 != null)) {
                compressionType = CompressionType.NONE;
            } else {
                this.logger().warn((Function0)new Serializable(storeConfig){
                    public static final long serialVersionUID = 0L;
                    private final Config storeConfig$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Unknown leveldb.compression codec %s, defaulting to Snappy")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.storeConfig$1.get("leveldb.compression", "snappy")}));
                    }
                    {
                        this.storeConfig$1 = storeConfig$1;
                    }
                });
                compressionType = CompressionType.SNAPPY;
            }
        }
        options2.compressionType(compressionType);
        options2.createIfMissing(true);
        options2.errorIfExists(true);
        return options2;
    }

    public int $lessinit$greater$default$3() {
        return -1;
    }

    public LevelDbKeyValueStoreMetrics $lessinit$greater$default$4() {
        return new LevelDbKeyValueStoreMetrics(LevelDbKeyValueStoreMetrics$.MODULE$.$lessinit$greater$default$1(), LevelDbKeyValueStoreMetrics$.MODULE$.$lessinit$greater$default$2());
    }

    private LevelDbKeyValueStore$() {
        MODULE$ = this;
    }
}

