/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.FieldSelector;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.JsonSerialization;
import io.debezium.connector.mongodb.MongoDbCollectionSchema;
import io.debezium.data.Envelope;
import io.debezium.data.Json;
import io.debezium.pipeline.txmetadata.TransactionMonitor;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MongoDbSchema
implements DatabaseSchema<CollectionId> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbSchema.class);
    private final Filters filters;
    private final TopicSelector<CollectionId> topicSelector;
    private final Schema sourceSchema;
    private final SchemaNameAdjuster adjuster = SchemaNameAdjuster.create();
    private final ConcurrentMap<CollectionId, MongoDbCollectionSchema> collections = new ConcurrentHashMap<CollectionId, MongoDbCollectionSchema>();
    private final JsonSerialization serialization = new JsonSerialization();

    public MongoDbSchema(Filters filters, TopicSelector<CollectionId> topicSelector, Schema sourceSchema) {
        this.filters = filters;
        this.topicSelector = topicSelector;
        this.sourceSchema = sourceSchema;
    }

    @Override
    public void close() {
    }

    @Override
    public DataCollectionSchema schemaFor(CollectionId collectionId) {
        return this.collections.computeIfAbsent(collectionId, id -> {
            FieldSelector.FieldFilter fieldFilter = this.filters.fieldFilterFor((CollectionId)id);
            String topicName = this.topicSelector.topicNameFor((CollectionId)id);
            Schema keySchema = SchemaBuilder.struct().name(this.adjuster.adjust(topicName + ".Key")).field("id", Schema.STRING_SCHEMA).build();
            Schema valueSchema = SchemaBuilder.struct().name(this.adjuster.adjust(Envelope.schemaName(topicName))).field("after", Json.builder().optional().build()).field("patch", Json.builder().optional().build()).field("filter", Json.builder().optional().build()).field("source", this.sourceSchema).field("op", Schema.OPTIONAL_STRING_SCHEMA).field("ts_ms", Schema.OPTIONAL_INT64_SCHEMA).field("transaction", TransactionMonitor.TRANSACTION_BLOCK_SCHEMA).build();
            Envelope envelope = Envelope.fromSchema(valueSchema);
            return new MongoDbCollectionSchema((CollectionId)id, fieldFilter, keySchema, this.serialization::getDocumentId, envelope, valueSchema, this.serialization::getDocumentValue);
        });
    }

    @Override
    public boolean tableInformationComplete() {
        return false;
    }

    @Override
    public void assureNonEmptySchema() {
        if (this.collections.isEmpty()) {
            LOGGER.warn("After applying the include/exclude list filters, no changes will be captured. Please check your configuration!");
        }
    }
}

