/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigTransformer;
import org.apache.kafka.common.config.ConfigTransformerResult;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.runtime.ConnectorConfig;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.HerderRequest;
import org.apache.kafka.connect.runtime.Worker;
import org.apache.kafka.connect.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerConfigTransformer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(WorkerConfigTransformer.class);
    private final Worker worker;
    private final ConfigTransformer configTransformer;
    private final ConcurrentMap<String, Map<String, HerderRequest>> requests = new ConcurrentHashMap<String, Map<String, HerderRequest>>();
    private final Map<String, ConfigProvider> configProviders;

    public WorkerConfigTransformer(Worker worker, Map<String, ConfigProvider> configProviders) {
        this.worker = worker;
        this.configProviders = configProviders;
        this.configTransformer = new ConfigTransformer(configProviders);
    }

    public Map<String, String> transform(Map<String, String> configs) {
        return this.transform(null, configs);
    }

    public Map<String, String> transform(String connectorName, Map<String, String> configs) {
        if (configs == null) {
            return null;
        }
        ConfigTransformerResult result = this.configTransformer.transform(configs);
        if (connectorName != null) {
            Herder.ConfigReloadAction reloadAction;
            String key = "config.action.reload";
            String action = (String)ConfigDef.parseType(key, configs.get(key), ConfigDef.Type.STRING);
            if (action == null) {
                action = ConnectorConfig.CONFIG_RELOAD_ACTION_RESTART;
            }
            if ((reloadAction = Herder.ConfigReloadAction.valueOf(action.toUpperCase(Locale.ROOT))) == Herder.ConfigReloadAction.RESTART) {
                this.scheduleReload(connectorName, result.ttls());
            }
        }
        return result.data();
    }

    private void scheduleReload(String connectorName, Map<String, Long> ttls) {
        for (Map.Entry<String, Long> entry : ttls.entrySet()) {
            this.scheduleReload(connectorName, entry.getKey(), entry.getValue());
        }
    }

    private void scheduleReload(String connectorName, String path, long ttl) {
        ConcurrentHashMap<String, HerderRequest> connectorRequests = (ConcurrentHashMap<String, HerderRequest>)this.requests.get(connectorName);
        if (connectorRequests == null) {
            connectorRequests = new ConcurrentHashMap<String, HerderRequest>();
            this.requests.put(connectorName, connectorRequests);
        } else {
            HerderRequest previousRequest = (HerderRequest)connectorRequests.get(path);
            if (previousRequest != null) {
                previousRequest.cancel();
            }
        }
        log.info("Scheduling a restart of connector {} in {} ms", (Object)connectorName, (Object)ttl);
        Callback<Void> cb = new Callback<Void>(){

            @Override
            public void onCompletion(Throwable error, Void result) {
                if (error != null) {
                    log.error("Unexpected error during connector restart: ", error);
                }
            }
        };
        HerderRequest request = this.worker.herder().restartConnector(ttl, connectorName, cb);
        connectorRequests.put(path, request);
    }

    @Override
    public void close() {
        this.configProviders.values().forEach(x -> Utils.closeQuietly(x, "config provider"));
    }
}

