/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.cdc.base.source.reader.external;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.relational.TableId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.seatunnel.common.utils.SeaTunnelException;
import org.apache.seatunnel.connectors.cdc.base.schema.SchemaChangeResolver;
import org.apache.seatunnel.connectors.cdc.base.source.offset.Offset;
import org.apache.seatunnel.connectors.cdc.base.source.reader.external.FetchTask;
import org.apache.seatunnel.connectors.cdc.base.source.reader.external.Fetcher;
import org.apache.seatunnel.connectors.cdc.base.source.split.CompletedSnapshotSplitInfo;
import org.apache.seatunnel.connectors.cdc.base.source.split.IncrementalSplit;
import org.apache.seatunnel.connectors.cdc.base.source.split.SourceRecords;
import org.apache.seatunnel.connectors.cdc.base.source.split.SourceSplitBase;
import org.apache.seatunnel.connectors.cdc.base.source.split.wartermark.WatermarkEvent;
import org.apache.seatunnel.connectors.cdc.base.utils.SourceRecordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalSourceStreamFetcher
implements Fetcher<SourceRecords, SourceSplitBase> {
    private static final Logger log = LoggerFactory.getLogger(IncrementalSourceStreamFetcher.class);
    private final FetchTask.Context taskContext;
    private final SchemaChangeResolver schemaChangeResolver;
    private final ExecutorService executorService;
    private final Set<TableId> pureBinlogPhaseTables;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile Throwable readException;
    private FetchTask<SourceSplitBase> streamFetchTask;
    private IncrementalSplit currentIncrementalSplit;
    private Offset splitStartWatermark;
    private Map<TableId, Offset> maxSplitHighWatermarkMap;
    private Map<TableId, List<CompletedSnapshotSplitInfo>> finishedSplitsInfo;
    private static final long READER_CLOSE_TIMEOUT_SECONDS = 30L;

    public IncrementalSourceStreamFetcher(FetchTask.Context taskContext, int subTaskId, SchemaChangeResolver schemaChangeResolver) {
        this.taskContext = taskContext;
        this.schemaChangeResolver = schemaChangeResolver;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("debezium-reader-" + subTaskId).build();
        this.executorService = Executors.newSingleThreadExecutor(threadFactory);
        this.pureBinlogPhaseTables = new HashSet<TableId>();
    }

    @Override
    public void submitTask(FetchTask<SourceSplitBase> fetchTask) {
        this.streamFetchTask = fetchTask;
        this.currentIncrementalSplit = fetchTask.getSplit().asIncrementalSplit();
        this.configureFilter();
        this.taskContext.configure(this.currentIncrementalSplit);
        this.queue = this.taskContext.getQueue();
        this.executorService.submit(() -> {
            try {
                this.streamFetchTask.execute(this.taskContext);
            }
            catch (Exception e) {
                log.error(String.format("Execute stream read task for incremental split %s fail", this.currentIncrementalSplit), (Throwable)e);
                this.readException = e;
            }
        });
    }

    @Override
    public boolean isFinished() {
        return this.currentIncrementalSplit == null || !this.streamFetchTask.isRunning();
    }

    @Override
    public Iterator<SourceRecords> pollSplitRecords() throws InterruptedException, SeaTunnelException {
        List<DataChangeEvent> batch;
        this.checkReadException();
        Iterator<SourceRecords> sourceRecordsIterator = Collections.emptyIterator();
        if (this.streamFetchTask.isRunning() && !(batch = this.queue.poll()).isEmpty()) {
            sourceRecordsIterator = this.schemaChangeResolver != null ? this.splitSchemaChangeStream(batch) : this.splitNormalStream(batch);
        }
        return sourceRecordsIterator;
    }

    private Iterator<SourceRecords> splitNormalStream(List<DataChangeEvent> batchEvents) {
        ArrayList<SourceRecord> sourceRecords = new ArrayList<SourceRecord>();
        if (this.streamFetchTask.isRunning()) {
            for (DataChangeEvent event : batchEvents) {
                if (!this.shouldEmit(event.getRecord())) continue;
                sourceRecords.add(event.getRecord());
            }
        }
        ArrayList<SourceRecords> sourceRecordsSet = new ArrayList<SourceRecords>();
        sourceRecordsSet.add(new SourceRecords(sourceRecords));
        return sourceRecordsSet.iterator();
    }

    private Iterator<SourceRecords> splitSchemaChangeStream(List<DataChangeEvent> batchEvents) {
        ArrayList<SourceRecords> sourceRecordsSet = new ArrayList<SourceRecords>();
        ArrayList<SourceRecord> sourceRecordList = new ArrayList<SourceRecord>();
        SourceRecord previousRecord = null;
        for (int i = 0; i < batchEvents.size(); ++i) {
            DataChangeEvent event = batchEvents.get(i);
            SourceRecord currentRecord = event.getRecord();
            if (!this.shouldEmit(currentRecord)) continue;
            if (!SourceRecordUtils.isDataChangeRecord(currentRecord) && !SourceRecordUtils.isSchemaChangeEvent(currentRecord)) {
                sourceRecordList.add(currentRecord);
                continue;
            }
            if (SourceRecordUtils.isSchemaChangeEvent(currentRecord)) {
                if (!this.schemaChangeResolver.support(currentRecord)) continue;
                if (previousRecord == null) {
                    sourceRecordList.add(WatermarkEvent.createSchemaChangeBeforeWatermark(currentRecord));
                    sourceRecordsSet.add(new SourceRecords(sourceRecordList));
                    sourceRecordList = new ArrayList();
                    sourceRecordList.add(currentRecord);
                } else if (SourceRecordUtils.isSchemaChangeEvent(previousRecord)) {
                    sourceRecordList.add(currentRecord);
                } else {
                    sourceRecordList.add(WatermarkEvent.createSchemaChangeBeforeWatermark(currentRecord));
                    sourceRecordsSet.add(new SourceRecords(sourceRecordList));
                    sourceRecordList = new ArrayList();
                    sourceRecordList.add(currentRecord);
                }
            } else if (SourceRecordUtils.isDataChangeRecord(currentRecord)) {
                if (previousRecord == null || SourceRecordUtils.isDataChangeRecord(previousRecord)) {
                    sourceRecordList.add(currentRecord);
                } else {
                    sourceRecordList.add(WatermarkEvent.createSchemaChangeAfterWatermark(currentRecord));
                    sourceRecordsSet.add(new SourceRecords(sourceRecordList));
                    sourceRecordList = new ArrayList();
                    sourceRecordList.add(currentRecord);
                }
            }
            previousRecord = currentRecord;
            if (i != batchEvents.size() - 1) continue;
            if (SourceRecordUtils.isSchemaChangeEvent(currentRecord)) {
                sourceRecordList.add(WatermarkEvent.createSchemaChangeAfterWatermark(currentRecord));
            }
            sourceRecordsSet.add(new SourceRecords(sourceRecordList));
        }
        if (sourceRecordsSet.size() > 1) {
            log.debug("Split events stream into {} batches and mark schema checkpoint before/after", (Object)sourceRecordsSet.size());
        }
        return sourceRecordsSet.iterator();
    }

    private void checkReadException() {
        if (this.readException != null) {
            throw new SeaTunnelException(String.format("Read split %s error due to %s.", this.currentIncrementalSplit, this.readException.getMessage()), this.readException);
        }
    }

    @Override
    public void close() {
        try {
            if (this.taskContext != null) {
                this.taskContext.close();
            }
            if (this.streamFetchTask != null) {
                this.streamFetchTask.shutdown();
            }
            if (this.executorService != null) {
                this.executorService.shutdown();
                if (!this.executorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                    log.warn("Failed to close the stream fetcher in {} seconds. Service will execute force close(ExecutorService.shutdownNow)", (Object)30L);
                    this.executorService.shutdownNow();
                }
            }
        }
        catch (Exception e) {
            log.error("Close stream fetcher error", (Throwable)e);
        }
    }

    private boolean shouldEmit(SourceRecord sourceRecord) {
        if (this.taskContext.isDataChangeRecord(sourceRecord)) {
            Offset position = this.taskContext.getStreamOffset(sourceRecord);
            TableId tableId = SourceRecordUtils.getTableId(sourceRecord);
            if (!this.taskContext.isExactlyOnce()) {
                log.trace("The table {} is not support exactly-once, so ignore the watermark check", (Object)tableId);
                return position.isAfter(this.splitStartWatermark);
            }
            if (this.hasEnterPureBinlogPhase(tableId, position)) {
                return true;
            }
            if (this.finishedSplitsInfo.containsKey(tableId)) {
                for (CompletedSnapshotSplitInfo splitInfo : this.finishedSplitsInfo.get(tableId)) {
                    if (!this.taskContext.isRecordBetween(sourceRecord, splitInfo.getSplitStart(), splitInfo.getSplitEnd()) || !position.isAfter(splitInfo.getWatermark().getHighWatermark())) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean hasEnterPureBinlogPhase(TableId tableId, Offset position) {
        if (this.pureBinlogPhaseTables.contains(tableId)) {
            return true;
        }
        if (this.maxSplitHighWatermarkMap.containsKey(tableId) && position.isAtOrAfter(this.maxSplitHighWatermarkMap.get(tableId))) {
            this.pureBinlogPhaseTables.add(tableId);
            return true;
        }
        return false;
    }

    private void configureFilter() {
        this.splitStartWatermark = this.currentIncrementalSplit.getStartupOffset();
        HashMap<TableId, List<CompletedSnapshotSplitInfo>> splitsInfoMap = new HashMap<TableId, List<CompletedSnapshotSplitInfo>>();
        HashMap<TableId, Offset> tableIdBinlogPositionMap = new HashMap<TableId, Offset>();
        List<CompletedSnapshotSplitInfo> completedSnapshotSplitInfos = this.currentIncrementalSplit.getCompletedSnapshotSplitInfos();
        if (completedSnapshotSplitInfos.isEmpty()) {
            for (TableId tableId : this.currentIncrementalSplit.getTableIds()) {
                tableIdBinlogPositionMap.put(tableId, this.currentIncrementalSplit.getStartupOffset());
            }
        }
        for (CompletedSnapshotSplitInfo finishedSplitInfo : completedSnapshotSplitInfos) {
            TableId tableId = finishedSplitInfo.getTableId();
            List list = splitsInfoMap.getOrDefault(tableId, new ArrayList());
            list.add(finishedSplitInfo);
            splitsInfoMap.put(tableId, list);
            Offset highWatermark = finishedSplitInfo.getWatermark().getHighWatermark();
            Offset maxHighWatermark = (Offset)tableIdBinlogPositionMap.get(tableId);
            if (maxHighWatermark != null && !highWatermark.isAfter(maxHighWatermark)) continue;
            tableIdBinlogPositionMap.put(tableId, highWatermark);
        }
        this.finishedSplitsInfo = splitsInfoMap;
        this.maxSplitHighWatermarkMap = tableIdBinlogPositionMap;
        this.pureBinlogPhaseTables.clear();
    }
}

