/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mongodb;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceSplit;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.connector.TableSource;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactoryContext;
import org.apache.seatunnel.api.table.type.MultipleRowType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.MongodbIncrementalSource;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.config.MongodbSourceOptions;

@AutoService(value={Factory.class})
public class MongodbIncrementalSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return "MongoDB-CDC";
    }

    public OptionRule optionRule() {
        return MongodbSourceOptions.getBaseRule().required(new Option[]{MongodbSourceOptions.HOSTS, MongodbSourceOptions.DATABASE, MongodbSourceOptions.COLLECTION}).optional(new Option[]{MongodbSourceOptions.USERNAME, MongodbSourceOptions.PASSWORD, MongodbSourceOptions.CONNECTION_OPTIONS, MongodbSourceOptions.BATCH_SIZE, MongodbSourceOptions.POLL_MAX_BATCH_SIZE, MongodbSourceOptions.POLL_AWAIT_TIME_MILLIS, MongodbSourceOptions.HEARTBEAT_INTERVAL_MILLIS, MongodbSourceOptions.INCREMENTAL_SNAPSHOT_CHUNK_SIZE_MB, MongodbSourceOptions.STARTUP_MODE, MongodbSourceOptions.STOP_MODE}).build();
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return MongodbIncrementalSource.class;
    }

    public <T, SplitT extends SourceSplit, StateT extends Serializable> TableSource<T, SplitT, StateT> createSource(TableSourceFactoryContext context) {
        return () -> {
            List catalogTables = CatalogTableUtil.getCatalogTables((ReadonlyConfig)context.getOptions(), (ClassLoader)context.getClassLoader());
            MultipleRowType dataType = CatalogTableUtil.convertToMultipleRowType((List)catalogTables);
            return new MongodbIncrementalSource(context.getOptions(), (SeaTunnelDataType<SeaTunnelRow>)dataType, catalogTables);
        };
    }
}

