/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.splitters;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Aggregates;
import io.debezium.relational.TableId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.cdc.base.source.split.SnapshotSplit;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.splitters.SingleSplitStrategy;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.splitters.SplitContext;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.source.splitters.SplitStrategy;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.utils.ChunkUtils;
import org.apache.seatunnel.connectors.seatunnel.cdc.mongodb.utils.MongodbUtils;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public enum SampleBucketSplitStrategy implements SplitStrategy
{
    INSTANCE;

    private static final int DEFAULT_SAMPLING_THRESHOLD = 102400;
    private static final double DEFAULT_SAMPLING_RATE = 0.05;

    @Override
    @Nonnull
    public Collection<SnapshotSplit> split(@Nonnull SplitContext splitContext) {
        long chunkSizeInBytes = (long)splitContext.getChunkSizeMB() * 1024L * 1024L;
        long sizeInBytes = splitContext.getSizeInBytes();
        long count = splitContext.getDocumentCount();
        if (sizeInBytes < chunkSizeInBytes) {
            return SingleSplitStrategy.INSTANCE.split(splitContext);
        }
        int numChunks = (int)(sizeInBytes / chunkSizeInBytes) + 1;
        int numberOfSamples = count < 102400L ? (int)count : (int)Math.floor((double)count * 0.05);
        TableId collectionId = splitContext.getCollectionId();
        MongoCollection<BsonDocument> collection = MongodbUtils.getMongoCollection(splitContext.getMongoClient(), collectionId, BsonDocument.class);
        ArrayList<Bson> pipeline = new ArrayList<Bson>();
        if ((long)numberOfSamples != count) {
            pipeline.add(Aggregates.sample(numberOfSamples));
        }
        pipeline.add(Aggregates.bucketAuto("$_id", numChunks));
        List chunks = collection.aggregate(pipeline).allowDiskUse(true).into(new ArrayList());
        SeaTunnelRowType rowType = this.shardKeysToRowType(Collections.singleton("_id"));
        ArrayList<SnapshotSplit> snapshotSplits = new ArrayList<SnapshotSplit>(chunks.size() + 2);
        SnapshotSplit firstSplit = new SnapshotSplit(this.splitId(collectionId, 0), collectionId, rowType, ChunkUtils.minLowerBoundOfId(), ChunkUtils.boundOfId(this.lowerBoundOfBucket((BsonDocument)chunks.get(0))));
        snapshotSplits.add(firstSplit);
        for (int i = 0; i < chunks.size(); ++i) {
            BsonDocument bucket = (BsonDocument)chunks.get(i);
            snapshotSplits.add(new SnapshotSplit(this.splitId(collectionId, i + 1), collectionId, rowType, ChunkUtils.boundOfId(this.lowerBoundOfBucket(bucket)), ChunkUtils.boundOfId(this.upperBoundOfBucket(bucket))));
        }
        SnapshotSplit lastSplit = new SnapshotSplit(this.splitId(collectionId, chunks.size() + 1), collectionId, rowType, ChunkUtils.boundOfId(this.upperBoundOfBucket((BsonDocument)chunks.get(chunks.size() - 1))), ChunkUtils.maxUpperBoundOfId());
        snapshotSplits.add(lastSplit);
        return snapshotSplits;
    }

    private BsonDocument bucketBounds(@Nonnull BsonDocument bucket) {
        return bucket.getDocument("_id");
    }

    private BsonValue lowerBoundOfBucket(BsonDocument bucket) {
        return this.bucketBounds(bucket).get("min");
    }

    private BsonValue upperBoundOfBucket(BsonDocument bucket) {
        return this.bucketBounds(bucket).get("max");
    }
}

