/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.common.multitablesink;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTableWriterRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MultiTableWriterRunnable.class);
    private final Map<String, SinkWriter<SeaTunnelRow, ?, ?>> tableIdWriterMap;
    private final BlockingQueue<SeaTunnelRow> queue;
    private volatile Throwable throwable;

    public MultiTableWriterRunnable(Map<String, SinkWriter<SeaTunnelRow, ?, ?>> tableIdWriterMap, BlockingQueue<SeaTunnelRow> queue) {
        this.tableIdWriterMap = tableIdWriterMap;
        this.queue = queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                SeaTunnelRow row;
                if ((row = this.queue.poll(100L, TimeUnit.MILLISECONDS)) == null) {
                    continue;
                }
                SinkWriter<SeaTunnelRow, ?, ?> writer = this.tableIdWriterMap.get(row.getTableId());
                if (writer == null) {
                    if (this.tableIdWriterMap.size() != 1) throw new RuntimeException("MultiTableWriterRunnable can't find writer for tableId: " + row.getTableId());
                    writer = this.tableIdWriterMap.values().stream().findFirst().get();
                }
                MultiTableWriterRunnable multiTableWriterRunnable = this;
                synchronized (multiTableWriterRunnable) {
                    writer.write((Object)row);
                }
            }
        }
        catch (InterruptedException e) {
            this.throwable = e;
            return;
        }
        catch (Exception e) {
            log.error("MultiTableWriterRunnable error", (Throwable)e);
            this.throwable = e;
            return;
        }
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

