/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.index;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.streaming.connectors.elasticsearch.index.AbstractTimeIndexGenerator;
import org.apache.flink.streaming.connectors.elasticsearch.index.IndexGenerator;
import org.apache.flink.streaming.connectors.elasticsearch.index.IndexGeneratorBase;
import org.apache.flink.streaming.connectors.elasticsearch.index.StaticIndexGenerator;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;

@Internal
public class IndexGeneratorFactory {
    private IndexGeneratorFactory() {
    }

    public static IndexGenerator createIndexGenerator(String index, TableSchema schema) {
        IndexHelper indexHelper = new IndexHelper();
        if (indexHelper.checkIsDynamicIndex(index)) {
            return IndexGeneratorFactory.createRuntimeIndexGenerator(index, schema.getFieldNames(), schema.getFieldDataTypes(), indexHelper);
        }
        return new StaticIndexGenerator(index);
    }

    private static IndexGenerator createRuntimeIndexGenerator(String index, String[] fieldNames, DataType[] fieldTypes, IndexHelper indexHelper) {
        String dynamicIndexPatternStr = indexHelper.extractDynamicIndexPatternStr(index);
        final String indexPrefix = index.substring(0, index.indexOf(dynamicIndexPatternStr));
        final String indexSuffix = index.substring(indexPrefix.length() + dynamicIndexPatternStr.length());
        boolean isDynamicIndexWithFormat = indexHelper.checkIsDynamicIndexWithFormat(index);
        final int indexFieldPos = indexHelper.extractIndexFieldPos(index, fieldNames, isDynamicIndexWithFormat);
        TypeInformation indexFieldType = TypeConversions.fromDataTypeToLegacyInfo((DataType)fieldTypes[indexFieldPos]);
        indexHelper.validateIndexFieldType(indexFieldType);
        if (isDynamicIndexWithFormat) {
            String dateTimeFormat = indexHelper.extractDateFormat(index, indexFieldType);
            if (indexFieldType == Types.LOCAL_DATE_TIME) {
                return new AbstractTimeIndexGenerator(index, dateTimeFormat){

                    @Override
                    public String generate(Row row) {
                        LocalDateTime indexField = (LocalDateTime)row.getField(indexFieldPos);
                        String indexFieldValueStr = indexField.format(this.dateTimeFormatter);
                        return indexPrefix.concat(indexFieldValueStr).concat(indexSuffix);
                    }
                };
            }
            if (indexFieldType == Types.SQL_TIMESTAMP) {
                return new AbstractTimeIndexGenerator(index, dateTimeFormat){

                    @Override
                    public String generate(Row row) {
                        Timestamp indexField = (Timestamp)row.getField(indexFieldPos);
                        String indexFieldValueStr = indexField.toLocalDateTime().format(this.dateTimeFormatter);
                        return indexPrefix.concat(indexFieldValueStr).concat(indexSuffix);
                    }
                };
            }
            if (indexFieldType == Types.LOCAL_DATE) {
                return new AbstractTimeIndexGenerator(index, dateTimeFormat){

                    @Override
                    public String generate(Row row) {
                        LocalDate indexField = (LocalDate)row.getField(indexFieldPos);
                        String indexFieldValueStr = indexField.format(this.dateTimeFormatter);
                        return indexPrefix.concat(indexFieldValueStr).concat(indexSuffix);
                    }
                };
            }
            if (indexFieldType == Types.SQL_DATE) {
                return new AbstractTimeIndexGenerator(index, dateTimeFormat){

                    @Override
                    public String generate(Row row) {
                        Date indexField = (Date)row.getField(indexFieldPos);
                        String indexFieldValueStr = indexField.toLocalDate().format(this.dateTimeFormatter);
                        return indexPrefix.concat(indexFieldValueStr).concat(indexSuffix);
                    }
                };
            }
            if (indexFieldType == Types.LOCAL_TIME) {
                return new AbstractTimeIndexGenerator(index, dateTimeFormat){

                    @Override
                    public String generate(Row row) {
                        LocalTime indexField = (LocalTime)row.getField(indexFieldPos);
                        String indexFieldValueStr = indexField.format(this.dateTimeFormatter);
                        return indexPrefix.concat(indexFieldValueStr).concat(indexSuffix);
                    }
                };
            }
            if (indexFieldType == Types.SQL_TIME) {
                return new AbstractTimeIndexGenerator(index, dateTimeFormat){

                    @Override
                    public String generate(Row row) {
                        Time indexField = (Time)row.getField(indexFieldPos);
                        String indexFieldValueStr = indexField.toLocalTime().format(this.dateTimeFormatter);
                        return indexPrefix.concat(indexFieldValueStr).concat(indexSuffix);
                    }
                };
            }
            throw new TableException(String.format("Unsupported type '%s' found in Elasticsearch dynamic index field, time-related pattern only support types are: DATE,TIME,TIMESTAMP.", TypeConversions.fromLegacyInfoToDataType((TypeInformation)indexFieldType)));
        }
        return new IndexGeneratorBase(index){

            @Override
            public String generate(Row row) {
                Object indexField = row.getField(indexFieldPos);
                return indexPrefix.concat(indexField == null ? "null" : indexField.toString()).concat(indexSuffix);
            }
        };
    }

    private static class IndexHelper {
        private static final Pattern dynamicIndexPattern = Pattern.compile("\\{[^\\{\\}]+\\}?");
        private static final Pattern dynamicIndexTimeExtractPattern = Pattern.compile(".*\\{.+\\|.*\\}.*");
        private static final List<TypeInformation> supportedTypes = new ArrayList<TypeInformation>();
        private static final Map<TypeInformation, String> defaultFormats = new HashMap<TypeInformation, String>();

        private IndexHelper() {
        }

        void validateIndexFieldType(TypeInformation indexTypeInfo) {
            if (!supportedTypes.contains(indexTypeInfo)) {
                throw new IllegalArgumentException(String.format("Unsupported type %s of index field, Supported types are: %s", indexTypeInfo, supportedTypes));
            }
        }

        String getDefaultFormat(TypeInformation indexTypeInfo) {
            return defaultFormats.get(indexTypeInfo);
        }

        boolean checkIsDynamicIndex(String index) {
            Matcher matcher = dynamicIndexPattern.matcher(index);
            int count = 0;
            while (matcher.find()) {
                ++count;
            }
            if (count > 1) {
                throw new TableException(String.format("Chaining dynamic index pattern %s is not supported, only support single dynamic index pattern.", index));
            }
            return count == 1;
        }

        boolean checkIsDynamicIndexWithFormat(String index) {
            return dynamicIndexTimeExtractPattern.matcher(index).matches();
        }

        String extractDynamicIndexPatternStr(String index) {
            int start = index.indexOf("{");
            int end = index.lastIndexOf("}");
            return index.substring(start, end + 1);
        }

        int extractIndexFieldPos(String index, String[] fieldNames, boolean isDynamicIndexWithFormat) {
            String indexFieldName;
            List<String> fieldList = Arrays.asList(fieldNames);
            if (!fieldList.contains(indexFieldName = isDynamicIndexWithFormat ? index.substring(index.indexOf("{") + 1, index.indexOf("|")) : index.substring(index.indexOf("{") + 1, index.indexOf("}")))) {
                throw new TableException(String.format("Unknown field '%s' in index pattern '%s', please check the field name.", indexFieldName, index));
            }
            return fieldList.indexOf(indexFieldName);
        }

        private String extractDateFormat(String index, TypeInformation indexTypeInfo) {
            String format = index.substring(index.indexOf("|") + 1, index.indexOf("}"));
            if ("".equals(format)) {
                format = this.getDefaultFormat(indexTypeInfo);
            }
            return format;
        }

        static {
            supportedTypes.add(Types.LOCAL_DATE_TIME);
            supportedTypes.add(Types.SQL_TIMESTAMP);
            supportedTypes.add(Types.LOCAL_DATE);
            supportedTypes.add(Types.SQL_DATE);
            supportedTypes.add(Types.LOCAL_TIME);
            supportedTypes.add(Types.SQL_TIME);
            supportedTypes.add(Types.STRING);
            supportedTypes.add(Types.SHORT);
            supportedTypes.add(Types.INT);
            supportedTypes.add(Types.LONG);
            defaultFormats.put(Types.LOCAL_DATE_TIME, "yyyy_MM_dd_HH_mm_ss");
            defaultFormats.put(Types.SQL_TIMESTAMP, "yyyy_MM_dd_HH_mm_ss");
            defaultFormats.put(Types.LOCAL_DATE, "yyyy_MM_dd");
            defaultFormats.put(Types.SQL_DATE, "yyyy_MM_dd");
            defaultFormats.put(Types.LOCAL_TIME, "HH_mm_ss");
            defaultFormats.put(Types.SQL_TIME, "HH_mm_ss");
        }
    }
}

