/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.util.packed.PackedInts;

final class LongHashSet
extends AbstractSet<Long> {
    private static final long MISSING = Long.MIN_VALUE;
    final long[] table;
    final int mask;
    final boolean hasMissingValue;
    final int size;
    final int hashCode;

    LongHashSet(long ... values) {
        int tableSize = Math.toIntExact((long)values.length * 3L / 2L);
        tableSize = 1 << PackedInts.bitsRequired(tableSize);
        assert ((long)tableSize >= (long)values.length * 3L / 2L);
        this.table = new long[tableSize];
        Arrays.fill(this.table, Long.MIN_VALUE);
        this.mask = tableSize - 1;
        boolean hasMissingValue = false;
        int size = 0;
        int hashCode = 0;
        for (long value : values) {
            if (value != Long.MIN_VALUE && !this.add(value)) continue;
            if (value == Long.MIN_VALUE) {
                hasMissingValue = true;
            }
            ++size;
            hashCode += Long.hashCode(value);
        }
        this.hasMissingValue = hasMissingValue;
        this.size = size;
        this.hashCode = hashCode;
    }

    @Override
    private boolean add(long l) {
        int slot;
        assert (l != Long.MIN_VALUE);
        int i = slot = Long.hashCode(l) & this.mask;
        while (true) {
            if (this.table[i] == Long.MIN_VALUE) {
                this.table[i] = l;
                return true;
            }
            if (this.table[i] == l) {
                return false;
            }
            i = i + 1 & this.mask;
        }
    }

    boolean contains(long l) {
        int slot;
        if (l == Long.MIN_VALUE) {
            return this.hasMissingValue;
        }
        int i = slot = Long.hashCode(l) & this.mask;
        while (this.table[i] != Long.MIN_VALUE) {
            if (this.table[i] == l) {
                return true;
            }
            i = i + 1 & this.mask;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == LongHashSet.class) {
            LongHashSet that = (LongHashSet)obj;
            if (this.hashCode != that.hashCode || this.size != that.size || this.hasMissingValue != that.hasMissingValue) {
                return false;
            }
            for (long v : this.table) {
                if (v == Long.MIN_VALUE || that.contains(v)) continue;
                return false;
            }
            return true;
        }
        return super.equals(obj);
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof Long && this.contains((Long)o);
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){
            private boolean hasNext;
            private int i;
            private long value;
            {
                this.hasNext = LongHashSet.this.hasMissingValue;
                this.i = -1;
                this.value = Long.MIN_VALUE;
            }

            @Override
            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                while (++this.i < LongHashSet.this.table.length) {
                    this.value = LongHashSet.this.table[this.i];
                    if (this.value == Long.MIN_VALUE) continue;
                    this.hasNext = true;
                    return true;
                }
                return false;
            }

            @Override
            public Long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return this.value;
            }
        };
    }
}

