/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.rankeval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.rankeval.EvalQueryQuality;
import org.elasticsearch.index.rankeval.EvaluationMetric;
import org.elasticsearch.index.rankeval.RatedDocument;
import org.elasticsearch.index.rankeval.RatedSearchHit;
import org.elasticsearch.search.SearchHit;

public class DiscountedCumulativeGain
implements EvaluationMetric {
    private final boolean normalize;
    private static final int DEFAULT_K = 10;
    private final int k;
    private final Integer unknownDocRating;
    public static final String NAME = "dcg";
    private static final double LOG2 = Math.log(2.0);
    private static final ParseField K_FIELD = new ParseField("k", new String[0]);
    private static final ParseField NORMALIZE_FIELD = new ParseField("normalize", new String[0]);
    private static final ParseField UNKNOWN_DOC_RATING_FIELD = new ParseField("unknown_doc_rating", new String[0]);
    private static final ConstructingObjectParser<DiscountedCumulativeGain, Void> PARSER = new ConstructingObjectParser("dcg_at", false, args -> {
        Boolean normalized = (Boolean)args[0];
        Integer optK = (Integer)args[2];
        return new DiscountedCumulativeGain(normalized == null ? false : normalized, (Integer)args[1], optK == null ? 10 : optK);
    });

    public DiscountedCumulativeGain() {
        this(false, null, 10);
    }

    public DiscountedCumulativeGain(boolean normalize, Integer unknownDocRating, int k) {
        this.normalize = normalize;
        this.unknownDocRating = unknownDocRating;
        this.k = k;
    }

    DiscountedCumulativeGain(StreamInput in) throws IOException {
        this.normalize = in.readBoolean();
        this.unknownDocRating = in.readOptionalVInt();
        this.k = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.normalize);
        out.writeOptionalVInt(this.unknownDocRating);
        out.writeVInt(this.k);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    boolean getNormalize() {
        return this.normalize;
    }

    int getK() {
        return this.k;
    }

    public Integer getUnknownDocRating() {
        return this.unknownDocRating;
    }

    @Override
    public Optional<Integer> forcedSearchSize() {
        return Optional.of(this.k);
    }

    @Override
    public EvalQueryQuality evaluate(String taskId, SearchHit[] hits, List<RatedDocument> ratedDocs) {
        List allRatings = ratedDocs.stream().mapToInt(RatedDocument::getRating).boxed().collect(Collectors.toList());
        List<RatedSearchHit> ratedHits = EvaluationMetric.joinHitsWithRatings(hits, ratedDocs);
        ArrayList<Integer> ratingsInSearchHits = new ArrayList<Integer>(ratedHits.size());
        for (RatedSearchHit hit : ratedHits) {
            ratingsInSearchHits.add(hit.getRating().orElse(this.unknownDocRating));
        }
        double dcg = DiscountedCumulativeGain.computeDCG(ratingsInSearchHits);
        if (this.normalize) {
            Collections.sort(allRatings, Comparator.nullsLast(Collections.reverseOrder()));
            double idcg = DiscountedCumulativeGain.computeDCG(allRatings.subList(0, Math.min(ratingsInSearchHits.size(), allRatings.size())));
            dcg = idcg > 0.0 ? (dcg /= idcg) : 0.0;
        }
        EvalQueryQuality evalQueryQuality = new EvalQueryQuality(taskId, dcg);
        evalQueryQuality.addHitsAndRatings(ratedHits);
        return evalQueryQuality;
    }

    private static double computeDCG(List<Integer> ratings) {
        int rank = 1;
        double dcg = 0.0;
        for (Integer rating : ratings) {
            if (rating != null) {
                dcg += (Math.pow(2.0, rating.intValue()) - 1.0) / (Math.log(rank + 1) / LOG2);
            }
            ++rank;
        }
        return dcg;
    }

    public static DiscountedCumulativeGain fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(NAME);
        builder.field(NORMALIZE_FIELD.getPreferredName(), this.normalize);
        if (this.unknownDocRating != null) {
            builder.field(UNKNOWN_DOC_RATING_FIELD.getPreferredName(), this.unknownDocRating);
        }
        builder.field(K_FIELD.getPreferredName(), this.k);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DiscountedCumulativeGain other = (DiscountedCumulativeGain)obj;
        return Objects.equals(this.normalize, other.normalize) && Objects.equals(this.unknownDocRating, other.unknownDocRating) && Objects.equals(this.k, other.k);
    }

    public final int hashCode() {
        return Objects.hash(this.normalize, this.unknownDocRating, this.k);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), NORMALIZE_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), UNKNOWN_DOC_RATING_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), K_FIELD);
    }
}

