/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class IndexingStats
implements Streamable,
ToXContentFragment {
    private Stats totalStats;
    @Nullable
    private Map<String, Stats> typeStats;

    public IndexingStats() {
        this.totalStats = new Stats();
    }

    public IndexingStats(Stats totalStats, @Nullable Map<String, Stats> typeStats) {
        this.totalStats = totalStats;
        this.typeStats = typeStats;
    }

    public void add(IndexingStats indexingStats) {
        this.add(indexingStats, true);
    }

    public void add(IndexingStats indexingStats, boolean includeTypes) {
        if (indexingStats == null) {
            return;
        }
        this.addTotals(indexingStats);
        if (includeTypes && indexingStats.typeStats != null && !indexingStats.typeStats.isEmpty()) {
            if (this.typeStats == null) {
                this.typeStats = new HashMap<String, Stats>(indexingStats.typeStats.size());
            }
            for (Map.Entry<String, Stats> entry : indexingStats.typeStats.entrySet()) {
                Stats stats = this.typeStats.get(entry.getKey());
                if (stats == null) {
                    this.typeStats.put(entry.getKey(), entry.getValue());
                    continue;
                }
                stats.add(entry.getValue());
            }
        }
    }

    public void addTotals(IndexingStats indexingStats) {
        if (indexingStats == null) {
            return;
        }
        this.totalStats.add(indexingStats.totalStats);
    }

    public Stats getTotal() {
        return this.totalStats;
    }

    @Nullable
    public Map<String, Stats> getTypeStats() {
        return this.typeStats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("indexing");
        this.totalStats.toXContent(builder, params);
        if (this.typeStats != null && !this.typeStats.isEmpty()) {
            builder.startObject("types");
            for (Map.Entry<String, Stats> entry : this.typeStats.entrySet()) {
                builder.startObject(entry.getKey());
                entry.getValue().toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.totalStats = Stats.readStats(in);
        if (in.readBoolean()) {
            this.typeStats = in.readMap(StreamInput::readString, Stats::readStats);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.totalStats.writeTo(out);
        if (this.typeStats == null || this.typeStats.isEmpty()) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeMap(this.typeStats, StreamOutput::writeString, (stream, stats) -> stats.writeTo(stream));
        }
    }

    static final class Fields {
        static final String INDEXING = "indexing";
        static final String TYPES = "types";
        static final String INDEX_TOTAL = "index_total";
        static final String INDEX_TIME = "index_time";
        static final String INDEX_TIME_IN_MILLIS = "index_time_in_millis";
        static final String INDEX_CURRENT = "index_current";
        static final String INDEX_FAILED = "index_failed";
        static final String DELETE_TOTAL = "delete_total";
        static final String DELETE_TIME = "delete_time";
        static final String DELETE_TIME_IN_MILLIS = "delete_time_in_millis";
        static final String DELETE_CURRENT = "delete_current";
        static final String NOOP_UPDATE_TOTAL = "noop_update_total";
        static final String IS_THROTTLED = "is_throttled";
        static final String THROTTLED_TIME_IN_MILLIS = "throttle_time_in_millis";
        static final String THROTTLED_TIME = "throttle_time";

        Fields() {
        }
    }

    public static class Stats
    implements Streamable,
    ToXContentFragment {
        private long indexCount;
        private long indexTimeInMillis;
        private long indexCurrent;
        private long indexFailedCount;
        private long deleteCount;
        private long deleteTimeInMillis;
        private long deleteCurrent;
        private long noopUpdateCount;
        private long throttleTimeInMillis;
        private boolean isThrottled;

        Stats() {
        }

        public Stats(long indexCount, long indexTimeInMillis, long indexCurrent, long indexFailedCount, long deleteCount, long deleteTimeInMillis, long deleteCurrent, long noopUpdateCount, boolean isThrottled, long throttleTimeInMillis) {
            this.indexCount = indexCount;
            this.indexTimeInMillis = indexTimeInMillis;
            this.indexCurrent = indexCurrent;
            this.indexFailedCount = indexFailedCount;
            this.deleteCount = deleteCount;
            this.deleteTimeInMillis = deleteTimeInMillis;
            this.deleteCurrent = deleteCurrent;
            this.noopUpdateCount = noopUpdateCount;
            this.isThrottled = isThrottled;
            this.throttleTimeInMillis = throttleTimeInMillis;
        }

        public void add(Stats stats) {
            this.indexCount += stats.indexCount;
            this.indexTimeInMillis += stats.indexTimeInMillis;
            this.indexCurrent += stats.indexCurrent;
            this.indexFailedCount += stats.indexFailedCount;
            this.deleteCount += stats.deleteCount;
            this.deleteTimeInMillis += stats.deleteTimeInMillis;
            this.deleteCurrent += stats.deleteCurrent;
            this.noopUpdateCount += stats.noopUpdateCount;
            this.throttleTimeInMillis += stats.throttleTimeInMillis;
            if (this.isThrottled != stats.isThrottled) {
                this.isThrottled = true;
            }
        }

        public long getIndexCount() {
            return this.indexCount;
        }

        public long getIndexFailedCount() {
            return this.indexFailedCount;
        }

        public TimeValue getIndexTime() {
            return new TimeValue(this.indexTimeInMillis);
        }

        public long getIndexCurrent() {
            return this.indexCurrent;
        }

        public long getDeleteCount() {
            return this.deleteCount;
        }

        public boolean isThrottled() {
            return this.isThrottled;
        }

        public TimeValue getThrottleTime() {
            return new TimeValue(this.throttleTimeInMillis);
        }

        public TimeValue getDeleteTime() {
            return new TimeValue(this.deleteTimeInMillis);
        }

        public long getDeleteCurrent() {
            return this.deleteCurrent;
        }

        public long getNoopUpdateCount() {
            return this.noopUpdateCount;
        }

        public static Stats readStats(StreamInput in) throws IOException {
            Stats stats = new Stats();
            stats.readFrom(in);
            return stats;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.indexCount = in.readVLong();
            this.indexTimeInMillis = in.readVLong();
            this.indexCurrent = in.readVLong();
            this.indexFailedCount = in.readVLong();
            this.deleteCount = in.readVLong();
            this.deleteTimeInMillis = in.readVLong();
            this.deleteCurrent = in.readVLong();
            this.noopUpdateCount = in.readVLong();
            this.isThrottled = in.readBoolean();
            this.throttleTimeInMillis = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.indexCount);
            out.writeVLong(this.indexTimeInMillis);
            out.writeVLong(this.indexCurrent);
            out.writeVLong(this.indexFailedCount);
            out.writeVLong(this.deleteCount);
            out.writeVLong(this.deleteTimeInMillis);
            out.writeVLong(this.deleteCurrent);
            out.writeVLong(this.noopUpdateCount);
            out.writeBoolean(this.isThrottled);
            out.writeLong(this.throttleTimeInMillis);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("index_total", this.indexCount);
            builder.humanReadableField("index_time_in_millis", "index_time", this.getIndexTime());
            builder.field("index_current", this.indexCurrent);
            builder.field("index_failed", this.indexFailedCount);
            builder.field("delete_total", this.deleteCount);
            builder.humanReadableField("delete_time_in_millis", "delete_time", this.getDeleteTime());
            builder.field("delete_current", this.deleteCurrent);
            builder.field("noop_update_total", this.noopUpdateCount);
            builder.field("is_throttled", this.isThrottled);
            builder.humanReadableField("throttle_time_in_millis", "throttle_time", this.getThrottleTime());
            return builder;
        }
    }
}

