/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class IngestStats
implements Writeable,
ToXContentFragment {
    private final Stats totalStats;
    private final Map<String, Stats> statsPerPipeline;

    public IngestStats(Stats totalStats, Map<String, Stats> statsPerPipeline) {
        this.totalStats = totalStats;
        this.statsPerPipeline = statsPerPipeline;
    }

    public IngestStats(StreamInput in) throws IOException {
        this.totalStats = new Stats(in);
        int size = in.readVInt();
        this.statsPerPipeline = new HashMap<String, Stats>(size);
        for (int i = 0; i < size; ++i) {
            this.statsPerPipeline.put(in.readString(), new Stats(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.totalStats.writeTo(out);
        out.writeVInt(this.statsPerPipeline.size());
        for (Map.Entry<String, Stats> entry : this.statsPerPipeline.entrySet()) {
            out.writeString(entry.getKey());
            entry.getValue().writeTo(out);
        }
    }

    public Stats getTotalStats() {
        return this.totalStats;
    }

    public Map<String, Stats> getStatsPerPipeline() {
        return this.statsPerPipeline;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("ingest");
        builder.startObject("total");
        this.totalStats.toXContent(builder, params);
        builder.endObject();
        builder.startObject("pipelines");
        for (Map.Entry<String, Stats> entry : this.statsPerPipeline.entrySet()) {
            builder.startObject(entry.getKey());
            entry.getValue().toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static class Stats
    implements Writeable,
    ToXContentFragment {
        private final long ingestCount;
        private final long ingestTimeInMillis;
        private final long ingestCurrent;
        private final long ingestFailedCount;

        public Stats(long ingestCount, long ingestTimeInMillis, long ingestCurrent, long ingestFailedCount) {
            this.ingestCount = ingestCount;
            this.ingestTimeInMillis = ingestTimeInMillis;
            this.ingestCurrent = ingestCurrent;
            this.ingestFailedCount = ingestFailedCount;
        }

        public Stats(StreamInput in) throws IOException {
            this.ingestCount = in.readVLong();
            this.ingestTimeInMillis = in.readVLong();
            this.ingestCurrent = in.readVLong();
            this.ingestFailedCount = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.ingestCount);
            out.writeVLong(this.ingestTimeInMillis);
            out.writeVLong(this.ingestCurrent);
            out.writeVLong(this.ingestFailedCount);
        }

        public long getIngestCount() {
            return this.ingestCount;
        }

        public long getIngestTimeInMillis() {
            return this.ingestTimeInMillis;
        }

        public long getIngestCurrent() {
            return this.ingestCurrent;
        }

        public long getIngestFailedCount() {
            return this.ingestFailedCount;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("count", this.ingestCount);
            builder.humanReadableField("time_in_millis", "time", new TimeValue(this.ingestTimeInMillis, TimeUnit.MILLISECONDS));
            builder.field("current", this.ingestCurrent);
            builder.field("failed", this.ingestFailedCount);
            return builder;
        }
    }
}

