/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.elasticsearch.search.suggest.phrase.CandidateGenerator;
import org.elasticsearch.search.suggest.phrase.CandidateScorer;
import org.elasticsearch.search.suggest.phrase.Correction;
import org.elasticsearch.search.suggest.phrase.DirectCandidateGenerator;
import org.elasticsearch.search.suggest.phrase.WordScorer;

public final class NoisyChannelSpellChecker {
    public static final double REAL_WORD_LIKELYHOOD = 0.95;
    public static final int DEFAULT_TOKEN_LIMIT = 10;
    private final double realWordLikelihood;
    private final boolean requireUnigram;
    private final int tokenLimit;

    public NoisyChannelSpellChecker() {
        this(0.95);
    }

    public NoisyChannelSpellChecker(double nonErrorLikelihood) {
        this(nonErrorLikelihood, true, 10);
    }

    public NoisyChannelSpellChecker(double nonErrorLikelihood, boolean requireUnigram, int tokenLimit) {
        this.realWordLikelihood = nonErrorLikelihood;
        this.requireUnigram = requireUnigram;
        this.tokenLimit = tokenLimit;
    }

    public Result getCorrections(TokenStream stream, final CandidateGenerator generator, float maxErrors, int numCorrections, WordScorer wordScorer, float confidence, int gramSize) throws IOException {
        final ArrayList candidateSetsList = new ArrayList();
        DirectCandidateGenerator.analyze(stream, new DirectCandidateGenerator.TokenConsumer(){
            DirectCandidateGenerator.CandidateSet currentSet = null;
            private TypeAttribute typeAttribute;
            private final BytesRefBuilder termsRef = new BytesRefBuilder();
            private boolean anyUnigram = false;
            private boolean anyTokens = false;

            @Override
            public void reset(TokenStream stream) {
                super.reset(stream);
                this.typeAttribute = stream.addAttribute(TypeAttribute.class);
            }

            @Override
            public void nextToken() throws IOException {
                this.anyTokens = true;
                BytesRef term = this.fillBytesRef(this.termsRef);
                if (NoisyChannelSpellChecker.this.requireUnigram && this.typeAttribute.type() == "shingle") {
                    return;
                }
                this.anyUnigram = true;
                if (this.posIncAttr.getPositionIncrement() == 0 && this.typeAttribute.type() == "SYNONYM") {
                    assert (this.currentSet != null);
                    long freq = 0L;
                    freq = generator.frequency(term);
                    if (freq > 0L) {
                        this.currentSet.addOneCandidate(generator.createCandidate(BytesRef.deepCopyOf(term), freq, NoisyChannelSpellChecker.this.realWordLikelihood));
                    }
                } else {
                    if (this.currentSet != null) {
                        candidateSetsList.add(this.currentSet);
                    }
                    this.currentSet = new DirectCandidateGenerator.CandidateSet(DirectCandidateGenerator.Candidate.EMPTY, generator.createCandidate(BytesRef.deepCopyOf(term), true));
                }
            }

            @Override
            public void end() {
                if (this.currentSet != null) {
                    candidateSetsList.add(this.currentSet);
                }
                if (NoisyChannelSpellChecker.this.requireUnigram && !this.anyUnigram && this.anyTokens) {
                    throw new IllegalStateException("At least one unigram is required but all tokens were ngrams");
                }
            }
        });
        if (candidateSetsList.isEmpty() || candidateSetsList.size() >= this.tokenLimit) {
            return Result.EMPTY;
        }
        for (DirectCandidateGenerator.CandidateSet candidateSet : candidateSetsList) {
            generator.drawCandidates(candidateSet);
        }
        double cutoffScore = Double.MIN_VALUE;
        CandidateScorer scorer = new CandidateScorer(wordScorer, numCorrections, gramSize);
        DirectCandidateGenerator.CandidateSet[] candidateSets = candidateSetsList.toArray(new DirectCandidateGenerator.CandidateSet[candidateSetsList.size()]);
        if ((double)confidence > 0.0) {
            DirectCandidateGenerator.Candidate[] candidates = new DirectCandidateGenerator.Candidate[candidateSets.length];
            for (int i = 0; i < candidates.length; ++i) {
                candidates[i] = candidateSets[i].originalTerm;
            }
            double inputPhraseScore = scorer.score(candidates, candidateSets);
            cutoffScore = inputPhraseScore * (double)confidence;
        }
        Correction[] bestCandidates = scorer.findBestCandiates(candidateSets, maxErrors, cutoffScore);
        return new Result(bestCandidates, cutoffScore);
    }

    public Result getCorrections(Analyzer analyzer, BytesRef query, CandidateGenerator generator, float maxErrors, int numCorrections, IndexReader reader, String analysisField, WordScorer scorer, float confidence, int gramSize) throws IOException {
        return this.getCorrections(this.tokenStream(analyzer, query, new CharsRefBuilder(), analysisField), generator, maxErrors, numCorrections, scorer, confidence, gramSize);
    }

    public TokenStream tokenStream(Analyzer analyzer, BytesRef query, CharsRefBuilder spare, String field) throws IOException {
        spare.copyUTF8Bytes(query);
        return analyzer.tokenStream(field, new CharArrayReader(spare.chars(), 0, spare.length()));
    }

    public static class Result {
        public static final Result EMPTY = new Result(Correction.EMPTY, Double.MIN_VALUE);
        public final Correction[] corrections;
        public final double cutoffScore;

        public Result(Correction[] corrections, double cutoffScore) {
            this.corrections = corrections;
            this.cutoffScore = cutoffScore;
        }
    }
}

