/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.legal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

public class LegalMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File outputDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.outputDir != null) {
                this.copyLegalFiles(this.outputDir);
            } else if (this.project.getPackaging().equals("jar")) {
                this.copyLegalFiles(new File(this.project.getBasedir(), "target/classes/"));
            } else if (this.project.getPackaging().equals("maven-plugin")) {
                this.copyLegalFiles(new File(this.project.getBasedir(), "target/classes/"));
            } else if (this.project.getPackaging().equals("war")) {
                this.copyLegalFiles(new File(this.project.getBasedir(), "target/" + this.project.getArtifactId() + "-" + this.project.getVersion() + "/"));
            } else if (this.project.getPackaging().equals("jbi-shared-library")) {
                this.copyLegalFiles(new File(this.project.getBasedir(), "target/classes/"));
                this.copyLegalFiles(new File(this.project.getBasedir(), "target/" + this.project.getArtifactId() + "-" + this.project.getVersion() + "-installer/"));
            } else if (this.project.getPackaging().equals("jbi-component")) {
                this.copyLegalFiles(new File(this.project.getBasedir(), "target/classes/"));
                this.copyLegalFiles(new File(this.project.getBasedir(), "target/" + this.project.getArtifactId() + "-" + this.project.getVersion() + "-installer/"));
            } else if (this.project.getPackaging().equals("jbi-service-unit")) {
                this.copyLegalFiles(new File(this.project.getBasedir(), "target/classes/"));
            } else if (this.project.getPackaging().equals("jbi-service-assembly")) {
                this.copyLegalFiles(new File(this.project.getBasedir(), "target/classes/"));
                this.copyLegalFiles(new File(this.project.getBasedir(), "target/" + this.project.getArtifactId() + "-" + this.project.getVersion() + "-installer/"));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy legal files", (Exception)e);
        }
    }

    protected void copyLegalFiles(File outputDir) throws IOException {
        String[] names = new String[]{"/META-INF/NOTICE", "/META-INF/LICENSE"};
        for (int i = 0; i < names.length; ++i) {
            URL res = ((Object)((Object)this)).getClass().getResource(names[i]);
            FileUtils.copyURLToFile((URL)res, (File)new File(outputDir, names[i]));
        }
    }
}

