/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.geronimo;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.jbi.component.ServiceUnitManager;
import javax.management.MalformedObjectNameException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ConfigurationBuilder;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationAlreadyExistsException;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.ImportType;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.servicemix.geronimo.Component;
import org.apache.servicemix.geronimo.DeploymentPlanWrapper;
import org.apache.servicemix.geronimo.ServiceAssembly;
import org.apache.servicemix.geronimo.SharedLibrary;
import org.apache.servicemix.geronimo.deployment.SMJbiDocument;
import org.apache.servicemix.jbi.deployment.Descriptor;
import org.apache.servicemix.jbi.deployment.DescriptorFactory;
import org.apache.servicemix.jbi.deployment.ServiceUnit;
import org.apache.servicemix.jbi.deployment.SharedLibraryList;
import org.apache.xmlbeans.XmlObject;

public class ServiceMixConfigBuilder
implements ConfigurationBuilder {
    private static final Log log = LogFactory.getLog(ServiceMixConfigBuilder.class);
    private final Environment defaultEnvironment;
    private final Collection repositories;
    private final AbstractNameQuery containerName;
    private final Kernel kernel;
    public static final GBeanInfo GBEAN_INFO;

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    public ServiceMixConfigBuilder(Environment defaultEnvironment, AbstractNameQuery containerName, Collection repositories, Kernel kernel) {
        this.defaultEnvironment = defaultEnvironment;
        this.repositories = repositories;
        this.kernel = kernel;
        this.containerName = containerName;
    }

    public Object getDeploymentPlan(File planFile, JarFile module, ModuleIDBuilder idBuilder) throws DeploymentException {
        log.debug((Object)"Checking for ServiceMix deployment.");
        if (module == null) {
            return null;
        }
        try {
            URL url = DeploymentUtil.createJarURL((JarFile)module, (String)"META-INF/jbi.xml");
            Descriptor descriptor = DescriptorFactory.buildDescriptor((URL)url);
            if (descriptor == null) {
                return null;
            }
            DescriptorFactory.checkDescriptor((Descriptor)descriptor);
            XmlObject object = null;
            SMJbiDocument geronimoPlan = null;
            try {
                if (planFile != null) {
                    object = XmlObject.Factory.parse((File)planFile);
                }
            }
            catch (Exception e) {
                log.info((Object)("error " + e));
            }
            if (object != null) {
                try {
                    geronimoPlan = object instanceof SMJbiDocument ? (SMJbiDocument)object : (SMJbiDocument)object.changeType(SMJbiDocument.type);
                }
                catch (Exception e) {
                    throw new DeploymentException("Geronimo Plan found but wrong format!" + e.getMessage());
                }
            }
            return new DeploymentPlanWrapper(descriptor, geronimoPlan);
        }
        catch (Exception e) {
            log.debug((Object)"Not a ServiceMix deployment: no jbi.xml found.", (Throwable)e);
            return null;
        }
    }

    public Artifact getConfigurationID(Object plan, JarFile module, ModuleIDBuilder idBuilder) throws IOException, DeploymentException {
        DeploymentPlanWrapper wrapper = (DeploymentPlanWrapper)plan;
        Descriptor descriptor = wrapper.getServicemixDescriptor();
        if (descriptor.getComponent() != null) {
            return new Artifact("servicemix-components", descriptor.getComponent().getIdentification().getName(), "0.0", "car");
        }
        if (descriptor.getServiceAssembly() != null) {
            return new Artifact("servicemix-assemblies", descriptor.getServiceAssembly().getIdentification().getName(), "0.0", "car");
        }
        if (descriptor.getSharedLibrary() != null) {
            return new Artifact("servicemix-libraries", descriptor.getSharedLibrary().getIdentification().getName(), descriptor.getSharedLibrary().getVersion(), "car");
        }
        throw new DeploymentException("Unable to construct configuration ID " + module.getName() + ": unrecognized jbi package. Should be a component, assembly or library.");
    }

    public DeploymentContext buildConfiguration(boolean inPlaceDeployment, Artifact configId, Object plan, JarFile jarFile, Collection configurationStores, ArtifactResolver artifactResolver, ConfigurationStore targetConfigurationStore) throws IOException, DeploymentException {
        DeploymentContext context;
        block14: {
            File configurationDir;
            if (plan == null) {
                log.warn((Object)"Expected a Descriptor but received null");
                return null;
            }
            if (!(plan instanceof DeploymentPlanWrapper)) {
                log.warn((Object)("Expected a Descriptor but received a " + plan.getClass().getName()));
                return null;
            }
            if (((DeploymentPlanWrapper)plan).getServicemixDescriptor() == null) {
                log.warn((Object)"Expected a SM Descriptor but received null");
                return null;
            }
            try {
                configurationDir = targetConfigurationStore.createNewConfigurationDir(configId);
            }
            catch (ConfigurationAlreadyExistsException e) {
                throw new DeploymentException((Throwable)e);
            }
            Environment environment = new Environment();
            environment.setConfigId(configId);
            EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)this.defaultEnvironment);
            DeploymentPlanWrapper wrapper = (DeploymentPlanWrapper)plan;
            if (wrapper.getGeronimoPlan() != null && wrapper.getGeronimoPlan().getJbi() != null) {
                EnvironmentType environmentType = wrapper.getGeronimoPlan().getJbi().getEnvironment();
                if (environmentType != null) {
                    log.debug((Object)("Environment found in Geronimo Plan for Servicemix " + environmentType));
                    Environment geronimoPlanEnvironment = EnvironmentBuilder.buildEnvironment((EnvironmentType)environmentType);
                    EnvironmentBuilder.mergeEnvironments((Environment)environment, (Environment)geronimoPlanEnvironment);
                } else {
                    log.debug((Object)"no additional environment entry found in deployment plan for JBI component");
                }
            }
            context = null;
            try {
                Descriptor descriptor = wrapper.getServicemixDescriptor();
                HashMap<String, String> name = new HashMap<String, String>();
                name.put("Config", configId.toString());
                context = new DeploymentContext(configurationDir, inPlaceDeployment ? DeploymentUtil.toFile((JarFile)jarFile) : null, environment, new AbstractName(configId, name), ConfigurationModuleType.SERVICE, this.kernel.getNaming(), ConfigurationUtil.getConfigurationManager((Kernel)this.kernel), this.repositories);
                if (descriptor.getComponent() != null) {
                    this.buildComponent(descriptor, context, jarFile);
                    break block14;
                }
                if (descriptor.getServiceAssembly() != null) {
                    this.buildServiceAssembly(descriptor, context, jarFile);
                    break block14;
                }
                if (descriptor.getSharedLibrary() != null) {
                    this.buildSharedLibrary(descriptor, context, jarFile);
                    break block14;
                }
                throw new IllegalStateException("Invalid jbi descriptor");
            }
            catch (Exception e) {
                if (context != null) {
                    context.close();
                }
                DeploymentUtil.recursiveDelete((File)configurationDir);
                throw new DeploymentException("Unable to deploy", (Throwable)e);
            }
        }
        return context;
    }

    protected void buildComponent(Descriptor descriptor, DeploymentContext context, JarFile module) throws Exception {
        String[] pathElements;
        SharedLibraryList[] slList;
        Environment environment = context.getConfiguration().getEnvironment();
        File targetDir = new File(context.getBaseDir(), "install");
        targetDir.mkdirs();
        this.unzip(context, module, new URI("install/"));
        File workDir = new File(context.getBaseDir(), "workspace");
        workDir.mkdirs();
        if ("self-first".equals(descriptor.getComponent().getComponentClassLoaderDelegation())) {
            context.getConfiguration().getEnvironment().setInverseClassLoading(true);
        }
        if ((slList = descriptor.getComponent().getSharedLibraries()) != null) {
            for (int i = 0; i < slList.length; ++i) {
                Artifact sl = new Artifact("servicemix-libraries", slList[i].getName(), slList[i].getVersion(), "car");
                environment.addDependency(sl, ImportType.CLASSES);
            }
        }
        if (descriptor.getComponent().getComponentClassPath() != null && (pathElements = descriptor.getComponent().getComponentClassPath().getPathElements()) != null) {
            for (int i = 0; i < pathElements.length; ++i) {
                context.getConfiguration().addToClassPath(new URI("install/").resolve(pathElements[i]).toString());
            }
        }
        Properties props = new Properties();
        props.put("jbiType", "JBIComponent");
        props.put("name", descriptor.getComponent().getIdentification().getName());
        AbstractName name = new AbstractName(environment.getConfigId(), (Map)props);
        GBeanData gbeanData = new GBeanData(name, Component.GBEAN_INFO);
        gbeanData.setAttribute("name", (Object)descriptor.getComponent().getIdentification().getName());
        gbeanData.setAttribute("description", (Object)descriptor.getComponent().getIdentification().getDescription());
        gbeanData.setAttribute("type", (Object)descriptor.getComponent().getType());
        gbeanData.setAttribute("className", (Object)descriptor.getComponent().getComponentClassName());
        gbeanData.setReferencePattern("container", this.containerName);
        context.addGBean(gbeanData);
    }

    protected void buildServiceAssembly(Descriptor descriptor, DeploymentContext context, JarFile module) throws Exception {
        String name;
        Environment environment = context.getConfiguration().getEnvironment();
        File targetDir = new File(context.getBaseDir(), "install");
        targetDir.mkdirs();
        this.unzip(context, module, new URI("install/"));
        ServiceUnit[] sus = descriptor.getServiceAssembly().getServiceUnits();
        for (int i = 0; i < sus.length; ++i) {
            name = sus[i].getIdentification().getName();
            String zip = sus[i].getTarget().getArtifactsZip();
            String comp = sus[i].getTarget().getComponentName();
            URI installUri = new URI("sus/" + comp + "/" + name + "/");
            this.unzip(context, new JarFile(new File(targetDir, zip)), installUri);
            Artifact sl = new Artifact("servicemix-components", comp, "0.0", "car");
            environment.addDependency(sl, ImportType.ALL);
            javax.jbi.component.Component jbiServiceUnit = null;
            try {
                jbiServiceUnit = this.getAssociatedJbiServiceUnit(comp, sl);
            }
            catch (GBeanNotFoundException e) {
                throw new DeploymentException("Can not find the associated service unit for this service assembly. Check if it's deployed and started.", (Throwable)e);
            }
            ServiceUnitManager serviceUnitManager = jbiServiceUnit.getServiceUnitManager();
            File installDir = new File(context.getBaseDir(), installUri.toString());
            String deploy = serviceUnitManager.deploy(name, installDir.getAbsolutePath());
            log.debug((Object)deploy);
        }
        Properties props = new Properties();
        props.put("jbiType", "JBIServiceAssembly");
        props.put("name", descriptor.getServiceAssembly().getIdentification().getName());
        name = new AbstractName(environment.getConfigId(), (Map)props);
        GBeanData gbeanData = new GBeanData((AbstractName)name, ServiceAssembly.GBEAN_INFO);
        gbeanData.setAttribute("name", (Object)descriptor.getServiceAssembly().getIdentification().getName());
        gbeanData.setReferencePattern("container", this.containerName);
        for (int i = 0; i < sus.length; ++i) {
            String comp = sus[i].getTarget().getComponentName();
            gbeanData.addDependency(this.getComponentName(comp));
        }
        context.addGBean(gbeanData);
    }

    private javax.jbi.component.Component getAssociatedJbiServiceUnit(String compName, Artifact artifactName) throws GBeanNotFoundException {
        Properties props = new Properties();
        props.put("jbiType", "JBIComponent");
        props.put("name", compName);
        Component serviceUnit = (Component)this.kernel.getGBean(new AbstractName(artifactName, (Map)props));
        javax.jbi.component.Component jbiServiceUnit = serviceUnit.getComponent();
        return jbiServiceUnit;
    }

    protected void buildSharedLibrary(Descriptor descriptor, DeploymentContext context, JarFile module) throws Exception {
        Environment environment = context.getConfiguration().getEnvironment();
        File targetDir = new File(context.getBaseDir(), "install");
        targetDir.mkdirs();
        this.unzip(context, module, new URI("install/"));
        File workDir = new File(context.getBaseDir(), "workspace");
        workDir.mkdirs();
        if ("self-first".equals(descriptor.getSharedLibrary().getClassLoaderDelegation())) {
            context.getConfiguration().getEnvironment().setInverseClassLoading(true);
        }
        if (descriptor.getSharedLibrary().getSharedLibraryClassPath() != null) {
            String[] pathElements = descriptor.getSharedLibrary().getSharedLibraryClassPath().getPathElements();
            if (pathElements != null) {
                for (int i = 0; i < pathElements.length; ++i) {
                    log.debug((Object)("Processing pathElements[" + i + "]: " + pathElements[i]));
                    File include = new File(targetDir, pathElements[i]);
                    File temp = new File(workDir, pathElements[i]);
                    if (!include.isFile()) {
                        throw new Exception("Classpath element '" + pathElements[i] + "' not found");
                    }
                    temp.getParentFile().mkdirs();
                    include.renameTo(temp);
                    context.addInclude(new URI("install/").resolve(pathElements[i]), temp);
                    temp.delete();
                }
            } else {
                log.debug((Object)"SharedLibrary().getSharedLibraryClassPath().getPathElements() is null");
            }
        } else {
            log.debug((Object)"SharedLibrary().getSharedLibraryClassPath() is null");
        }
        Properties props = new Properties();
        props.put("jbiType", "JBISharedLibrary");
        props.put("name", descriptor.getSharedLibrary().getIdentification().getName());
        AbstractName name = new AbstractName(environment.getConfigId(), (Map)props);
        GBeanData gbeanData = new GBeanData(name, SharedLibrary.GBEAN_INFO);
        gbeanData.setAttribute("name", (Object)descriptor.getSharedLibrary().getIdentification().getName());
        gbeanData.setAttribute("description", (Object)descriptor.getSharedLibrary().getIdentification().getDescription());
        gbeanData.setReferencePattern("container", this.containerName);
        context.addGBean(gbeanData);
    }

    protected void unzip(DeploymentContext context, JarFile module, URI targetUri) throws IOException {
        Enumeration<JarEntry> entries = module.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            URI target = targetUri.resolve(entry.getName());
            context.addFile(target, (ZipFile)module, entry);
        }
    }

    protected AbstractNameQuery getComponentName(String name) throws MalformedObjectNameException {
        URI uri = URI.create("servicemix-components/" + name + "//car?jbiType=JBIComponent");
        return new AbstractNameQuery(uri);
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(ServiceMixConfigBuilder.class, "ConfigBuilder");
        infoFactory.addInterface(ConfigurationBuilder.class);
        infoFactory.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("containerName", AbstractNameQuery.class, true, true);
        infoFactory.addReference("Repositories", Repository.class, "Repository");
        infoFactory.setConstructor(new String[]{"defaultEnvironment", "containerName", "Repositories", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

