/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.maven.plugin.xfire;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.codehaus.xfire.gen.WsdlGenTask;
import org.codehaus.xfire.spring.XFireConfigLoader;

public class WsdlgenMojo
extends AbstractMojo {
    private MavenProject project;
    private List configs;
    private File outputDirectory;
    private File basedir;

    public void execute() throws MojoExecutionException {
        URL[] urls;
        if (this.configs == null) {
            this.configs = new ArrayList();
        }
        if (this.configs.size() == 0) {
            this.configs.add(new File(this.basedir, "src/main/resources/META-INF/xfire/services.xml").getPath());
        }
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            this.getLog().warn((CharSequence)("the output directory " + this.outputDirectory + " doesn't exist and couldn't be created. The goal with probably fail."));
        }
        Project antProject = new Project();
        antProject.addBuildListener((BuildListener)new DebugAntBuildListener());
        ClassLoader parent = WsdlGenTask.class.getClassLoader();
        try {
            Set l = this.project.getArtifacts();
            ArrayList<URL> theurls = new ArrayList<URL>();
            theurls.add(new File(this.project.getBuild().getOutputDirectory()).toURL());
            for (Artifact dep : l) {
                theurls.add(dep.getFile().toURL());
            }
            urls = theurls.toArray(new URL[theurls.size()]);
            this.getLog().debug((CharSequence)("classloader classpath: " + theurls));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        URLClassLoader cl = new URLClassLoader(urls, parent);
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        WsdlGenTask task = new WsdlGenTask();
        task.setProject(antProject);
        task.setOutputDirectory(this.outputDirectory.getAbsolutePath());
        for (String configUrl : this.configs) {
            if (!new File(configUrl).exists()) {
                this.getLog().warn((CharSequence)"configUrl not found. Task will perhaps fail");
            }
            task.setConfigUrl(configUrl);
            this.getLog().info((CharSequence)("Executing XFire WsdlGen task for configUrl: " + configUrl));
            try {
                task.execute();
            }
            catch (BuildException e) {
                throw new MojoExecutionException("command execution failed", (Exception)((Object)e));
            }
            this.getLog().debug((CharSequence)("generated " + task.getGeneratedFile()));
        }
        Thread.currentThread().setContextClassLoader(oldCl);
        this.getLog().debug((CharSequence)"Adding outputDirectory as Project's resource.");
        Resource resource = new Resource();
        resource.setDirectory(this.outputDirectory.getAbsolutePath());
        this.project.addResource(resource);
    }

    private void displayClasspath(ClassLoader classLoader, String message) {
        this.getLog().info((CharSequence)("------ " + message + ":" + classLoader));
        if (classLoader == null) {
            return;
        }
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader cl = (URLClassLoader)classLoader;
            URL[] urls = cl.getURLs();
            for (int i = 0; i < urls.length; ++i) {
                URL urL = urls[i];
                this.getLog().info((CharSequence)("URL " + i + ":" + urL));
            }
        } else if (classLoader instanceof AntClassLoader) {
            AntClassLoader cl = (AntClassLoader)XFireConfigLoader.class.getClassLoader();
            String[] urls = cl.getClasspath().split(File.pathSeparator);
            for (int i = 0; i < urls.length; ++i) {
                String url = urls[i];
                this.getLog().info((CharSequence)("URL " + i + ":" + url));
            }
        }
        this.displayClasspath(classLoader.getParent(), "parent->" + message);
    }

    void load(String className, ClassLoader cl) {
        try {
            Class<?> c = Class.forName(className, true, cl);
            this.getLog().debug((CharSequence)c.toString());
        }
        catch (Exception e) {
            this.displayClasspath(cl, "using classpath");
            this.getLog().error((Throwable)e);
        }
    }

    private class DebugAntBuildListener
    implements BuildListener {
        private DebugAntBuildListener() {
        }

        public void buildStarted(BuildEvent buildEvent) {
            WsdlgenMojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }

        public void buildFinished(BuildEvent buildEvent) {
            WsdlgenMojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }

        public void targetStarted(BuildEvent buildEvent) {
            WsdlgenMojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }

        public void targetFinished(BuildEvent buildEvent) {
            WsdlgenMojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }

        public void taskStarted(BuildEvent buildEvent) {
            WsdlgenMojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }

        public void taskFinished(BuildEvent buildEvent) {
            WsdlgenMojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }

        public void messageLogged(BuildEvent buildEvent) {
            WsdlgenMojo.this.getLog().debug((CharSequence)buildEvent.getMessage());
        }
    }
}

