/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.servlet;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.lang.util.StringUtils;
import org.apache.shiro.web.servlet.Cookie;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCookie
implements Cookie {
    public static final int DEFAULT_MAX_AGE = -1;
    public static final int DEFAULT_VERSION = -1;
    protected static final String NAME_VALUE_DELIMITER = "=";
    protected static final String ATTRIBUTE_DELIMITER = "; ";
    protected static final long DAY_MILLIS = 86400000L;
    protected static final String GMT_TIME_ZONE_ID = "GMT";
    protected static final String COOKIE_DATE_FORMAT_STRING = "EEE, dd-MMM-yyyy HH:mm:ss z";
    protected static final String COOKIE_HEADER_NAME = "Set-Cookie";
    protected static final String PATH_ATTRIBUTE_NAME = "Path";
    protected static final String EXPIRES_ATTRIBUTE_NAME = "Expires";
    protected static final String MAXAGE_ATTRIBUTE_NAME = "Max-Age";
    protected static final String DOMAIN_ATTRIBUTE_NAME = "Domain";
    protected static final String VERSION_ATTRIBUTE_NAME = "Version";
    protected static final String COMMENT_ATTRIBUTE_NAME = "Comment";
    protected static final String SECURE_ATTRIBUTE_NAME = "Secure";
    protected static final String HTTP_ONLY_ATTRIBUTE_NAME = "HttpOnly";
    protected static final String SAME_SITE_ATTRIBUTE_NAME = "SameSite";
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleCookie.class);
    private String name;
    private String value;
    private String comment;
    private String domain;
    private String path;
    private int maxAge;
    private int version;
    private boolean secure;
    private boolean httpOnly;
    private Cookie.SameSiteOptions sameSite;

    public SimpleCookie() {
        this.maxAge = -1;
        this.version = -1;
        this.httpOnly = true;
        this.sameSite = Cookie.SameSiteOptions.LAX;
    }

    public SimpleCookie(String name) {
        this();
        this.name = name;
    }

    public SimpleCookie(Cookie cookie) {
        this.name = cookie.getName();
        this.value = cookie.getValue();
        this.comment = cookie.getComment();
        this.domain = cookie.getDomain();
        this.path = cookie.getPath();
        this.maxAge = Math.max(-1, cookie.getMaxAge());
        this.version = Math.max(-1, cookie.getVersion());
        this.secure = cookie.isSecure();
        this.httpOnly = cookie.isHttpOnly();
        this.sameSite = cookie.getSameSite();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (!StringUtils.hasText((String)name)) {
            throw new IllegalArgumentException("Name cannot be null/empty.");
        }
        this.name = name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public int getMaxAge() {
        return this.maxAge;
    }

    @Override
    public void setMaxAge(int maxAge) {
        this.maxAge = Math.max(-1, maxAge);
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = Math.max(-1, version);
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    @Override
    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    @Override
    public Cookie.SameSiteOptions getSameSite() {
        return this.sameSite;
    }

    @Override
    public void setSameSite(Cookie.SameSiteOptions sameSite) {
        this.sameSite = sameSite;
        if (this.sameSite == Cookie.SameSiteOptions.NONE) {
            this.setSecure(true);
        }
    }

    private String calculatePath(HttpServletRequest request) {
        String path = StringUtils.clean((String)this.getPath());
        if (!StringUtils.hasText((String)path)) {
            path = StringUtils.clean((String)request.getContextPath());
        }
        if (path == null) {
            path = "/";
        }
        LOGGER.trace("calculated path: {}", (Object)path);
        return path;
    }

    @Override
    public void saveTo(HttpServletRequest request, HttpServletResponse response) {
        String name = this.getName();
        String value = this.getValue();
        String comment = this.getComment();
        String domain = this.getDomain();
        String path = this.calculatePath(request);
        int maxAge = this.getMaxAge();
        int version = this.getVersion();
        boolean secure = this.isSecure();
        boolean httpOnly = this.isHttpOnly();
        Cookie.SameSiteOptions sameSite = this.getSameSite();
        this.addCookieHeader(response, name, value, comment, domain, path, maxAge, version, secure, httpOnly, sameSite);
    }

    private void addCookieHeader(HttpServletResponse response, String name, String value, String comment, String domain, String path, int maxAge, int version, boolean secure, boolean httpOnly, Cookie.SameSiteOptions sameSite) {
        String headerValue = this.buildHeaderValue(name, value, comment, domain, path, maxAge, version, secure, httpOnly, sameSite);
        response.addHeader(COOKIE_HEADER_NAME, headerValue);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Added HttpServletResponse Cookie [{}]", (Object)headerValue);
        }
    }

    protected String buildHeaderValue(String name, String value, String comment, String domain, String path, int maxAge, int version, boolean secure, boolean httpOnly) {
        return this.buildHeaderValue(name, value, comment, domain, path, maxAge, version, secure, httpOnly, this.getSameSite());
    }

    protected String buildHeaderValue(String name, String value, String comment, String domain, String path, int maxAge, int version, boolean secure, boolean httpOnly, Cookie.SameSiteOptions sameSite) {
        if (!StringUtils.hasText((String)name)) {
            throw new IllegalStateException("Cookie name cannot be null/empty.");
        }
        StringBuilder sb = new StringBuilder(name).append(NAME_VALUE_DELIMITER);
        if (StringUtils.hasText((String)value)) {
            sb.append(value);
        }
        this.appendComment(sb, comment);
        this.appendDomain(sb, domain);
        this.appendPath(sb, path);
        this.appendExpires(sb, maxAge);
        this.appendVersion(sb, version);
        this.appendSecure(sb, secure);
        this.appendHttpOnly(sb, httpOnly);
        this.appendSameSite(sb, sameSite);
        return sb.toString();
    }

    private void appendComment(StringBuilder sb, String comment) {
        if (StringUtils.hasText((String)comment)) {
            sb.append(ATTRIBUTE_DELIMITER);
            sb.append(COMMENT_ATTRIBUTE_NAME).append(NAME_VALUE_DELIMITER).append(comment);
        }
    }

    private void appendDomain(StringBuilder sb, String domain) {
        if (StringUtils.hasText((String)domain)) {
            sb.append(ATTRIBUTE_DELIMITER);
            sb.append(DOMAIN_ATTRIBUTE_NAME).append(NAME_VALUE_DELIMITER).append(domain);
        }
    }

    private void appendPath(StringBuilder sb, String path) {
        if (StringUtils.hasText((String)path)) {
            sb.append(ATTRIBUTE_DELIMITER);
            sb.append(PATH_ATTRIBUTE_NAME).append(NAME_VALUE_DELIMITER).append(path);
        }
    }

    private void appendExpires(StringBuilder sb, int maxAge) {
        if (maxAge >= 0) {
            Date expires;
            sb.append(ATTRIBUTE_DELIMITER);
            sb.append(MAXAGE_ATTRIBUTE_NAME).append(NAME_VALUE_DELIMITER).append(maxAge);
            sb.append(ATTRIBUTE_DELIMITER);
            if (maxAge == 0) {
                expires = new Date(System.currentTimeMillis() - 86400000L);
            } else {
                Calendar cal = Calendar.getInstance();
                cal.add(13, maxAge);
                expires = cal.getTime();
            }
            String formatted = SimpleCookie.toCookieDate(expires);
            sb.append(EXPIRES_ATTRIBUTE_NAME).append(NAME_VALUE_DELIMITER).append(formatted);
        }
    }

    private void appendVersion(StringBuilder sb, int version) {
        if (version > -1) {
            sb.append(ATTRIBUTE_DELIMITER);
            sb.append(VERSION_ATTRIBUTE_NAME).append(NAME_VALUE_DELIMITER).append(version);
        }
    }

    private void appendSecure(StringBuilder sb, boolean secure) {
        if (secure) {
            sb.append(ATTRIBUTE_DELIMITER);
            sb.append(SECURE_ATTRIBUTE_NAME);
        }
    }

    private void appendHttpOnly(StringBuilder sb, boolean httpOnly) {
        if (httpOnly) {
            sb.append(ATTRIBUTE_DELIMITER);
            sb.append(HTTP_ONLY_ATTRIBUTE_NAME);
        }
    }

    private void appendSameSite(StringBuilder sb, Cookie.SameSiteOptions sameSite) {
        if (sameSite != null) {
            sb.append(ATTRIBUTE_DELIMITER);
            sb.append(SAME_SITE_ATTRIBUTE_NAME).append(NAME_VALUE_DELIMITER).append(sameSite.toString().toLowerCase(Locale.ENGLISH));
        }
    }

    private boolean pathMatches(String cookiePath, String requestPath) {
        if (!requestPath.startsWith(cookiePath)) {
            return false;
        }
        return requestPath.length() == cookiePath.length() || cookiePath.charAt(cookiePath.length() - 1) == '/' || requestPath.charAt(cookiePath.length()) == '/';
    }

    private static String toCookieDate(Date date) {
        TimeZone tz = TimeZone.getTimeZone(GMT_TIME_ZONE_ID);
        SimpleDateFormat fmt = new SimpleDateFormat(COOKIE_DATE_FORMAT_STRING, Locale.US);
        fmt.setTimeZone(tz);
        return fmt.format(date);
    }

    @Override
    public void removeFrom(HttpServletRequest request, HttpServletResponse response) {
        String name = this.getName();
        String value = "deleteMe";
        Object comment = null;
        String domain = this.getDomain();
        String path = this.calculatePath(request);
        int maxAge = 0;
        int version = this.getVersion();
        boolean secure = this.isSecure();
        boolean httpOnly = false;
        Cookie.SameSiteOptions sameSite = this.getSameSite();
        this.addCookieHeader(response, name, value, null, domain, path, maxAge, version, secure, httpOnly, sameSite);
        LOGGER.trace("Removed '{}' cookie by setting maxAge=0", (Object)name);
    }

    @Override
    public String readValue(HttpServletRequest request, HttpServletResponse ignored) {
        String name = this.getName();
        String value = null;
        javax.servlet.http.Cookie cookie = SimpleCookie.getCookie(request, name);
        if (cookie != null) {
            String path = StringUtils.clean((String)this.getPath());
            if (path != null && !this.pathMatches(path, request.getRequestURI())) {
                LOGGER.warn("Found '{}' cookie at path '{}', but should be only used for '{}'", new Object[]{name, Encode.forHtml((String)request.getRequestURI()), path});
            } else {
                value = cookie.getValue();
                LOGGER.debug("Found '{}' cookie value [{}]", (Object)name, (Object)Encode.forHtml((String)value));
            }
        } else {
            LOGGER.trace("No '{}' cookie value", (Object)name);
        }
        return value;
    }

    private static javax.servlet.http.Cookie getCookie(HttpServletRequest request, String cookieName) {
        javax.servlet.http.Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (javax.servlet.http.Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie;
            }
        }
        return null;
    }
}

