/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.boomerang;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sirona.Role;
import org.apache.sirona.SironaException;
import org.apache.sirona.boomerang.parser.BoomerangData;
import org.apache.sirona.boomerang.parser.QueryParser;
import org.apache.sirona.configuration.ioc.IoCs;
import org.apache.sirona.counters.Counter;
import org.apache.sirona.counters.DefaultCounter;
import org.apache.sirona.counters.OptimizedStatistics;
import org.apache.sirona.counters.Unit;
import org.apache.sirona.math.M2AwareStatisticalSummary;
import org.apache.sirona.repositories.Repository;
import org.apache.sirona.store.BatchFuture;
import org.apache.sirona.store.counter.CollectorCounterStore;
import org.apache.sirona.store.counter.CounterDataStore;
import org.apache.sirona.store.counter.InMemoryCounterDataStore;
import org.apache.sirona.util.DaemonThreadFactory;

public class BoomerangServlet
extends HttpServlet {
    private static final String UTF_8 = "UTF-8";
    public static final Unit BYTE_PER_SEC = new Unit("b/s");
    public static final Role BOOMERANG_PERCEIVED = new Role("boomerang_perceived", Unit.Time.MILLISECOND);
    public static final Role BOOMERANG_LATENCY = new Role("boomerang_latency", Unit.Time.MILLISECOND);
    public static final Role BOOMERANG_BANDWITH = new Role("boomerang_bandwidth", BYTE_PER_SEC);
    private static final String BOOMERANG_MARKER = "boomerang";
    private static final String DEFAULT_DELAY = "4000";
    private String encoding = "UTF-8";
    private CounterDataStore counterStore = null;
    private BatchFuture future = null;

    public void init(ServletConfig config) throws ServletException {
        this.encoding = config.getInitParameter("encoding");
        if (this.encoding == null) {
            this.encoding = UTF_8;
        }
        IoCs.findOrCreateInstance(Repository.class);
        try {
            CollectorCounterStore collectorCounterStore = (CollectorCounterStore)IoCs.getInstance(CollectorCounterStore.class);
            if (collectorCounterStore == null) {
                this.counterStore = (CounterDataStore)IoCs.getInstance(CounterDataStore.class);
            } else {
                this.counterStore = new InitializedCounterDataStore(collectorCounterStore);
                String delayStr = config.getInitParameter("rate");
                if (delayStr == null) {
                    delayStr = DEFAULT_DELAY;
                }
                ScheduledExecutorService pool = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory("boomerang-updater-" + Math.abs(((Object)((Object)this)).hashCode())));
                long delay = Long.parseLong(delayStr);
                ScheduledFuture<?> task = pool.scheduleWithFixedDelay(new CollectorUpdater(collectorCounterStore, this.counterStore), delay, delay, TimeUnit.MILLISECONDS);
                this.future = new BatchFuture(pool, task);
            }
        }
        catch (SironaException se) {
            this.counterStore = (CounterDataStore)IoCs.getInstance(CounterDataStore.class);
        }
    }

    public void destroy() {
        if (this.future != null) {
            this.future.done();
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        BoomerangData data = QueryParser.parse(this.toMap(req.getQueryString()));
        if (data.validate()) {
            String name = new URL(data.getUrl()).getPath();
            if (data.getTDone() != null) {
                this.addToCounter(BOOMERANG_PERCEIVED, name, data.getTDone());
            }
            if (data.getLatency() != null) {
                this.addToCounter(BOOMERANG_LATENCY, name, data.getLatency());
            }
            if (data.getBandwidth() != null) {
                this.addToCounter(BOOMERANG_BANDWITH, name, data.getBandwidth());
            }
        }
        resp.setStatus(200);
        resp.getWriter().write("");
    }

    private void addToCounter(Role role, String name, long value) throws MalformedURLException {
        Counter.Key key = new Counter.Key(role, name);
        Counter counter = this.counterStore.getOrCreateCounter(key);
        this.counterStore.addToCounter(counter, key.getRole().getUnit().convert((double)value, Unit.Time.MILLISECOND));
    }

    private Map<String, String> toMap(String query) {
        if (query == null || query.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> params = new HashMap<String, String>(15);
        for (String kv : query.split("&")) {
            String[] split;
            String trimmed = kv.trim();
            if (trimmed.isEmpty() || (split = trimmed.split("=")).length != 2) continue;
            try {
                params.put(split[0], URLDecoder.decode(split[1], this.encoding));
            }
            catch (UnsupportedEncodingException e) {
                params.put(split[0], split[1]);
            }
        }
        return params;
    }

    private static class InitializedDefaultCounter
    extends DefaultCounter {
        public InitializedDefaultCounter(Counter.Key key, InitializedCounterDataStore store, Counter aggregate) {
            super(key, (CounterDataStore)store, new OptimizedStatistics(aggregate.getHits(), aggregate.getSum(), aggregate.getMin(), aggregate.getMax(), aggregate.getMean(), aggregate.getSecondMoment()));
        }
    }

    private static class InitializedCounterDataStore
    extends InMemoryCounterDataStore {
        private final CollectorCounterStore delegate;

        public InitializedCounterDataStore(CollectorCounterStore collectorCounterStore) {
            this.delegate = collectorCounterStore;
        }

        protected Counter newCounter(Counter.Key key) {
            return new InitializedDefaultCounter(key, this, this.delegate.getOrCreateCounter(key, BoomerangServlet.BOOMERANG_MARKER));
        }
    }

    private static class CollectorUpdater
    implements Runnable {
        private final CollectorCounterStore collectorCounterStore;
        private final CounterDataStore aggregator;

        private CollectorUpdater(CollectorCounterStore collectorCounterStore, CounterDataStore aggregator) {
            this.collectorCounterStore = collectorCounterStore;
            this.aggregator = aggregator;
        }

        @Override
        public void run() {
            for (Counter aggregate : this.aggregator.getCounters()) {
                M2AwareStatisticalSummary stats = new M2AwareStatisticalSummary(aggregate.getMean(), aggregate.getVariance(), aggregate.getHits(), aggregate.getMax(), aggregate.getMin(), aggregate.getSum(), aggregate.getSecondMoment());
                this.collectorCounterStore.update(aggregate.getKey(), BoomerangServlet.BOOMERANG_MARKER, stats, aggregate.getMaxConcurrency());
            }
        }
    }
}

