/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sirona.configuration.ioc.IoCs;
import org.apache.sirona.reporting.web.handler.FilteringEndpoints;
import org.apache.sirona.reporting.web.handler.HomeEndpoint;
import org.apache.sirona.reporting.web.handler.internal.EndpointInfo;
import org.apache.sirona.reporting.web.handler.internal.Invoker;
import org.apache.sirona.reporting.web.plugin.PluginRepository;
import org.apache.sirona.reporting.web.plugin.api.MapBuilder;
import org.apache.sirona.reporting.web.template.Templates;
import org.apache.sirona.repositories.Repository;

public class SironaController
implements Filter {
    public static final String CONTENT_TYPE = "Content-Type";
    private final Map<String, byte[]> cachedResources = new ConcurrentHashMap<String, byte[]>();
    private final Map<Pattern, Invoker> invokers = new HashMap<Pattern, Invoker>();
    private String mapping = null;
    private ClassLoader classloader;
    private Invoker defaultInvoker;

    public void init(FilterConfig config) throws ServletException {
        IoCs.findOrCreateInstance(Repository.class);
        this.classloader = Thread.currentThread().getContextClassLoader();
        this.initMapping(config.getInitParameter("monitoring-mapping"));
        Templates.init(config.getServletContext().getContextPath(), this.mapping);
        this.initHandlers();
    }

    private void initHandlers() {
        this.invokers.putAll(EndpointInfo.build(HomeEndpoint.class, null, "").getInvokers());
        this.defaultInvoker = this.invokers.values().iterator().next();
        this.invokers.putAll(EndpointInfo.build(FilteringEndpoints.class, null, "").getInvokers());
        for (PluginRepository.PluginInfo plugin : PluginRepository.PLUGIN_INFO) {
            for (Map.Entry<Pattern, Invoker> invoker : plugin.getInvokers().entrySet()) {
                this.invokers.put(invoker.getKey(), invoker.getValue());
            }
        }
    }

    public void setMapping(String mapping) {
        this.initMapping(mapping);
    }

    private void initMapping(String value) {
        if (this.mapping != null) {
            return;
        }
        this.mapping = value == null ? "" : (!value.startsWith("/") ? "/" + this.mapping : value);
        if (this.mapping.endsWith("/")) {
            this.mapping = this.mapping.substring(0, this.mapping.length() - 1);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!HttpServletRequest.class.isInstance(request)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)HttpServletRequest.class.cast(request);
        final HttpServletResponse httpResponse = (HttpServletResponse)HttpServletResponse.class.cast(response);
        String baseUri = httpRequest.getContextPath() + this.mapping;
        request.setAttribute("baseUri", (Object)baseUri);
        String requestURI = httpRequest.getRequestURI();
        String path = SironaController.buildMatchablePath(httpRequest, baseUri, requestURI, true);
        String pathWithoutParams = SironaController.buildMatchablePath(httpRequest, baseUri, requestURI, false);
        Invoker invoker = this.defaultInvoker;
        Matcher matcher = null;
        for (Map.Entry<Pattern, Invoker> entry : this.invokers.entrySet()) {
            Pattern pattern = entry.getKey();
            matcher = pattern.matcher(path);
            if (matcher.matches()) {
                invoker = entry.getValue();
                if (entry.getKey().pattern().endsWith(".*")) continue;
                break;
            }
            matcher = pattern.matcher(pathWithoutParams);
            if (!matcher.matches()) continue;
            invoker = entry.getValue();
        }
        boolean skipFiltering = false;
        if (requestURI.endsWith(".css")) {
            httpResponse.setHeader(CONTENT_TYPE, "text/css");
        } else if (requestURI.endsWith(".js")) {
            httpResponse.setHeader(CONTENT_TYPE, "application/javascript");
        } else if (requestURI.endsWith(".png")) {
            httpResponse.setHeader(CONTENT_TYPE, "image/png");
            skipFiltering = true;
        } else if (requestURI.endsWith(".gif")) {
            httpResponse.setHeader(CONTENT_TYPE, "image/gif");
            skipFiltering = true;
        } else if (requestURI.endsWith(".jpg")) {
            httpResponse.setHeader(CONTENT_TYPE, "image/jpeg");
            skipFiltering = true;
        } else if (requestURI.endsWith(".svg")) {
            httpResponse.setHeader(CONTENT_TYPE, "image/svg+xml");
            skipFiltering = true;
        } else if (requestURI.endsWith(".eot")) {
            httpResponse.setHeader(CONTENT_TYPE, "application/vnd.ms-fontobject");
            skipFiltering = true;
        } else if (requestURI.endsWith(".woff")) {
            httpResponse.setHeader(CONTENT_TYPE, "application/font-woff");
            skipFiltering = true;
        } else if (requestURI.endsWith(".ttf") || requestURI.endsWith(".itf")) {
            httpResponse.setHeader(CONTENT_TYPE, "application/octet-stream");
            skipFiltering = true;
        }
        if (pathWithoutParams.startsWith("/resources/")) {
            byte[] bytes = this.cachedResources.get(pathWithoutParams);
            if (bytes == null) {
                InputStream is;
                if (!skipFiltering && invoker != this.defaultInvoker) {
                    StringWriter writer = new StringWriter();
                    final PrintWriter printWriter = new PrintWriter(writer);
                    invoker.invoke(httpRequest, (HttpServletResponse)HttpServletResponse.class.cast(Proxy.newProxyInstance(this.classloader, new Class[]{HttpServletResponse.class}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            if ("getWriter".equals(method.getName())) {
                                return printWriter;
                            }
                            return method.invoke((Object)httpResponse, args);
                        }
                    })), null);
                    is = new ByteArrayInputStream(writer.toString().getBytes());
                } else {
                    is = this.classloader.getResourceAsStream(pathWithoutParams.substring(1));
                }
                if (is != null) {
                    ByteArrayOutputStream baos = (ByteArrayOutputStream)ByteArrayOutputStream.class.cast(request.getAttribute("resourceCache"));
                    if (baos == null) {
                        int i;
                        baos = new ByteArrayOutputStream();
                        while ((i = is.read()) != -1) {
                            baos.write(i);
                        }
                    }
                    bytes = baos.toByteArray();
                    this.cachedResources.put(pathWithoutParams, bytes);
                }
            }
            if (bytes != null) {
                if (bytes.length == 0) {
                    httpResponse.setStatus(404);
                } else {
                    httpResponse.getOutputStream().write(bytes);
                }
                return;
            }
        }
        if (invoker == null) {
            this.error(response, null);
        } else {
            try {
                invoker.invoke(httpRequest, httpResponse, matcher);
            }
            catch (Exception e) {
                this.error(response, e);
            }
        }
    }

    private static String buildMatchablePath(HttpServletRequest httpRequest, String baseUri, String requestURI, boolean withParams) {
        String path = requestURI.substring(Math.min(baseUri.length() + 1, requestURI.length()));
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!withParams) {
            return path;
        }
        TreeMap params = new TreeMap(httpRequest.getParameterMap());
        boolean first = true;
        for (Map.Entry param : params.entrySet()) {
            String[] value = (String[])param.getValue();
            if (value == null || value.length < 1) continue;
            if (first) {
                path = path + "?";
                first = false;
            } else {
                path = path + "&";
            }
            path = path + (String)param.getKey() + "=" + value[0];
        }
        return path;
    }

    private void error(ServletResponse response, Exception e) throws IOException {
        String exception;
        if (e != null) {
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(err));
            exception = new String(err.toByteArray());
        } else {
            exception = "No matcher found";
        }
        Templates.htmlRender(response.getWriter(), "error.vm", new MapBuilder().set((Object)"exception", (Object)exception).build());
    }

    public void destroy() {
        this.invokers.clear();
    }
}

