/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.template;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.reporting.web.plugin.PluginRepository;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.JdkLogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public final class Templates {
    public static final String RESOURCE_LOADER_KEY = "monitoring.resource.loader.class";
    private static String mapping;
    private static VelocityEngine engine;

    public static void init(String context, String filterMapping) {
        Properties velocityConfiguration = new Properties();
        velocityConfiguration.setProperty("runtime.log.logsystem.class", JdkLogChute.class.getName());
        velocityConfiguration.setProperty("ISO-8859-1", "UTF-8");
        velocityConfiguration.setProperty("input.encoding", "UTF-8");
        velocityConfiguration.setProperty("output.encoding", "UTF-8");
        velocityConfiguration.setProperty("runtime.references.strict", Boolean.TRUE.toString());
        velocityConfiguration.setProperty("runtime.references.strict.escape", Boolean.TRUE.toString());
        velocityConfiguration.setProperty("resource.loader", "monitoring");
        velocityConfiguration.setProperty("velocimacro.library", "/templates/macro.vm");
        velocityConfiguration.setProperty(RESOURCE_LOADER_KEY, Configuration.getProperty((String)"org.apache.sirona.reporting.resource-loader", (String)ClasspathResourceLoader.class.getName()));
        engine = new VelocityEngine(velocityConfiguration);
        mapping = filterMapping.isEmpty() ? context : context + filterMapping;
    }

    public static void htmlRender(PrintWriter writer, String template, Map<String, ?> variables) {
        boolean onlyBodyRendering;
        VelocityContext context = Templates.newVelocityContext(variables);
        context.put("mapping", (Object)mapping);
        context.put("currentTemplate", (Object)template);
        context.put("plugins", PluginRepository.PLUGIN_INFO);
        if (context.get("templateId") == null) {
            context.put("templateId", (Object)template.replace(".vm", ""));
        }
        Template velocityTemplate = (onlyBodyRendering = variables.containsKey("onlyBody")) ? engine.getTemplate("/templates/" + template, "UTF-8") : engine.getTemplate("/templates/page.vm", "UTF-8");
        velocityTemplate.merge((Context)context, (Writer)writer);
    }

    public static void render(PrintWriter writer, String template, Map<String, ?> variables) {
        VelocityContext context = Templates.newVelocityContext(variables);
        context.put("mapping", (Object)mapping);
        Template velocityTemplate = engine.getTemplate(template, "UTF-8");
        velocityTemplate.merge((Context)context, (Writer)writer);
    }

    private static VelocityContext newVelocityContext(Map<String, ?> variables) {
        VelocityContext context = variables.isEmpty() ? new VelocityContext() : new VelocityContext(variables);
        return context;
    }

    public static Object property(String key) {
        return engine.getProperty(key);
    }

    private Templates() {
    }
}

